/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.data.test;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.geoserver.catalog.Catalog;
import org.geoserver.data.test.CiteTestData;
import org.geoserver.data.test.MockCreator;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.util.IOUtils;

public class MockTestData
extends CiteTestData {
    File data = IOUtils.createRandomDirectory((String)"./target", (String)"mock", (String)"data");
    Catalog catalog;
    GeoServerSecurityManager secMgr;
    MockCreator mockCreator;
    boolean includeRaster;

    public MockTestData() throws IOException {
        this.data.delete();
        this.data.mkdir();
        this.mockCreator = new MockCreator();
    }

    public void setMockCreator(MockCreator mockCreator) {
        this.mockCreator = mockCreator;
    }

    public boolean isInludeRaster() {
        return this.includeRaster;
    }

    public void setIncludeRaster(boolean includeRaster) {
        this.includeRaster = includeRaster;
    }

    public Catalog getCatalog() {
        if (this.catalog == null) {
            try {
                this.catalog = this.mockCreator.createCatalog(this);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.catalog;
    }

    public GeoServerSecurityManager getSecurityManager() {
        if (this.secMgr == null) {
            try {
                this.secMgr = this.mockCreator.createSecurityManager(this);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.secMgr;
    }

    @Override
    public void setUp() throws Exception {
    }

    @Override
    public void tearDown() throws Exception {
        FileUtils.deleteDirectory((File)this.data);
    }

    @Override
    public File getDataDirectoryRoot() {
        return this.data;
    }

    @Override
    public boolean isTestDataAvailable() {
        return true;
    }
}

