/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config.util;

import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.config.impl.GeoServerImpl;
import org.geoserver.config.impl.ServiceInfoImpl;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.config.util.XStreamServiceLoader;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.Resource;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class XStreamServiceLoaderTest {
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();

    @Test
    public void testXstreamPersisterReusedIfCalledWithSameGeoServerInstance() throws Exception {
        GeoServerResourceLoader rl = new GeoServerResourceLoader(this.folder.getRoot());
        XStreamServiceLoader<ServiceInfo> loader = new XStreamServiceLoader<ServiceInfo>(rl, "test"){

            public Class<ServiceInfo> getServiceClass() {
                return ServiceInfo.class;
            }

            protected ServiceInfo createServiceFromScratch(GeoServer gs) {
                return new ServiceInfoImpl();
            }
        };
        loader = (XStreamServiceLoader)Mockito.spy((Object)loader);
        GeoServerImpl gs1 = new GeoServerImpl();
        GeoServerImpl gs2 = new GeoServerImpl();
        ServiceInfo service = loader.createServiceFromScratch((GeoServer)gs1);
        Resource datadirRoot = rl.get("");
        loader.save(service, (GeoServer)gs1, datadirRoot);
        ((XStreamServiceLoader)Mockito.verify((Object)loader, (VerificationMode)Mockito.times((int)1))).initXStreamPersister((XStreamPersister)ArgumentMatchers.any(XStreamPersister.class), (GeoServer)ArgumentMatchers.same((Object)gs1));
        loader.load((GeoServer)gs2);
        loader.load((GeoServer)gs2);
        ((XStreamServiceLoader)Mockito.verify((Object)loader, (VerificationMode)Mockito.times((int)1))).initXStreamPersister((XStreamPersister)ArgumentMatchers.any(XStreamPersister.class), (GeoServer)ArgumentMatchers.same((Object)gs2));
        loader.load((GeoServer)gs1);
        loader.load((GeoServer)gs1);
        ((XStreamServiceLoader)Mockito.verify((Object)loader, (VerificationMode)Mockito.times((int)2))).initXStreamPersister((XStreamPersister)ArgumentMatchers.any(XStreamPersister.class), (GeoServer)ArgumentMatchers.same((Object)gs1));
    }
}

