/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.impl;

import org.geoserver.catalog.impl.AttributeTypeInfoImpl;
import org.junit.Assert;
import org.junit.Test;

public class AttributeTypeInfoImplTest {
    @Test
    public void testQuoting() {
        this.assertNotQuoted("foo");
        this.assertNotQuoted("foo123");
        this.assertNotQuoted("FOO");
        this.assertNotQuoted("FOO123");
        this.assertNotQuoted("foo_bar");
        this.assertNotQuoted("Foo_Bar");
        this.assertQuoted("123foo");
        this.assertQuoted("foo.bar");
        this.assertQuoted("point");
        this.assertQuoted("POINT");
        this.assertQuoted("BBOX");
        this.assertQuoted("intersects");
    }

    private void assertNotQuoted(String name) {
        AttributeTypeInfoImpl a = new AttributeTypeInfoImpl();
        a.setName(name);
        Assert.assertEquals((Object)name, (Object)a.getSource());
    }

    private void assertQuoted(String name) {
        AttributeTypeInfoImpl a = new AttributeTypeInfoImpl();
        a.setName(name);
        Assert.assertEquals((Object)("\"" + name + "\""), (Object)a.getSource());
    }
}

