/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.easymock.EasyMock;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourcePool;
import org.geoserver.catalog.SLDHandler;
import org.geoserver.catalog.StyleGenerator;
import org.geoserver.catalog.StyleHandler;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.CatalogFactoryImpl;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.style.FeatureTypeStyle;
import org.geotools.api.style.NamedLayer;
import org.geotools.api.style.RasterSymbolizer;
import org.geotools.api.style.Rule;
import org.geotools.api.style.Style;
import org.geotools.api.style.StyledLayerDescriptor;
import org.geotools.api.style.Symbolizer;
import org.geotools.data.DataUtilities;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.xml.styling.SLDParser;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.vfny.geoserver.util.SLDValidator;

public class StyleGeneratorTest {
    @Test
    public void testCreateInWorkspace() throws Exception {
        ResourcePool rp = (ResourcePool)EasyMock.createNiceMock(ResourcePool.class);
        Catalog cat = (Catalog)EasyMock.createNiceMock(Catalog.class);
        EasyMock.expect((Object)cat.getFactory()).andReturn((Object)new CatalogFactoryImpl(null)).anyTimes();
        EasyMock.expect((Object)cat.getResourcePool()).andReturn((Object)rp).anyTimes();
        WorkspaceInfo ws = (WorkspaceInfo)EasyMock.createNiceMock(WorkspaceInfo.class);
        FeatureTypeInfo ft = (FeatureTypeInfo)EasyMock.createNiceMock(FeatureTypeInfo.class);
        EasyMock.expect((Object)ft.getName()).andReturn((Object)"foo").anyTimes();
        EasyMock.replay((Object[])new Object[]{rp, ft, ws, cat});
        StyleGenerator gen = new StyleGenerator(cat);
        gen.setWorkspace(ws);
        SimpleFeatureType schema = DataUtilities.createType((String)"foo", (String)"geom:Point");
        StyleInfo style = gen.createStyle((StyleHandler)new SLDHandler(), ft, (FeatureType)schema);
        Assert.assertNotNull((Object)style);
        Assert.assertNotNull((Object)style.getWorkspace());
    }

    @Test
    public void testGenericStyle() throws Exception {
        ResourcePool rp = (ResourcePool)EasyMock.createNiceMock(ResourcePool.class);
        rp.writeStyle((StyleInfo)EasyMock.anyObject(), (InputStream)EasyMock.anyObject());
        EasyMock.expectLastCall().andAnswer(() -> {
            Object[] args = EasyMock.getCurrentArguments();
            InputStream is = (InputStream)args[1];
            byte[] input = IOUtils.toByteArray((InputStream)is);
            SLDParser parser = new SLDParser(CommonFactoryFinder.getStyleFactory());
            parser.setInput((InputStream)new ByteArrayInputStream(input));
            StyledLayerDescriptor sld = parser.parseSLD();
            NamedLayer nl = (NamedLayer)sld.getStyledLayers()[0];
            Assert.assertEquals((Object)"foo", (Object)nl.getName());
            Style style = nl.getStyles()[0];
            Assert.assertEquals((Object)"A orange generic style", (Object)style.getDescription().getTitle().toString());
            Assert.assertEquals((long)1L, (long)style.featureTypeStyles().size());
            FeatureTypeStyle fts = (FeatureTypeStyle)style.featureTypeStyles().get(0);
            Assert.assertEquals((Object)"first", fts.getOptions().get("ruleEvaluation"));
            Assert.assertEquals((long)4L, (long)fts.rules().size());
            Assert.assertEquals((Object)"raster", (Object)((Rule)fts.rules().get(0)).getDescription().getTitle().toString());
            Assert.assertEquals((Object)"orange polygon", (Object)((Rule)fts.rules().get(1)).getDescription().getTitle().toString());
            Assert.assertEquals((Object)"orange line", (Object)((Rule)fts.rules().get(2)).getDescription().getTitle().toString());
            Assert.assertEquals((Object)"orange point", (Object)((Rule)fts.rules().get(3)).getDescription().getTitle().toString());
            SLDValidator validator = new SLDValidator();
            List errors = validator.validateSLD((InputStream)new ByteArrayInputStream(input));
            Assert.assertEquals((long)0L, (long)errors.size());
            return null;
        });
        Catalog cat = (Catalog)EasyMock.createNiceMock(Catalog.class);
        EasyMock.expect((Object)cat.getFactory()).andReturn((Object)new CatalogFactoryImpl(null)).anyTimes();
        EasyMock.expect((Object)cat.getResourcePool()).andReturn((Object)rp).anyTimes();
        WorkspaceInfo ws = (WorkspaceInfo)EasyMock.createNiceMock(WorkspaceInfo.class);
        FeatureTypeInfo ft = (FeatureTypeInfo)EasyMock.createNiceMock(FeatureTypeInfo.class);
        EasyMock.expect((Object)ft.getName()).andReturn((Object)"foo").anyTimes();
        EasyMock.replay((Object[])new Object[]{rp, ft, ws, cat});
        StyleGenerator gen = new StyleGenerator(cat){

            protected void randomizeRamp() {
            }
        };
        gen.setWorkspace(ws);
        SimpleFeatureType schema = DataUtilities.createType((String)"foo", (String)"geom:Geometry");
        StyleInfo style = gen.createStyle((StyleHandler)new SLDHandler(), ft, (FeatureType)schema);
        Assert.assertNotNull((Object)style);
        Assert.assertNotNull((Object)style.getWorkspace());
    }

    @Test
    public void testRasterStyle() throws Exception {
        ResourcePool rp = (ResourcePool)EasyMock.createNiceMock(ResourcePool.class);
        rp.writeStyle((StyleInfo)EasyMock.anyObject(), (InputStream)EasyMock.anyObject());
        EasyMock.expectLastCall().andAnswer(() -> {
            Object[] args = EasyMock.getCurrentArguments();
            InputStream is = (InputStream)args[1];
            byte[] input = IOUtils.toByteArray((InputStream)is);
            SLDParser parser = new SLDParser(CommonFactoryFinder.getStyleFactory());
            parser.setInput((InputStream)new ByteArrayInputStream(input));
            StyledLayerDescriptor sld = parser.parseSLD();
            NamedLayer nl = (NamedLayer)sld.getStyledLayers()[0];
            Assert.assertEquals((Object)"foo", (Object)nl.getName());
            Style style = nl.getStyles()[0];
            Assert.assertEquals((Object)"A raster style", (Object)style.getDescription().getTitle().toString());
            Assert.assertEquals((long)1L, (long)style.featureTypeStyles().size());
            FeatureTypeStyle fts = (FeatureTypeStyle)style.featureTypeStyles().get(0);
            Assert.assertEquals((long)1L, (long)fts.rules().size());
            MatcherAssert.assertThat((Object)((Symbolizer)((Rule)fts.rules().get(0)).symbolizers().get(0)), (Matcher)Matchers.instanceOf(RasterSymbolizer.class));
            SLDValidator validator = new SLDValidator();
            List errors = validator.validateSLD((InputStream)new ByteArrayInputStream(input));
            Assert.assertEquals((long)0L, (long)errors.size());
            return null;
        });
        Catalog cat = (Catalog)EasyMock.createNiceMock(Catalog.class);
        EasyMock.expect((Object)cat.getFactory()).andReturn((Object)new CatalogFactoryImpl(null)).anyTimes();
        EasyMock.expect((Object)cat.getResourcePool()).andReturn((Object)rp).anyTimes();
        WorkspaceInfo ws = (WorkspaceInfo)EasyMock.createNiceMock(WorkspaceInfo.class);
        CoverageInfo ci = (CoverageInfo)EasyMock.createNiceMock(CoverageInfo.class);
        EasyMock.expect((Object)ci.getName()).andReturn((Object)"foo").anyTimes();
        EasyMock.replay((Object[])new Object[]{rp, ci, ws, cat});
        StyleGenerator gen = new StyleGenerator(cat){

            protected void randomizeRamp() {
            }
        };
        gen.setWorkspace(ws);
        StyleInfo style = gen.createStyle((StyleHandler)new SLDHandler(), ci);
        Assert.assertNotNull((Object)style);
        Assert.assertNotNull((Object)style.getWorkspace());
    }
}

