/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.geoserver.catalog.ResourcePool;

public class ResourcePoolLatchedThread<P, R>
extends Thread {
    private CountDownLatch taskLatch;
    private CountDownLatch doneLatch;
    private ResourcePool resourcePool;
    private PoolBiFunction<P, R> function;
    private R result;
    private P funParam;
    private int maxAwaitBeforeStart;
    private List<Exception> errors = new ArrayList<Exception>();

    public ResourcePoolLatchedThread(CountDownLatch taskLatch, CountDownLatch doneLatch, ResourcePool pool, P funParam, PoolBiFunction<P, R> function) {
        this(taskLatch, doneLatch, 60, pool, funParam, function);
    }

    public ResourcePoolLatchedThread(CountDownLatch taskLatch, CountDownLatch doneLatch, int maxAwaitBeforeStart, ResourcePool pool, P funParam, PoolBiFunction<P, R> function) {
        this.taskLatch = taskLatch;
        this.doneLatch = doneLatch;
        this.maxAwaitBeforeStart = maxAwaitBeforeStart;
        this.resourcePool = pool;
        this.funParam = funParam;
        this.function = function;
    }

    @Override
    public void run() {
        try {
            this.taskLatch.await(this.maxAwaitBeforeStart, TimeUnit.SECONDS);
            this.result = this.function.apply(this.resourcePool, this.funParam);
            this.doneLatch.countDown();
        }
        catch (Exception e) {
            this.errors.add(e);
        }
    }

    public R getResult() {
        return this.result;
    }

    public List<Exception> getErrors() {
        return this.errors;
    }

    @FunctionalInterface
    public static interface PoolBiFunction<P, R> {
        public R apply(ResourcePool var1, P var2) throws IOException;
    }
}

