/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.geoserver.GeoServerConfigurationLock;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GeoServerConfigurationLockTest {
    private final GeoServerConfigurationLock lock = new GeoServerConfigurationLock();

    @Before
    public void beforeEach() {
        System.setProperty("CONFIGURATION_TRYLOCK_TIMEOUT", "100");
    }

    @After
    public void afterEach() {
        System.clearProperty("CONFIGURATION_TRYLOCK_TIMEOUT");
        Assert.assertFalse((String)"all locks shall have been released", (boolean)this.lock.isWriteLocked());
    }

    @Test(timeout=1000L)
    public void testLock_WriteLock() {
        Assert.assertNull((Object)this.lock.getCurrentLock());
        this.lock.lock(GeoServerConfigurationLock.LockType.WRITE);
        Assert.assertEquals((Object)GeoServerConfigurationLock.LockType.WRITE, (Object)this.lock.getCurrentLock());
        this.lock.unlock();
        Assert.assertNull((Object)this.lock.getCurrentLock());
    }

    @Test(timeout=1000L)
    public void testLock_ReadLock() {
        Assert.assertNull((Object)this.lock.getCurrentLock());
        this.lock.lock(GeoServerConfigurationLock.LockType.READ);
        Assert.assertEquals((Object)GeoServerConfigurationLock.LockType.READ, (Object)this.lock.getCurrentLock());
        this.lock.unlock();
        Assert.assertNull((Object)this.lock.getCurrentLock());
    }

    @Test(timeout=1000L)
    public void testLock_ReadLock_preserves_write_lock_if_alread_held() {
        Assert.assertNull((Object)this.lock.getCurrentLock());
        this.lock.lock(GeoServerConfigurationLock.LockType.WRITE);
        Assert.assertEquals((Object)GeoServerConfigurationLock.LockType.WRITE, (Object)this.lock.getCurrentLock());
        this.lock.lock(GeoServerConfigurationLock.LockType.READ);
        Assert.assertEquals((String)"A read lock request shall preserve the write lock if already held", (Object)GeoServerConfigurationLock.LockType.WRITE, (Object)this.lock.getCurrentLock());
        this.lock.unlock();
    }

    @Test(timeout=1000L)
    public void testTryUpgradeLock_fais_if_no_previous_lock_is_held() {
        Assert.assertNull((Object)this.lock.getCurrentLock());
        IllegalStateException ex = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> ((GeoServerConfigurationLock)this.lock).tryUpgradeLock());
        MatcherAssert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.containsString((String)"No lock currently held"));
    }

    @Test(timeout=1000L)
    public void testTryUpgradeLock_fails_if_already_holds_a_write_lock() {
        Assert.assertNull((Object)this.lock.getCurrentLock());
        this.lock.lock(GeoServerConfigurationLock.LockType.WRITE);
        IllegalStateException ex = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> ((GeoServerConfigurationLock)this.lock).tryUpgradeLock());
        MatcherAssert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.containsString((String)"Already owning a write lock"));
        Assert.assertEquals((Object)GeoServerConfigurationLock.LockType.WRITE, (Object)this.lock.getCurrentLock());
        this.lock.unlock();
    }

    @Test(timeout=1000L)
    public void testTryUpgradeLock() throws InterruptedException, ExecutionException {
        ExecutorService secondThread = Executors.newSingleThreadExecutor();
        try {
            this.lock.lock(GeoServerConfigurationLock.LockType.READ);
            secondThread.submit(() -> Assert.assertTrue((boolean)this.lock.tryLock(GeoServerConfigurationLock.LockType.READ))).get();
            Assert.assertEquals((Object)GeoServerConfigurationLock.LockType.READ, (Object)this.lock.getCurrentLock());
            RuntimeException ex = (RuntimeException)Assert.assertThrows(RuntimeException.class, () -> this.lock.tryUpgradeLock());
            MatcherAssert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.containsString((String)"Failed to upgrade lock from read to write state"));
            Assert.assertNull((String)"lock should have been lost after a failed tryUpgradeLock()", (Object)this.lock.getCurrentLock());
            this.lock.lock(GeoServerConfigurationLock.LockType.READ);
            secondThread.submit(() -> ((GeoServerConfigurationLock)this.lock).unlock()).get();
            this.lock.tryUpgradeLock();
            Assert.assertEquals((Object)GeoServerConfigurationLock.LockType.WRITE, (Object)this.lock.getCurrentLock());
        }
        finally {
            secondThread.shutdownNow();
            this.lock.unlock();
        }
    }

    @Test(timeout=1000L)
    public void testTryLock() {
        Assert.assertTrue((boolean)this.lock.tryLock(GeoServerConfigurationLock.LockType.READ));
        Assert.assertEquals((Object)GeoServerConfigurationLock.LockType.READ, (Object)this.lock.getCurrentLock());
        this.lock.unlock();
        Assert.assertNull((Object)this.lock.getCurrentLock());
        Assert.assertTrue((boolean)this.lock.tryLock(GeoServerConfigurationLock.LockType.WRITE));
        Assert.assertEquals((Object)GeoServerConfigurationLock.LockType.WRITE, (Object)this.lock.getCurrentLock());
        this.lock.unlock();
        Assert.assertNull((Object)this.lock.getCurrentLock());
    }

    @Test(timeout=1000L)
    public void testTryLock_false_if_write_lock_requested_while_holding_a_read_lock() {
        Assert.assertNull((Object)this.lock.getCurrentLock());
        Assert.assertTrue((boolean)this.lock.tryLock(GeoServerConfigurationLock.LockType.READ));
        Assert.assertEquals((Object)GeoServerConfigurationLock.LockType.READ, (Object)this.lock.getCurrentLock());
        Assert.assertFalse((boolean)this.lock.tryLock(GeoServerConfigurationLock.LockType.WRITE));
        Assert.assertEquals((Object)GeoServerConfigurationLock.LockType.READ, (Object)this.lock.getCurrentLock());
        this.lock.unlock();
        Assert.assertNull((Object)this.lock.getCurrentLock());
    }

    @Test(timeout=1000L)
    public void testTryLock_true_if_read_lock_requested_while_holding_a_write_lock() {
        Assert.assertTrue((boolean)this.lock.tryLock(GeoServerConfigurationLock.LockType.WRITE));
        Assert.assertEquals((Object)GeoServerConfigurationLock.LockType.WRITE, (Object)this.lock.getCurrentLock());
        Assert.assertTrue((boolean)this.lock.tryLock(GeoServerConfigurationLock.LockType.READ));
        Assert.assertEquals((String)"tryLock(READ) while holding a write lock shall preserve the write lock", (Object)GeoServerConfigurationLock.LockType.WRITE, (Object)this.lock.getCurrentLock());
        this.lock.unlock();
        Assert.assertNull((Object)this.lock.getCurrentLock());
        Assert.assertFalse((boolean)this.lock.isWriteLocked());
    }

    @Test(timeout=1000L)
    public void testUnlock() {
        Assert.assertNull((Object)this.lock.getCurrentLock());
        this.lock.unlock();
        this.lock.unlock();
        Assert.assertNull((Object)this.lock.getCurrentLock());
        this.lock.lock(GeoServerConfigurationLock.LockType.READ);
        this.lock.unlock();
        Assert.assertNull((Object)this.lock.getCurrentLock());
        this.lock.lock(GeoServerConfigurationLock.LockType.WRITE);
        this.lock.unlock();
        Assert.assertNull((Object)this.lock.getCurrentLock());
    }

    @Test(timeout=1000L)
    public void testLock_ReadLockIsReentrant() {
        this.testLockIsReentrant(GeoServerConfigurationLock.LockType.READ);
    }

    @Test(timeout=1000L)
    public void testLock_WriteLockIsReentrant() {
        this.testLockIsReentrant(GeoServerConfigurationLock.LockType.WRITE);
    }

    private void testLockIsReentrant(GeoServerConfigurationLock.LockType lockType) {
        Assert.assertNull((Object)this.lock.getCurrentLock());
        this.lock.lock(lockType);
        try {
            Assert.assertEquals((Object)lockType, (Object)this.lock.getCurrentLock());
            try {
                this.lock.lock(lockType);
                Assert.assertEquals((Object)lockType, (Object)this.lock.getCurrentLock());
            }
            finally {
                this.lock.unlock();
                Assert.assertEquals((String)(lockType + " lock should still be held"), (Object)lockType, (Object)this.lock.getCurrentLock());
            }
        }
        finally {
            this.lock.unlock();
            Assert.assertNull((Object)this.lock.getCurrentLock());
        }
        Assert.assertFalse((boolean)this.lock.isWriteLocked());
    }

    @Test(timeout=1000L)
    public void testTryReadLockIsReentrant() {
        this.testTryLockIsReentrant(GeoServerConfigurationLock.LockType.READ);
    }

    @Test(timeout=1000L)
    public void testTryWriteLockIsReentrant() {
        this.testTryLockIsReentrant(GeoServerConfigurationLock.LockType.WRITE);
    }

    private void testTryLockIsReentrant(GeoServerConfigurationLock.LockType lockType) {
        Assert.assertNull((Object)this.lock.getCurrentLock());
        try {
            Assert.assertTrue((boolean)this.lock.tryLock(lockType));
            Assert.assertEquals((Object)lockType, (Object)this.lock.getCurrentLock());
            try {
                Assert.assertTrue((boolean)this.lock.tryLock(lockType));
                Assert.assertEquals((Object)lockType, (Object)this.lock.getCurrentLock());
            }
            finally {
                this.lock.unlock();
                Assert.assertEquals((String)(lockType + " lock should still be held"), (Object)lockType, (Object)this.lock.getCurrentLock());
            }
        }
        finally {
            this.lock.unlock();
            Assert.assertNull((Object)this.lock.getCurrentLock());
        }
    }
}

