/* (c) 2023 Open Source Geospatial Foundation - all rights reserved
 * This code is licensed under the GPL 2.0 license, available at the root
 * application directory.
 */
package org.geoserver.filters;

import java.io.IOException;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/** A filter that restricts the HTTP methods that can be used to access GeoServer. */
public class HTTPMethodFilter implements GeoServerFilter {
    private static final List<String> HTTP_METHOD_OPTIONS =
            List.of("GET", "POST", "PUT", "DELETE", "HEAD", "PATCH", "OPTIONS");

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        // nothing to do
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain)
            throws IOException, ServletException {
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            HttpServletRequest httpRequest = (HttpServletRequest) request;
            HttpServletResponse httpResponse = (HttpServletResponse) response;
            if (!HTTP_METHOD_OPTIONS.contains(httpRequest.getMethod())) {
                httpResponse.sendError(HttpServletResponse.SC_METHOD_NOT_ALLOWED);
            } else {
                chain.doFilter(request, response);
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    @Override
    public void destroy() {
        // nothing to do
    }
}
