/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.system.status;

import java.util.List;
import org.geoserver.system.status.BaseSystemInfoCollector;
import org.geoserver.system.status.MetricInfo;
import org.geoserver.system.status.MetricValue;
import org.geoserver.system.status.OSHISystemInfoCollector;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.stereotype.Component;

@Component
public class OSHISystemInfoMonitor
extends BaseSystemInfoCollector
implements DisposableBean {
    private static final long serialVersionUID = 502867203324474735L;
    public static String NAME = OSHISystemInfoCollector.class.getSimpleName();
    private transient OSHISystemInfoCollector collector;

    public OSHISystemInfoMonitor() {
        if (this.getStatisticsStatus().booleanValue()) {
            this.collector = OSHISystemInfoMonitor.start();
        }
    }

    @Override
    List<MetricValue> retrieveSystemInfo(MetricInfo info) {
        if (this.getStatisticsStatus().booleanValue()) {
            return this.getCollector().retrieveSystemInfo(info);
        }
        return super.retrieveSystemInfo(info);
    }

    private OSHISystemInfoCollector getCollector() {
        try {
            OSHISystemInfoCollector thread = this.collector;
            if (thread == null || !thread.isAlive()) {
                this.collector = thread = OSHISystemInfoMonitor.start();
            }
            return thread;
        }
        catch (Throwable e) {
            this.collector = null;
            super.setStatisticsStatus(false);
            throw e;
        }
    }

    private static OSHISystemInfoCollector start() {
        OSHISystemInfoCollector collector = new OSHISystemInfoCollector();
        collector.setName(NAME);
        collector.setDaemon(true);
        collector.start();
        return collector;
    }

    public boolean isRunning() {
        return this.collector != null;
    }

    void stop() {
        OSHISystemInfoCollector thread = this.collector;
        if (thread != null) {
            this.collector = null;
            thread.interrupt();
        }
    }

    @Override
    public void setStatisticsStatus(Boolean status) {
        if (status.booleanValue()) {
            this.getCollector();
        } else {
            this.stop();
        }
        super.setStatisticsStatus(status);
    }

    public void destroy() {
        this.stop();
    }
}

