/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.urlchecks;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.config.util.XStreamPersisterFactory;
import org.geoserver.platform.FileWatcher;
import org.geoserver.platform.resource.Resource;
import org.geoserver.security.urlchecks.AbstractURLCheck;
import org.geoserver.security.urlchecks.RegexURLCheck;
import org.geoserver.security.urlchecks.URLChecksConfiguration;
import org.geotools.util.logging.Logging;

public class URLCheckDAO {
    static final Logger LOGGER = Logging.getLogger((String)URLCheckDAO.class.getCanonicalName());
    protected static final String CONFIG_FILE_NAME = "urlchecks.xml";
    private FileWatcher<URLChecksConfiguration> configurationWatcher;
    private XStreamPersister xp;
    URLChecksConfiguration configuration;

    public void saveChecks(List<AbstractURLCheck> checks) throws IOException {
        URLChecksConfiguration config = this.getConfiguration();
        config.setChecks(checks);
        this.saveConfiguration(config);
    }

    public URLCheckDAO(GeoServerDataDirectory dd, XStreamPersisterFactory xstreamPersisterFactory) {
        this.xp = xstreamPersisterFactory.createXMLPersister();
        XStream xs = this.xp.getXStream();
        xs.alias("regex", RegexURLCheck.class);
        xs.alias("checks", URLChecksConfiguration.class);
        xs.allowTypeHierarchy(AbstractURLCheck.class);
        xs.addImplicitCollection(URLChecksConfiguration.class, "checks", AbstractURLCheck.class);
        this.configurationWatcher = new URLChecksWatcher(dd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configurationAction(ThrowingRunnable action) throws IOException {
        Resource resource = this.configurationWatcher.getResource();
        Resource.Lock lock = resource.lock();
        try {
            action.run();
        }
        finally {
            lock.release();
        }
    }

    public void saveConfiguration(URLChecksConfiguration configuration) throws IOException {
        this.configurationAction(() -> {
            try (OutputStream fos = this.configurationWatcher.getResource().out();){
                this.xp.save(configuration, fos);
            }
        });
        this.configuration = configuration;
    }

    public void save(AbstractURLCheck check) {
        try {
            URLChecksConfiguration config = this.getConfiguration();
            List<AbstractURLCheck> checks = new ArrayList<AbstractURLCheck>(config.getChecks());
            if (!checks.stream().anyMatch(c -> c.getName().equals(check.getName()))) {
                checks.add(check);
            } else {
                checks = checks.stream().map(c -> c.getName().equals(check.getName()) ? check : c).collect(Collectors.toList());
            }
            config.setChecks(checks);
            this.saveConfiguration(config);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public URLChecksConfiguration getConfiguration() throws IOException {
        if (this.configurationWatcher.isModified() || this.configuration == null) {
            this.configurationAction(() -> {
                this.configuration = Optional.ofNullable((URLChecksConfiguration)this.configurationWatcher.read()).orElseGet(() -> new URLChecksConfiguration());
            });
        }
        return this.configuration;
    }

    public List<AbstractURLCheck> getChecks() throws IOException {
        return this.getConfiguration().getChecks();
    }

    public AbstractURLCheck getCheckByName(String name) throws IOException {
        return this.getChecks().stream().filter(c -> c.getName().equals(name)).findFirst().orElse(null);
    }

    public void add(AbstractURLCheck check) throws IOException {
        this.configurationAction(() -> {
            URLChecksConfiguration config = this.getConfiguration();
            if (config.getChecks().stream().anyMatch(c -> c.getName().equals(check.getName()))) {
                throw new IllegalArgumentException("A URL check with the same name already exists: " + check.getName());
            }
            ArrayList<AbstractURLCheck> checks = new ArrayList<AbstractURLCheck>(config.getChecks());
            checks.add(check);
            config.setChecks(checks);
            this.saveConfiguration(this.configuration);
        });
    }

    public void removeByName(String name) throws IOException {
        this.configurationAction(() -> {
            URLChecksConfiguration config = this.getConfiguration();
            List<AbstractURLCheck> checks = config.getChecks();
            if (checks.stream().noneMatch(c -> c.getName().equals(name))) {
                throw new IllegalArgumentException("No URL check with the specified name exists: " + name);
            }
            checks.removeIf(c -> c.getName().equals(name));
            this.saveConfiguration(this.configuration);
        });
    }

    public void reset() {
        this.configuration = null;
        this.configurationWatcher.setKnownLastModified(Long.MIN_VALUE);
    }

    public boolean isEnabled() throws IOException {
        return this.getConfiguration().isEnabled();
    }

    public void setEnabled(boolean enabled) throws IOException {
        URLChecksConfiguration config = this.getConfiguration();
        config.setEnabled(enabled);
        this.saveConfiguration(config);
    }

    private class URLChecksWatcher
    extends FileWatcher<URLChecksConfiguration> {
        public URLChecksWatcher(GeoServerDataDirectory dd) {
            super(dd.getSecurity(URLCheckDAO.CONFIG_FILE_NAME));
        }

        protected URLChecksConfiguration parseFileContents(InputStream in) throws IOException {
            return URLCheckDAO.this.xp.load(in, URLChecksConfiguration.class);
        }
    }

    private static interface ThrowingRunnable {
        public void run() throws IOException;
    }
}

