/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.password;

import java.util.Objects;
import org.geoserver.security.password.AbstractGeoserverPasswordEncoder;
import org.geoserver.security.password.PasswordEncodingType;
import org.springframework.dao.DataAccessException;
import org.springframework.security.crypto.password.PasswordEncoder;

public class GeoServerPlainTextPasswordEncoder
extends AbstractGeoserverPasswordEncoder {
    @Override
    protected PasswordEncoder createStringEncoder() {
        return new PasswordEncoder(){

            public boolean matches(CharSequence encPass, String rawPass) throws DataAccessException {
                return Objects.equals(encPass.toString(), this.encode(rawPass));
            }

            public String encode(CharSequence rawPass) throws DataAccessException {
                return rawPass.toString();
            }
        };
    }

    @Override
    protected AbstractGeoserverPasswordEncoder.CharArrayPasswordEncoder createCharEncoder() {
        return new AbstractGeoserverPasswordEncoder.CharArrayPasswordEncoder(){

            @Override
            public boolean isPasswordValid(String encPass, char[] rawPass, Object salt) {
                return Objects.equals(encPass, this.encodePassword(rawPass, salt));
            }

            @Override
            public String encodePassword(char[] rawPass, Object salt) {
                return String.valueOf(rawPass);
            }
        };
    }

    @Override
    public PasswordEncodingType getEncodingType() {
        return PasswordEncodingType.PLAIN;
    }

    @Override
    public String decode(String encPass) throws UnsupportedOperationException {
        return this.removePrefix(encPass);
    }

    @Override
    public char[] decodeToCharArray(String encPass) throws UnsupportedOperationException {
        return this.decode(encPass).toCharArray();
    }

    public String encode(CharSequence rawPassword) {
        return this.doEncodePassword(rawPassword.toString());
    }
}

