/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.geoserver.security.AccessMode;
import org.geoserver.security.GeoServerSecurityFilterChainProxy;
import org.geoserver.security.impl.GeoServerRole;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;

public class SecureTreeNode {
    static final Set<String> EVERYBODY = Collections.singleton("*");
    static final String ROOT_ROLE = GeoServerRole.ADMIN_ROLE.getAuthority();
    static int ROOT_DEPTH = 0;
    static int WS_LG_DEPTH = 1;
    static int RESOURCE_DEPTH = 2;
    Map<String, SecureTreeNode> children = new HashMap<String, SecureTreeNode>();
    SecureTreeNode parent;
    Map<AccessMode, Set<String>> authorizedRoles = new HashMap<AccessMode, Set<String>>();

    private SecureTreeNode(SecureTreeNode parent) {
        this.parent = parent;
    }

    public SecureTreeNode() {
        block3: for (AccessMode mode : AccessMode.values()) {
            switch (mode) {
                case ADMIN: {
                    this.authorizedRoles.put(mode, Collections.singleton(ROOT_ROLE));
                    continue block3;
                }
                default: {
                    this.authorizedRoles.put(mode, EVERYBODY);
                }
            }
        }
    }

    public SecureTreeNode getChild(String name) {
        return this.children.get(name);
    }

    public SecureTreeNode addChild(String name) {
        if (this.getChild(name) != null) {
            throw new IllegalArgumentException("This pathElement " + name + " is already among my children");
        }
        SecureTreeNode child = new SecureTreeNode(this);
        this.children.put(name, child);
        return child;
    }

    public boolean canAccess(Authentication user, AccessMode mode) {
        Set<String> roles = this.getAuthorizedRoles(mode);
        if (!GeoServerSecurityFilterChainProxy.isSecurityEnabledForCurrentRequest()) {
            return true;
        }
        if (roles == null) {
            return this.parent.canAccess(user, mode);
        }
        if (roles.equals(EVERYBODY)) {
            return true;
        }
        if (user == null || user.getAuthorities() == null) {
            return false;
        }
        for (GrantedAuthority authority : user.getAuthorities()) {
            String userRole = authority.getAuthority();
            if (!roles.contains(userRole) && !ROOT_ROLE.equals(userRole)) continue;
            return true;
        }
        return false;
    }

    public Set<String> getAuthorizedRoles(AccessMode mode) {
        return this.authorizedRoles.get((Object)mode);
    }

    public void setAuthorizedRoles(AccessMode mode, Set<String> roles) {
        this.authorizedRoles.put(mode, roles);
    }

    public SecureTreeNode getDeepestNode(String ... pathElements) {
        SecureTreeNode curr = this;
        SecureTreeNode result = this;
        for (String pathElement : pathElements) {
            SecureTreeNode next = curr.getChild(pathElement);
            if (next == null) {
                return result;
            }
            curr = next;
            if (curr.authorizedRoles == null || curr.authorizedRoles.isEmpty()) continue;
            result = curr;
        }
        return curr;
    }

    public SecureTreeNode getNode(String ... pathElements) {
        SecureTreeNode curr = this;
        for (String pathElement : pathElements) {
            SecureTreeNode next = curr.getChild(pathElement);
            if (next == null) {
                return null;
            }
            curr = next;
        }
        return curr;
    }

    Map<String, SecureTreeNode> getChildren() {
        return this.children;
    }

    public String toString() {
        return "SecureTreeNode [childrenCount=" + this.children.size() + ", hasParent=" + (this.parent != null) + ", authorizedRoles=" + this.authorizedRoles + "]";
    }

    int getDepth() {
        int depth = 0;
        HashSet<SecureTreeNode> visited = new HashSet<SecureTreeNode>();
        SecureTreeNode n = this;
        while (n.parent != null && !visited.contains(n.parent)) {
            ++depth;
            visited.add(n);
            n = n.parent;
        }
        return depth;
    }
}

