/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.geoserver.catalog.Catalog;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.resource.Resource;
import org.geoserver.security.AccessMode;
import org.geoserver.security.CatalogMode;
import org.geoserver.security.impl.AbstractAccessRuleDAO;
import org.geoserver.security.impl.DataAccessRule;
import org.geotools.api.feature.type.Name;
import org.geotools.feature.NameImpl;
import org.geotools.util.logging.Logging;

public class DataAccessRuleDAO
extends AbstractAccessRuleDAO<DataAccessRule> {
    public static final String KEY_MODE = "mode";
    private static final String KEY_SANDBOX = "filesystemSandbox";
    private static Pattern DOT = Pattern.compile("\\.");
    private static final Logger LOGGER = Logging.getLogger(DataAccessRuleDAO.class);
    static final String LAYERS = "layers.properties";
    Catalog rawCatalog;
    CatalogMode catalogMode = CatalogMode.HIDE;
    String filesystemSandbox;

    public static DataAccessRuleDAO get() {
        return (DataAccessRuleDAO)GeoServerExtensions.bean(DataAccessRuleDAO.class);
    }

    public DataAccessRuleDAO(GeoServerDataDirectory dd, Catalog rawCatalog) throws IOException {
        super(dd, LAYERS);
        this.rawCatalog = rawCatalog;
    }

    DataAccessRuleDAO(Catalog rawCatalog, Resource securityDir) {
        super(securityDir, LAYERS);
        this.rawCatalog = rawCatalog;
    }

    public CatalogMode getMode() {
        this.checkPropertyFile(false);
        return this.catalogMode;
    }

    @Override
    protected void loadRules(Properties props) {
        ConcurrentSkipListSet<DataAccessRule> result = new ConcurrentSkipListSet<DataAccessRule>();
        CatalogMode catalogMode = CatalogMode.HIDE;
        this.filesystemSandbox = null;
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String ruleKey = (String)entry.getKey();
            String ruleValue = (String)entry.getValue();
            if (KEY_MODE.equalsIgnoreCase(ruleKey)) {
                try {
                    catalogMode = CatalogMode.valueOf(ruleValue.toUpperCase());
                }
                catch (Exception e) {
                    LOGGER.warning("Invalid security mode " + ruleValue + " acceptable values are " + Arrays.asList(CatalogMode.values()));
                }
                continue;
            }
            if (KEY_SANDBOX.equalsIgnoreCase(ruleKey)) {
                this.filesystemSandbox = ruleValue;
                continue;
            }
            DataAccessRule rule = this.parseDataAccessRule(ruleKey, ruleValue);
            if (rule == null) continue;
            if (result.contains(rule)) {
                LOGGER.warning("Rule " + ruleKey + "." + ruleValue + " overwrites another rule on the same path");
            }
            result.add(rule);
        }
        if (result.isEmpty()) {
            result.add(new DataAccessRule(DataAccessRule.READ_ALL));
            result.add(new DataAccessRule(DataAccessRule.WRITE_ALL));
        }
        this.catalogMode = catalogMode;
        this.rules = result;
    }

    DataAccessRule parseDataAccessRule(String ruleKey, String ruleValue) {
        AccessMode mode;
        String modeAlias;
        String layerName;
        String rule = ruleKey + "=" + ruleValue;
        String[] elements = DataAccessRuleDAO.parseElements(ruleKey);
        if (elements.length != 3 && elements.length != 2) {
            LOGGER.warning("Invalid rule " + rule + ", the expected format is workspace.layer.mode=role1,role2,... or globalGroup.mode=role1,role2,...");
            return null;
        }
        String root = elements[0];
        if (elements.length == 3) {
            layerName = elements[1];
            modeAlias = elements[2];
        } else {
            layerName = null;
            modeAlias = elements[1];
        }
        Set<String> roles = this.parseRoles(ruleValue);
        if (layerName != null) {
            if (!"*".equals(root) && this.rawCatalog.getWorkspaceByName(root) == null) {
                LOGGER.warning("Namespace/Workspace " + root + " is unknown in rule " + rule);
            }
            if (LOGGER.isLoggable(Level.FINE) && !"*".equals(layerName) && this.rawCatalog.getLayerByName((Name)new NameImpl(root, layerName)) == null && this.rawCatalog.getLayerGroupByName(root, layerName) == null) {
                LOGGER.fine("Layer " + root + ":" + layerName + " is unknown in rule: " + rule);
            }
        } else if (!"*".equals(root) && this.rawCatalog.getLayerGroupByName(root) == null) {
            LOGGER.warning("Global layer group " + root + " is unknown in rule " + rule);
        }
        if ((mode = AccessMode.getByAlias(modeAlias)) == null) {
            LOGGER.warning("Unknown access mode " + modeAlias + " in " + ruleKey + ", skipping rule " + rule);
            return null;
        }
        if ("*".equals(root) && !"*".equals(layerName)) {
            LOGGER.warning("Invalid rule " + rule + ", when namespace is * then also layer must be *. Skipping rule " + rule);
            return null;
        }
        if (mode == AccessMode.ADMIN && !"*".equals(layerName)) {
            LOGGER.warning("Invalid rule " + rule + ", admin (a) privileges may only be applied globally to a workspace, layer must be *, skipping rule");
            return null;
        }
        return new DataAccessRule(root, layerName, mode, roles);
    }

    @Override
    protected Properties toProperties() {
        Properties props = new Properties();
        props.put(KEY_MODE, this.catalogMode.toString());
        if (this.filesystemSandbox != null) {
            props.put(KEY_SANDBOX, this.filesystemSandbox);
        }
        for (DataAccessRule rule : this.rules) {
            StringBuilder sbKey = new StringBuilder(DOT.matcher(rule.getRoot()).replaceAll("\\\\."));
            if (!rule.isGlobalGroupRule()) {
                sbKey.append(".").append(DOT.matcher(rule.getLayer()).replaceAll("\\\\."));
            }
            sbKey.append(".").append(rule.getAccessMode().getAlias());
            props.put(sbKey.toString(), rule.getValue());
        }
        return props;
    }

    /*
     * WARNING - void declaration
     */
    static String[] parseElements(String path) {
        String[] rawParse = path.trim().split("\\s*\\.\\s*");
        ArrayList<void> result = new ArrayList<void>();
        String prefix = null;
        for (String string : rawParse) {
            void var7_7;
            if (prefix != null) {
                String string2 = prefix + "." + string;
            }
            if (var7_7.endsWith("\\")) {
                prefix = var7_7.substring(0, var7_7.length() - 1);
                continue;
            }
            result.add(var7_7);
            prefix = null;
        }
        return result.toArray(new String[result.size()]);
    }

    public void setCatalogMode(CatalogMode catalogMode) {
        this.catalogMode = catalogMode;
    }

    public static CatalogMode getByAlias(String alias) {
        for (CatalogMode mode : CatalogMode.values()) {
            if (!mode.name().equals(alias)) continue;
            return mode;
        }
        return null;
    }

    public SortedSet<DataAccessRule> getRulesAssociatedWithRole(String role) {
        TreeSet<DataAccessRule> result = new TreeSet<DataAccessRule>();
        for (DataAccessRule rule : this.getRules()) {
            if (!rule.getRoles().contains(role)) continue;
            result.add(rule);
        }
        return result;
    }

    public String getFilesystemSandbox() {
        return this.filesystemSandbox;
    }

    public void setFilesystemSandbox(String filesystemSandbox) {
        if (filesystemSandbox != null && filesystemSandbox.startsWith("file://")) {
            filesystemSandbox = filesystemSandbox.substring("file://".length());
        }
        this.filesystemSandbox = filesystemSandbox;
    }
}

