/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.csp.predicate;

import com.google.common.base.Preconditions;
import java.util.regex.Pattern;
import org.geoserver.security.csp.CSPHttpRequestWrapper;
import org.geoserver.security.csp.CSPUtils;
import org.geoserver.security.csp.predicate.CSPPredicate;

public class CSPPredicateProperty
implements CSPPredicate {
    private final String key;
    private final Pattern valueRegex;
    private final String propertyValue;
    private final boolean propertyMatches;

    public CSPPredicateProperty(String key, String valueRegex) {
        Preconditions.checkArgument((boolean)CSPUtils.PROPERTY_KEY_REGEX.matcher(key).matches(), (String)"Property key not allowed: %s", (Object)key);
        this.key = key;
        this.valueRegex = Pattern.compile(valueRegex);
        this.propertyValue = CSPUtils.getStringProperty(this.key, "");
        this.propertyMatches = this.valueRegex.matcher(this.propertyValue).matches();
    }

    @Override
    public boolean test(CSPHttpRequestWrapper request) {
        String value;
        if (this.propertyValue.isEmpty() && !(value = request.getConfig().getField(this.key)).isEmpty()) {
            return this.valueRegex.matcher(value).matches();
        }
        return this.propertyMatches;
    }
}

