/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.config.impl.GeoServerLifecycleHandler;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.Request;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.security.AbstractCatalogFilter;
import org.geotools.util.SuppressFBWarnings;

public class DisabledServiceResourceFilter
extends AbstractCatalogFilter
implements GeoServerLifecycleHandler {
    public static String PROPERTY = "org.geoserver.service.disabled";
    protected static List<String> DEFAULT_SERVICE_TYPES;

    private boolean isFilterSubject() {
        return this.request() != null && this.request().getService() != null && this.request().getRequest() != null;
    }

    private Request request() {
        return (Request)Dispatcher.REQUEST.get();
    }

    @Override
    public boolean hideLayer(LayerInfo layer) {
        return this.hideResource(layer.getResource());
    }

    @Override
    public boolean hideResource(ResourceInfo resource) {
        if (this.isFilterSubject()) {
            List<String> disabledServices = DisabledServiceResourceFilter.disabledServices(resource);
            String service = this.request().getService();
            return disabledServices.stream().anyMatch(serviceType -> StringUtils.equalsIgnoreCase((CharSequence)service, (CharSequence)serviceType));
        }
        return false;
    }

    private static List<String> defaultDisabledServiceTypes() {
        if (DEFAULT_SERVICE_TYPES == null) {
            String globalEnv = GeoServerExtensions.getProperty((String)PROPERTY);
            DEFAULT_SERVICE_TYPES = StringUtils.isNotBlank((CharSequence)globalEnv) ? Arrays.asList(globalEnv.split(",")) : Collections.emptyList();
        }
        return DEFAULT_SERVICE_TYPES;
    }

    public static List<String> disabledServices(ResourceInfo resource) {
        List<Object> disabledServices = resource.isServiceConfiguration() ? (CollectionUtils.isEmpty(resource.getDisabledServices()) ? Collections.emptyList() : resource.getDisabledServices()) : DisabledServiceResourceFilter.defaultDisabledServiceTypes();
        return disabledServices;
    }

    @Override
    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
    public void onReset() {
        DEFAULT_SERVICE_TYPES = null;
    }

    @Override
    public void onDispose() {
    }

    @Override
    public void beforeReload() {
    }

    @Override
    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
    public void onReload() {
        DEFAULT_SERVICE_TYPES = null;
    }
}

