/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.geoserver.security.AccessLimits;
import org.geoserver.security.CatalogMode;
import org.geotools.api.filter.Filter;
import org.geotools.filter.v1_0.OGC;
import org.geotools.filter.v1_1.OGCConfiguration;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.Encoder;
import org.geotools.xsd.Parser;

public class DataAccessLimits
extends AccessLimits {
    private static final OGCConfiguration CONFIGURATION = new OGCConfiguration();
    private static final long serialVersionUID = 2594922992934373705L;
    transient Filter readFilter;

    public DataAccessLimits(CatalogMode mode, Filter readFilter) {
        super(mode);
        this.readFilter = readFilter;
    }

    public Filter getReadFilter() {
        return this.readFilter;
    }

    public void setReadFilter(Filter readFilter) {
        this.readFilter = readFilter;
    }

    @Override
    public CatalogMode getMode() {
        return this.mode;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.readFilter = this.readFilter(in);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        this.writeFilter(this.readFilter, out);
    }

    protected void writeFilter(Filter filter, ObjectOutputStream out) throws IOException {
        if (filter != null) {
            if (filter != Filter.INCLUDE && filter != Filter.EXCLUDE) {
                try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                    Encoder encoder = new Encoder((Configuration)CONFIGURATION);
                    encoder.encode((Object)filter, OGC.Filter, (OutputStream)bos);
                    out.writeObject(bos.toByteArray());
                }
            } else {
                out.writeObject(filter);
            }
        } else {
            out.writeObject(null);
        }
    }

    protected Filter readFilter(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Object serializedReadFilter = in.readObject();
        if (serializedReadFilter != null) {
            if (serializedReadFilter != Filter.INCLUDE && serializedReadFilter != Filter.EXCLUDE) {
                try {
                    Parser p = new Parser((Configuration)CONFIGURATION);
                    return (Filter)p.parse((InputStream)new ByteArrayInputStream((byte[])serializedReadFilter));
                }
                catch (Exception e) {
                    throw (IOException)new IOException("Failed to parse filter").initCause(e);
                }
            }
            return (Filter)serializedReadFilter;
        }
        return null;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.readFilter == null ? 0 : this.readFilter.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataAccessLimits other = (DataAccessLimits)obj;
        return !(this.readFilter == null ? other.readFilter != null : !this.readFilter.equals(other.readFilter));
    }
}

