/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geotools.api.feature.type.Name;
import org.geotools.feature.NameImpl;
import org.geotools.util.SuppressFBWarnings;
import org.geotools.util.logging.Logging;
import org.springframework.web.servlet.handler.SimpleUrlHandlerMapping;

public class OWSHandlerMapping
extends SimpleUrlHandlerMapping {
    static final Logger LOGGER = Logging.getLogger(OWSHandlerMapping.class);
    Catalog catalog;

    public OWSHandlerMapping(Catalog catalog) {
        this.catalog = catalog;
    }

    @SuppressFBWarnings(value={"NP_NONNULL_PARAM_VIOLATION"})
    protected Object lookupHandler(String urlPath, HttpServletRequest request) throws Exception {
        int i;
        int j;
        Object h = super.lookupHandler(urlPath, request);
        if (h == null && (j = urlPath.indexOf("/", i = urlPath.startsWith("/") ? 1 : 0)) > i) {
            String first = urlPath.substring(i, j);
            String last = urlPath.substring(j);
            WorkspaceInfo ws = this.catalog.getWorkspaceByName(first);
            if (ws == null && LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.fine("Could not find workspace " + first + ", trying a layer group lookup");
            }
            if (ws != null) {
                String wsName = first;
                j = last.indexOf("/", 1);
                if (j != -1) {
                    first = last.substring(1, j);
                    NamespaceInfo ns = this.catalog.getNamespaceByPrefix(wsName);
                    if (ns != null) {
                        boolean layerFound;
                        boolean bl = layerFound = this.catalog.getLayerByName((Name)new NameImpl(ns.getURI(), first)) != null;
                        if (!layerFound && LOGGER.isLoggable(Level.FINEST)) {
                            LOGGER.fine("Could not find layer " + first + ", trying a layer group lookup");
                        }
                        if (layerFound) {
                            last = last.substring(j);
                        } else if (this.catalog.getLayerGroupByName(ws, first) != null) {
                            last = last.substring(j);
                        } else {
                            LOGGER.fine("Could not find a layer group named " + wsName + ":" + first);
                        }
                    }
                }
                h = super.lookupHandler(last, request);
            } else if (this.catalog.getLayerGroupByName((WorkspaceInfo)null, first) != null) {
                h = super.lookupHandler(last, request);
            } else {
                LOGGER.fine("Could not find a layer group named " + first);
            }
        }
        return h;
    }

    public String toString() {
        return "OWSHandlerMapping[" + this.getHandlerMap() + "]";
    }
}

