/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.logging;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.geoserver.config.LoggingInfo;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.config.util.XStreamPersisterFactory;
import org.geoserver.logging.LegacyLoggingImporter;
import org.geoserver.logging.LoggingUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.ResourceStore;
import org.geotools.util.logging.Logging;

public class LoggingStartupContextListener
implements ServletContextListener {
    static Logger LOGGER;

    public void contextDestroyed(ServletContextEvent event) {
    }

    public void contextInitialized(ServletContextEvent event) {
        ServletContext context = event.getServletContext();
        String relinquishLoggingControl = GeoServerExtensions.getProperty((String)"RELINQUISH_LOG4J_CONTROL", (ServletContext)context);
        LoggingUtils.relinquishLog4jControl = Boolean.valueOf(relinquishLoggingControl);
        if (LoggingUtils.relinquishLog4jControl) {
            LoggingStartupContextListener.getLogger().info("RELINQUISH_LOG4J_CONTROL on, won't attempt to reconfigure LOG4J");
            return;
        }
        String updateBuiltInLoggingProfiles = GeoServerExtensions.getProperty((String)"UPDATE_BUILT_IN_LOGGING_PROFILES", (ServletContext)context);
        LoggingUtils.updateBuiltInLoggingProfiles = Boolean.valueOf(updateBuiltInLoggingProfiles);
        try {
            File baseDir = new File(GeoServerResourceLoader.lookupGeoServerDataDirectory((ServletContext)context));
            GeoServerResourceLoader loader = new GeoServerResourceLoader(baseDir);
            LoggingInfo loginfo = LoggingStartupContextListener.getLogging((ResourceStore)loader);
            if (loginfo != null) {
                String location = LoggingUtils.getLogFileLocation(loginfo.getLocation(), context);
                LoggingUtils.initLogging(loader, loginfo.getLevel(), !loginfo.isStdOutLogging(), false, location);
            } else {
                File f = loader.find("services.xml");
                if (f != null) {
                    LegacyLoggingImporter loggingImporter = new LegacyLoggingImporter();
                    loggingImporter.imprt(baseDir);
                    String location = LoggingUtils.getLogFileLocation(loggingImporter.getLogFile(), context);
                    LoggingUtils.initLogging(loader, loggingImporter.getConfigFileName(), loggingImporter.getSuppressStdOutLogging(), false, location);
                } else {
                    LoggingStartupContextListener.getLogger().log(Level.WARNING, "Could not find GeoServer logging.xml (or old services.xml) settings for logging");
                }
            }
        }
        catch (Exception e) {
            LoggingStartupContextListener.getLogger().log(Level.SEVERE, "Could not reconfigure LOG4J loggers", e);
        }
    }

    @Nullable
    public static LoggingInfo getLogging(ResourceStore store) throws IOException {
        Resource f = store.get("logging.xml");
        if (f != null && f.getType() == Resource.Type.RESOURCE) {
            XStreamPersister xp = new XStreamPersisterFactory().createXMLPersister();
            try (BufferedInputStream in = new BufferedInputStream(f.in());){
                LoggingInfo loginfo;
                LoggingInfo loggingInfo = loginfo = xp.load(in, LoggingInfo.class);
                return loggingInfo;
            }
        }
        return null;
    }

    static Logger getLogger() {
        if (LOGGER == null) {
            LOGGER = Logging.getLogger((String)"org.geoserver.logging");
        }
        return LOGGER;
    }
}

