/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.logging;

import java.io.File;
import java.util.Map;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.Node;
import org.apache.logging.log4j.core.config.xml.XmlConfiguration;
import org.geoserver.platform.resource.Paths;
import org.geotools.util.logging.Log4J2Logger;

public class GeoServerXMLConfiguration
extends XmlConfiguration {
    protected static final String CONSOLE_NODE = "Console";
    protected static final String NAME_ATTRIBUTE = "name";
    protected static final String STDOUT = "stdout";
    protected static final String GEOSERVERLOGFILE = "geoserverlogfile";
    protected static final String APPENDER_REF_NODE = "AppenderRef";
    protected static final String REF_NODE = "ref";
    protected static final String ROLLING_FILE_NODE = "RollingFile";
    protected static final String FILE_APPENDER_NODE = "FileAppender";
    protected static final String APPENDERS_NODE = "Appenders";
    protected static final String APPENDER_NODE = "Appender";
    protected static final String LOGGERS_NODE = "Loggers";
    protected static final String LOGGER_NODE = "Logger";
    public static final String ROOT_NODE = "Root";
    String loggingLocation = null;
    boolean suppressFileLogging = false;
    boolean suppressStdOutLogging = false;

    public GeoServerXMLConfiguration(LoggerContext loggerContext, ConfigurationSource source) {
        super(loggerContext, source);
    }

    protected void preConfigure(Node node) {
        if (this.suppressFileLogging) {
            this.stripGeoServerLogFile(node);
        }
        if (this.suppressStdOutLogging) {
            this.stripConsoleStout(node);
        }
        if (GeoServerXMLConfiguration.isGeoServerLogFile(node, ROLLING_FILE_NODE)) {
            this.fixRollingFileAppender(node);
        }
        if (GeoServerXMLConfiguration.isGeoServerLogFile(node, FILE_APPENDER_NODE)) {
            this.fixFileAppender(node);
        }
        super.preConfigure(node);
    }

    protected void stripGeoServerLogFile(Node node) {
        if (this.isType(node, APPENDERS_NODE)) {
            node.getChildren().removeIf(appender -> GeoServerXMLConfiguration.isGeoServerLogFile(appender, ROLLING_FILE_NODE) || GeoServerXMLConfiguration.isGeoServerLogFile(appender, FILE_APPENDER_NODE));
        }
        if (this.isType(node, LOGGERS_NODE)) {
            for (Node logger2 : node.getChildren()) {
                if (!this.isType(logger2, LOGGER_NODE) && !this.isType(logger2, ROOT_NODE)) continue;
                logger2.getChildren().removeIf(ref -> GeoServerXMLConfiguration.isAppenderRef(ref, GEOSERVERLOGFILE));
            }
            node.getChildren().removeIf(logger -> logger.getChildren().isEmpty());
        }
    }

    protected void stripConsoleStout(Node node) {
        if (this.isType(node, APPENDERS_NODE)) {
            node.getChildren().removeIf(appender -> GeoServerXMLConfiguration.isConsoleStout(appender));
        }
        if (this.isType(node, LOGGERS_NODE)) {
            for (Node logger2 : node.getChildren()) {
                if (!this.isType(logger2, LOGGER_NODE) && !this.isType(logger2, ROOT_NODE)) continue;
                logger2.getChildren().removeIf(ref -> GeoServerXMLConfiguration.isAppenderRef(ref, STDOUT));
            }
            node.getChildren().removeIf(logger -> logger.getChildren().isEmpty());
        }
    }

    protected boolean isType(Node node, String type) {
        return node != null && node.getName() != null && node.getName().equalsIgnoreCase(type);
    }

    static final String attributeGet(Node node, String name) {
        if (node != null && name != null) {
            for (Map.Entry attribute : node.getAttributes().entrySet()) {
                if (!((String)attribute.getKey()).equalsIgnoreCase(name)) continue;
                return (String)attribute.getValue();
            }
        }
        return null;
    }

    static final String attributePut(Node node, String name, String value) {
        if (node != null && name != null) {
            for (Map.Entry entry : node.getAttributes().entrySet()) {
                if (!((String)entry.getKey()).equalsIgnoreCase(name)) continue;
                return entry.setValue(value);
            }
            return node.getAttributes().put(name, value);
        }
        return null;
    }

    static boolean isAppenderRef(Node node, String refName) {
        return refName != null && node != null && node.getName() != null && node.getName().equalsIgnoreCase(APPENDER_REF_NODE) && refName.equalsIgnoreCase(GeoServerXMLConfiguration.attributeGet(node, REF_NODE));
    }

    static boolean isConsoleStout(Node node) {
        return node != null && node.getName() != null && node.getName().equalsIgnoreCase(CONSOLE_NODE) && STDOUT.equalsIgnoreCase(GeoServerXMLConfiguration.attributeGet(node, NAME_ATTRIBUTE));
    }

    static boolean isGeoServerLogFile(Node node, String type) {
        return type != null && node != null && node.getName() != null && node.getName().equalsIgnoreCase(type) && GEOSERVERLOGFILE.equalsIgnoreCase(GeoServerXMLConfiguration.attributeGet(node, NAME_ATTRIBUTE));
    }

    protected void fixFileAppender(Node node) {
        String fileName = this.fileName();
        String fileNameTemplate = GeoServerXMLConfiguration.attributeGet(node, "fileName");
        LOGGER.debug("Preconfiguration geoserverlogfile.FileAppender.filename=", (Object)fileNameTemplate);
        String path = GeoServerXMLConfiguration.applyPathTemplate(fileName, fileNameTemplate);
        GeoServerXMLConfiguration.attributePut(node, "filename", path);
        LOGGER.debug("                 geoserverlogfile.FileAppender.filename=", (Object)path);
    }

    protected void fixRollingFileAppender(Node node) {
        String filePatternTemplate;
        String fileName = this.fileName();
        String fileNameTemplate = GeoServerXMLConfiguration.attributeGet(node, "fileName");
        if (fileNameTemplate != null) {
            LOGGER.debug("Preconfiguration geoserverlogfile.RollingFile.filename=", (Object)fileNameTemplate);
            String path = GeoServerXMLConfiguration.applyPathTemplate(fileName, fileNameTemplate);
            GeoServerXMLConfiguration.attributePut(node, "fileName", path);
            LOGGER.debug("                 geoserverlogfile.RollingFile.filename=", (Object)path);
        }
        if ((filePatternTemplate = GeoServerXMLConfiguration.attributeGet(node, "filePattern")) != null) {
            LOGGER.debug("Preconfiguration geoserverlogfile.RollingFile.filePattern=", (Object)filePatternTemplate);
            String pattern = GeoServerXMLConfiguration.applyPathTemplate(fileName, filePatternTemplate);
            GeoServerXMLConfiguration.attributePut(node, "filePattern", pattern);
            LOGGER.debug("                 geoserverlogfile.RollingFile.filePattern=", (Object)pattern);
        }
    }

    protected String fileName() {
        File check;
        String fileName;
        String string = fileName = this.loggingLocation != null ? this.loggingLocation : "logs/geoserver.log";
        if (fileName.startsWith("logs/") && (check = new File("pom.xml")).exists()) {
            return "target/" + fileName;
        }
        return fileName;
    }

    static String applyPathTemplate(String path, String template) {
        if (path.contains("$") || path.contains("%")) {
            return template;
        }
        String ext = Paths.extension((String)path);
        if (ext == null) {
            ext = ".log";
        }
        if (template.contains(".")) {
            ext = template.substring(template.lastIndexOf("."));
        }
        if (template.contains("-%")) {
            ext = template.substring(template.indexOf("-%"));
        } else if (template.contains("%")) {
            ext = template.substring(template.indexOf("%"));
        }
        if (template.contains("-$") && !ext.contains("-$")) {
            ext = template.substring(template.indexOf("-$"));
        } else if (template.contains("$") && !ext.contains("$")) {
            ext = template.substring(template.indexOf("$"));
        }
        if (Paths.extension((String)path) != null && ext.contains(".log")) {
            ext = ext.replace(".log", "." + Paths.extension((String)path));
        }
        if (path.lastIndexOf(".") == -1) {
            return path + ext;
        }
        return path.substring(0, path.lastIndexOf(".")) + ext;
    }

    protected void doConfigure() {
        LOGGER.debug("Custom CONFIG level=" + Log4J2Logger.CONFIG.intLevel());
        LOGGER.debug("Custom FINEST level=" + Log4J2Logger.FINEST.intLevel());
        super.doConfigure();
        if (this.fileName() != null) {
            String fileName;
            RollingFileAppender fileAppender;
            LOGGER.debug("External logfileLocation provided:" + this.fileName());
            Appender appender = (Appender)this.getAppenders().get(GEOSERVERLOGFILE);
            if (appender instanceof RollingFileAppender) {
                fileAppender = (RollingFileAppender)appender;
                fileName = fileAppender.getFileName();
                String filePattern = fileAppender.getFilePattern();
                LOGGER.debug("Postconfigure geoserverlogfile.filename=" + fileName);
                LOGGER.debug("Postconfigure geoserverlogfile.filePattern=" + filePattern);
            } else if (appender instanceof FileAppender) {
                fileAppender = (FileAppender)appender;
                fileName = fileAppender.getFileName();
                LOGGER.debug("Postconfigure geoserverlogfile.filename=" + fileName);
            }
        }
        if (this.suppressFileLogging) {
            if (this.getAppenders().containsKey(GEOSERVERLOGFILE)) {
                LOGGER.warn("Appender 'geoserverlogfile' expected to be suppressed");
            }
            for (LoggerConfig loggerConfig : this.getLoggers().values()) {
                if (!loggerConfig.getAppenders().containsKey(GEOSERVERLOGFILE)) continue;
                LOGGER.warn("Logger '" + loggerConfig.getName() + "' includes suppressed 'geoserverlogfile':" + loggerConfig.getAppenders().get(GEOSERVERLOGFILE));
            }
        }
        if (this.suppressStdOutLogging) {
            if (this.getAppenders().containsKey(STDOUT)) {
                LOGGER.warn("Appender 'stdout' expected to be suppressed");
            }
            for (LoggerConfig loggerConfig : this.getLoggers().values()) {
                if (!loggerConfig.getAppenders().containsKey(STDOUT)) continue;
                LOGGER.warn("Logger '" + loggerConfig.getName() + "' includes suppressed 'stdout':" + loggerConfig.getAppenders().get(STDOUT));
            }
        }
    }
}

