/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config.util;

import java.util.ArrayList;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.geoserver.catalog.LayerIdentifierInfo;
import org.geoserver.catalog.impl.LayerIdentifier;

public class LayerIdentifierInfoListConverter {
    private static final String AUTHORITY = "authority";
    private static final String IDENTIFIER = "identifier";

    public static List<LayerIdentifierInfo> fromString(String str) throws IllegalArgumentException {
        try {
            JSONArray array = JSONArray.fromObject((Object)str);
            int size = array.size();
            ArrayList<LayerIdentifierInfo> list2 = new ArrayList<LayerIdentifierInfo>(size);
            for (int i = 0; i < size; ++i) {
                JSONObject jsonAuth = array.getJSONObject(i);
                LayerIdentifier id = new LayerIdentifier();
                id.setAuthority(jsonAuth.getString(AUTHORITY));
                id.setIdentifier(jsonAuth.getString(IDENTIFIER));
                list2.add(id);
            }
            return list2;
        }
        catch (JSONException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public static String toString(List<LayerIdentifierInfo> list2) {
        if (list2 == null || list2.isEmpty()) {
            return null;
        }
        JSONArray array = new JSONArray();
        for (LayerIdentifierInfo id : list2) {
            if (id == null) continue;
            JSONObject jsonId = new JSONObject();
            jsonId.put((Object)AUTHORITY, (Object)id.getAuthority());
            jsonId.put((Object)IDENTIFIER, (Object)id.getIdentifier());
            array.add((Object)jsonId);
        }
        if (array.isEmpty()) {
            return null;
        }
        String serialized = array.toString();
        return serialized;
    }
}

