/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config;

import java.util.List;
import org.geoserver.config.ConfigurationListenerAdapter;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.GeoServerInitializer;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.resource.GlobalLockProvider;
import org.geoserver.platform.resource.LockProvider;
import org.geoserver.platform.resource.NullLockProvider;

public class LockProviderInitializer
implements GeoServerInitializer {
    ConfigurationListenerAdapter listener = new ConfigurationListenerAdapter(){

        @Override
        public void handleGlobalChange(GeoServerInfo global, List<String> propertyNames, List<Object> oldValues, List<Object> newValues) {
            boolean reload = false;
            String lockProviderName = null;
            if (propertyNames.contains("lockProviderName")) {
                lockProviderName = (String)newValues.get(propertyNames.indexOf("lockProviderName"));
                reload = true;
            }
            if (reload) {
                try {
                    LockProviderInitializer.setLockProvider(lockProviderName);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    };

    @Override
    public void initialize(GeoServer geoServer) throws Exception {
        String lockProviderName = geoServer.getGlobal().getLockProviderName();
        LockProviderInitializer.setLockProvider(lockProviderName);
        geoServer.addListener(this.listener);
    }

    public static void setLockProvider(String lockProviderName) {
        NullLockProvider delegate;
        if (lockProviderName == null) {
            delegate = new NullLockProvider();
        } else {
            Object provider = GeoServerExtensions.bean((String)lockProviderName);
            if (provider == null) {
                throw new IllegalStateException("Could not find " + lockProviderName + " lock provider in spring application context");
            }
            if (!(provider instanceof LockProvider)) {
                throw new IllegalStateException("Found " + lockProviderName + "(" + provider.getClass().getName() + ") in application context, but it was not a LockProvider");
            }
            delegate = (LockProvider)provider;
        }
        GlobalLockProvider lockProvider = (GlobalLockProvider)GeoServerExtensions.bean((String)"lockProvider");
        if (lockProvider.getDelegate() != delegate) {
            lockProvider.setDelegate((LockProvider)delegate);
        }
    }
}

