/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.impl;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.MapInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.LayerGroupInfoImpl;
import org.geoserver.catalog.impl.LayerGroupStyle;
import org.geoserver.catalog.impl.LayerInfoImpl;
import org.geoserver.catalog.impl.ModificationProxy;
import org.geoserver.catalog.impl.ResolvingProxy;
import org.geoserver.catalog.impl.ResourceInfoImpl;
import org.geoserver.catalog.impl.StoreInfoImpl;
import org.geoserver.catalog.impl.StyleInfoImpl;
import org.geotools.util.logging.Logging;

public class ResolvingProxyResolver {
    private static final Logger LOGGER = Logging.getLogger(ResolvingProxyResolver.class);

    private ResolvingProxyResolver() {
    }

    private static <T> T unwrap(T obj) {
        return ModificationProxy.unwrap(obj);
    }

    public static void resolve(CatalogInfo info, Catalog catalog) {
        if (info instanceof WorkspaceInfo) {
            ResolvingProxyResolver.resolve((WorkspaceInfo)info, catalog);
        } else if (info instanceof NamespaceInfo) {
            ResolvingProxyResolver.resolve((NamespaceInfo)info, catalog);
        } else if (info instanceof StoreInfo) {
            ResolvingProxyResolver.resolve((StoreInfo)info, catalog);
        } else if (info instanceof ResourceInfo) {
            ResolvingProxyResolver.resolve((ResourceInfo)info, catalog);
        } else if (info instanceof LayerInfo) {
            ResolvingProxyResolver.resolve((LayerInfo)info, catalog);
        } else if (info instanceof LayerGroupInfo) {
            ResolvingProxyResolver.resolve((LayerGroupInfo)info, catalog);
        } else if (info instanceof StyleInfo) {
            ResolvingProxyResolver.resolve((StyleInfo)info, catalog);
        } else if (info instanceof MapInfo) {
            ResolvingProxyResolver.resolve((MapInfo)info, catalog);
        } else {
            LOGGER.warning("Unknown CatalogInfo: " + info);
        }
    }

    private static void resolve(LayerInfo layer, Catalog catalog) {
        StyleInfo style;
        ResourceInfo resource = ResolvingProxy.resolve(catalog, layer.getResource());
        if (resource != null) {
            resource = ResolvingProxyResolver.unwrap(resource);
            layer.setResource(resource);
        }
        if ((style = ResolvingProxy.resolve(catalog, layer.getDefaultStyle())) != null) {
            style = ResolvingProxyResolver.unwrap(style);
            layer.setDefaultStyle(style);
        }
        LinkedHashSet<StyleInfo> styles = new LinkedHashSet<StyleInfo>();
        for (StyleInfo s : layer.getStyles()) {
            s = ResolvingProxy.resolve(catalog, s);
            s = ResolvingProxyResolver.unwrap(s);
            styles.add(s);
        }
        ((LayerInfoImpl)layer).setStyles(styles);
    }

    private static void resolve(LayerGroupInfo layerGroup, Catalog catalog) {
        LayerGroupInfoImpl lg = (LayerGroupInfoImpl)layerGroup;
        WorkspaceInfo ws = lg.getWorkspace();
        if (ws != null) {
            WorkspaceInfo resolved = ResolvingProxy.resolve(catalog, ws);
            if (resolved != null) {
                resolved = ResolvingProxyResolver.unwrap(resolved);
                lg.setWorkspace(resolved);
            } else {
                LOGGER.log(Level.INFO, "Failed to resolve workspace for layer group \"" + lg.getName() + "\". This means the workspace has not yet been added to the catalog, keep the proxy around");
            }
        }
        lg.setRootLayer(ResolvingProxy.resolve(catalog, lg.getRootLayer()));
        lg.setRootLayerStyle(ResolvingProxy.resolve(catalog, lg.getRootLayerStyle()));
        ResolvingProxyResolver.resolveLayerGroupLayers(lg.getLayers(), catalog);
        ResolvingProxyResolver.resolveLayerGroupStyles(lg.getLayers(), lg.getStyles(), catalog);
        for (LayerGroupStyle groupStyle : lg.getLayerGroupStyles()) {
            ResolvingProxyResolver.resolveLayerGroupLayers(groupStyle.getLayers(), catalog);
            ResolvingProxyResolver.resolveLayerGroupStyles(groupStyle.getLayers(), groupStyle.getStyles(), catalog);
        }
    }

    private static void resolveLayerGroupStyles(List<PublishedInfo> assignedLayers, List<StyleInfo> styles, Catalog catalog) {
        for (int i = 0; i < styles.size(); ++i) {
            String ref;
            StyleInfo s = styles.get(i);
            if (s == null) continue;
            PublishedInfo assignedLayer = assignedLayers.get(i);
            StyleInfo resolved = null;
            if (assignedLayer instanceof LayerGroupInfo && (ref = ResolvingProxy.getRef(s)) != null) {
                StyleInfoImpl styleInfo = new StyleInfoImpl(catalog);
                styleInfo.setName(ref);
                resolved = styleInfo;
            }
            if (resolved == null) {
                resolved = ResolvingProxyResolver.unwrap(ResolvingProxy.resolve(catalog, s));
            }
            styles.set(i, resolved);
        }
    }

    private static void resolveLayerGroupLayers(List<PublishedInfo> layers, Catalog catalog) {
        for (int i = 0; i < layers.size(); ++i) {
            PublishedInfo resolved;
            PublishedInfo l = layers.get(i);
            if (l == null) continue;
            if (l instanceof LayerGroupInfo) {
                resolved = ResolvingProxyResolver.unwrap(ResolvingProxy.resolve(catalog, (LayerGroupInfo)l));
                if (resolved == null) {
                    resolved = l;
                }
            } else if (l instanceof LayerInfo) {
                resolved = ResolvingProxyResolver.unwrap(ResolvingProxy.resolve(catalog, (LayerInfo)l));
                if (resolved == null) {
                    resolved = l;
                }
            } else {
                resolved = ResolvingProxyResolver.unwrap(ResolvingProxy.resolve(catalog, l));
            }
            layers.set(i, resolved);
        }
    }

    private static void resolve(StyleInfo style, Catalog catalog) {
        StyleInfoImpl s = (StyleInfoImpl)style;
        s.setCatalog(catalog);
        WorkspaceInfo ws = s.getWorkspace();
        if (ws != null) {
            WorkspaceInfo resolved = ResolvingProxy.resolve(catalog, ws);
            if (resolved != null) {
                resolved = ResolvingProxyResolver.unwrap(resolved);
                s.setWorkspace(resolved);
            } else {
                LOGGER.log(Level.INFO, "Failed to resolve workspace for style \"" + style.getName() + "\". This means the workspace has not yet been added to the catalog, keep the proxy around");
            }
        }
    }

    private static void resolve(MapInfo map, Catalog catalog) {
    }

    private static void resolve(WorkspaceInfo workspace, Catalog catalog) {
    }

    private static void resolve(NamespaceInfo namespace, Catalog catalog) {
    }

    private static void resolve(StoreInfo store, Catalog catalog) {
        StoreInfoImpl s = (StoreInfoImpl)store;
        s.setCatalog(catalog);
        WorkspaceInfo resolved = ResolvingProxy.resolve(catalog, s.getWorkspace());
        if (resolved != null) {
            resolved = ResolvingProxyResolver.unwrap(resolved);
            s.setWorkspace(resolved);
        } else {
            LOGGER.log(Level.INFO, "Failed to resolve workspace for store \"" + store.getName() + "\". This means the workspace has not yet been added to the catalog, keep the proxy around");
        }
    }

    private static void resolve(ResourceInfo resource, Catalog catalog) {
        NamespaceInfo namespace;
        ResourceInfoImpl r = (ResourceInfoImpl)resource;
        r.setCatalog(catalog);
        StoreInfo store = ResolvingProxy.resolve(catalog, r.rawStore());
        if (store != null) {
            store = ResolvingProxyResolver.unwrap(store);
            r.setStore(store);
        }
        if ((namespace = ResolvingProxy.resolve(catalog, r.getNamespace())) != null) {
            namespace = ResolvingProxyResolver.unwrap(namespace);
            r.setNamespace(namespace);
        }
    }
}

