/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.TransformerException;
import org.geoserver.catalog.StyleHandler;
import org.geoserver.catalog.StyleType;
import org.geoserver.ows.util.RequestUtils;
import org.geoserver.util.IOUtils;
import org.geotools.api.style.ResourceLocator;
import org.geotools.api.style.Style;
import org.geotools.api.style.StyledLayerDescriptor;
import org.geotools.brewer.styling.builder.StyledLayerDescriptorBuilder;
import org.geotools.sld.v1_1.SLD;
import org.geotools.sld.v1_1.SLDConfiguration;
import org.geotools.styling.DefaultResourceLocator;
import org.geotools.util.URLs;
import org.geotools.util.Version;
import org.geotools.util.logging.Logging;
import org.geotools.xml.styling.SLDParser;
import org.geotools.xml.styling.SLDTransformer;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.Encoder;
import org.geotools.xsd.Parser;
import org.picocontainer.MutablePicoContainer;
import org.vfny.geoserver.util.SLDValidator;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class SLDHandler
extends StyleHandler {
    static Logger LOGGER = Logging.getLogger(SLDHandler.class);
    static int XML_LOOKAHEAD = 8500;
    public static final String FORMAT = "sld";
    public static final Version VERSION_10 = new Version("1.0.0");
    public static final Version VERSION_11 = new Version("1.1.0");
    public static final String MIMETYPE_10 = "application/vnd.ogc.sld+xml";
    public static final String MIMETYPE_11 = "application/vnd.ogc.se+xml";
    static final Map<StyleType, String> TEMPLATES = new HashMap<StyleType, String>();

    public SLDHandler() {
        super("SLD", FORMAT);
    }

    @Override
    public List<Version> getVersions() {
        return Arrays.asList(VERSION_10, VERSION_11);
    }

    @Override
    public String getCodeMirrorEditMode() {
        return "text/sld10";
    }

    @Override
    public boolean supportsEncoding(Version version) {
        return version == null || VERSION_10.equals((Object)version);
    }

    @Override
    public String getStyle(StyleType type, Color color, String colorName, String layerName) {
        String template = TEMPLATES.get((Object)type);
        String colorCode = Integer.toHexString(color.getRGB());
        colorCode = colorCode.substring(2, colorCode.length());
        return template.replace("${colorName}", colorName).replace("${colorCode}", "#" + colorCode).replace("${layerName}", layerName);
    }

    @Override
    public String mimeType(Version version) {
        if (version != null && version.equals((Object)VERSION_11)) {
            return MIMETYPE_11;
        }
        return MIMETYPE_10;
    }

    @Override
    public Version versionForMimeType(String mimeType) {
        if (mimeType.equals(MIMETYPE_11)) {
            return VERSION_11;
        }
        return VERSION_10;
    }

    @Override
    public StyledLayerDescriptor parse(Object input, Version version, ResourceLocator resourceLocator, EntityResolver entityResolver) throws IOException {
        if (version == null) {
            Object[] versionAndReader = this.getVersionAndReader(input, true);
            version = (Version)versionAndReader[0];
            input = versionAndReader[1];
        }
        if (VERSION_11.compareTo(version) == 0) {
            return this.parse11(input, resourceLocator, entityResolver);
        }
        return this.parse10(input, resourceLocator, entityResolver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StyledLayerDescriptor parse10(Object input, ResourceLocator resourceLocator, EntityResolver entityResolver) throws IOException {
        StyledLayerDescriptor styledLayerDescriptor;
        Reader reader = null;
        try {
            Style[] style;
            SLDParser p;
            StyledLayerDescriptor sld;
            if (!(input instanceof File)) {
                reader = this.toReader(input);
                input = reader;
            }
            if ((sld = (p = this.createSld10Parser(input, resourceLocator, entityResolver)).parseSLD()).getStyledLayers().length == 0 && (style = p.readDOM()).length > 0) {
                StyledLayerDescriptorBuilder sldBuilder = new StyledLayerDescriptorBuilder().reset(sld);
                sldBuilder.namedLayer().style().reset(style[0]);
                sld = sldBuilder.build();
            }
            styledLayerDescriptor = sld;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(reader);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)reader);
        return styledLayerDescriptor;
    }

    StyledLayerDescriptor parse11(Object input, ResourceLocator resourceLocator, EntityResolver entityResolver) throws IOException {
        StyledLayerDescriptor styledLayerDescriptor;
        block8: {
            Parser parser = this.createSld11Parser(input, resourceLocator, entityResolver);
            Reader reader = this.toReader(input);
            try {
                parser.setEntityResolver(entityResolver);
                styledLayerDescriptor = (StyledLayerDescriptor)parser.parse(reader);
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
            reader.close();
        }
        return styledLayerDescriptor;
    }

    SLDParser createSld10Parser(Object input, ResourceLocator resourceLocator, EntityResolver entityResolver) throws IOException {
        SLDParser parser = input instanceof File ? new SLDParser(styleFactory, (File)input) : new SLDParser(styleFactory, this.toReader(input));
        if (resourceLocator != null) {
            parser.setOnLineResourceLocator(resourceLocator);
        }
        if (entityResolver != null) {
            parser.setEntityResolver(entityResolver);
        }
        return parser;
    }

    Parser createSld11Parser(Object input, ResourceLocator resourceLocator, EntityResolver entityResolver) {
        ResourceLocator locator;
        if (resourceLocator == null && input instanceof File) {
            URL surl = URLs.fileToUrl((File)((File)input));
            DefaultResourceLocator defResourceLocator = new DefaultResourceLocator();
            defResourceLocator.setSourceUrl(surl);
            resourceLocator = defResourceLocator;
        }
        SLDConfiguration sld = (locator = resourceLocator) != null ? new SLDConfiguration(){

            protected void configureContext(MutablePicoContainer container) {
                container.registerComponentInstance(ResourceLocator.class, (Object)locator);
            }
        } : new SLDConfiguration();
        Parser parser = new Parser((Configuration)sld);
        if (entityResolver != null) {
            parser.setEntityResolver(entityResolver);
        }
        return parser;
    }

    @Override
    public void encode(StyledLayerDescriptor sld, Version version, boolean pretty, OutputStream output) throws IOException {
        if (version != null && VERSION_11.compareTo(version) == 0) {
            this.encode11(sld, pretty, output);
        } else {
            this.encode10(sld, pretty, output);
        }
    }

    void encode10(StyledLayerDescriptor sld, boolean pretty, OutputStream output) throws IOException {
        SLDTransformer tx = new SLDTransformer();
        if (pretty) {
            tx.setIndentation(2);
        }
        try {
            tx.transform((Object)sld, output);
        }
        catch (TransformerException e) {
            throw (IOException)new IOException("Error writing style").initCause(e);
        }
    }

    void encode11(StyledLayerDescriptor sld, boolean pretty, OutputStream output) throws IOException {
        Encoder e = new Encoder((Configuration)new SLDConfiguration());
        e.setIndenting(pretty);
        e.encode((Object)sld, SLD.StyledLayerDescriptor, output);
    }

    @Override
    public List<Exception> validate(Object input, Version version, EntityResolver entityResolver) throws IOException {
        if (version == null) {
            Object[] versionAndReader = this.getVersionAndReader(input, true);
            version = (Version)versionAndReader[0];
            input = versionAndReader[1];
        }
        if (version != null && VERSION_11.compareTo(version) == 0) {
            return this.validate11(input, entityResolver);
        }
        return this.validate10(input, entityResolver);
    }

    List<Exception> validate10(Object input, EntityResolver entityResolver) throws IOException {
        try (Reader reader = this.toReader(input);){
            SLDValidator validator = new SLDValidator();
            validator.setEntityResolver(entityResolver);
            ArrayList<Exception> arrayList = new ArrayList<Exception>(validator.validateSLD(new InputSource(reader)));
            return arrayList;
        }
    }

    List<Exception> validate11(Object input, EntityResolver entityResolver) throws IOException {
        List list2;
        block8: {
            Parser p = this.createSld11Parser(input, null, entityResolver);
            Reader reader = this.toReader(input);
            try {
                p.validate(reader);
                list2 = p.getValidationErrors();
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
            reader.close();
        }
        return list2;
    }

    @Override
    public Version version(Object input) throws IOException {
        Object[] versionAndReader = this.getVersionAndReader(input, false);
        return (Version)versionAndReader[0];
    }

    Object[] getVersionAndReader(Object input, boolean needReader) throws IOException {
        Object[] result;
        XMLStreamReader parser;
        BufferedReader reader = null;
        reader = input instanceof InputStream ? RequestUtils.getBufferedXMLReader((InputStream)((InputStream)input), (int)XML_LOOKAHEAD) : RequestUtils.getBufferedXMLReader((Reader)this.toReader(input), (int)XML_LOOKAHEAD);
        String version = null;
        try {
            XMLInputFactory factory = XMLInputFactory.newFactory();
            factory.setProperty("javax.xml.stream.supportDTD", false);
            factory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
            parser = factory.createXMLStreamReader(reader);
        }
        catch (XMLStreamException e) {
            throw new IOException("Error creating xml parser", e);
        }
        try {
            while (parser.hasNext() && 1 != parser.next()) {
            }
            for (int i = 0; i < parser.getAttributeCount(); ++i) {
                if (!"version".equals(parser.getAttributeLocalName(i))) continue;
                version = parser.getAttributeValue(i);
            }
        }
        catch (XMLStreamException e) {
            throw new IOException("Error parsing content", e);
        }
        finally {
            try {
                parser.close();
            }
            catch (XMLStreamException e) {
                LOGGER.log(Level.WARNING, "Non fatal error closing XML Stream Parser", e);
            }
        }
        reader.reset();
        if (version == null) {
            LOGGER.warning("Could not determine SLD version from content. Assuming 1.0.0");
            version = "1.0.0";
        }
        if (needReader) {
            result = new Object[]{new Version(version), reader};
        } else {
            reader.close();
            result = new Object[]{new Version(version)};
        }
        return result;
    }

    @Override
    public String insertImageCode(String imageFileName, String styleContent) {
        boolean version11 = false;
        if (styleContent != null) {
            try {
                version11 = VERSION_11.compareTo(this.version(styleContent)) == 0;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return new StringBuffer("<ExternalGraphic ").append(version11 ? "xmlns=\"http://www.opengis.net/se\" " : "xmlns=\"http://www.opengis.net/sld\" ").append("xmlns:xlink=\"http://www.w3.org/1999/xlink\">\\n").append("<OnlineResource xlink:type=\"simple\" xlink:href=\"").append(imageFileName).append("\" />\\n").append("<Format>").append(IMAGE_TYPES.getContentType(imageFileName)).append("</Format>\\n").append("</ExternalGraphic>\\n").toString();
    }

    @Override
    public URL getSpecification(Version version) throws MalformedURLException {
        if (version != null && VERSION_11.compareTo(version) == 0) {
            return new URL("http://portal.opengeospatial.org/files/?artifact_id=22364");
        }
        return new URL("http://portal.opengeospatial.org/files/?artifact_id=1188");
    }

    static {
        try {
            TEMPLATES.put(StyleType.POINT, org.apache.commons.io.IOUtils.toString((InputStream)SLDHandler.class.getResourceAsStream("template_point.sld"), (Charset)StandardCharsets.UTF_8));
            TEMPLATES.put(StyleType.POLYGON, org.apache.commons.io.IOUtils.toString((InputStream)SLDHandler.class.getResourceAsStream("template_polygon.sld"), (Charset)StandardCharsets.UTF_8));
            TEMPLATES.put(StyleType.LINE, org.apache.commons.io.IOUtils.toString((InputStream)SLDHandler.class.getResourceAsStream("template_line.sld"), (Charset)StandardCharsets.UTF_8));
            TEMPLATES.put(StyleType.RASTER, org.apache.commons.io.IOUtils.toString((InputStream)SLDHandler.class.getResourceAsStream("template_raster.sld"), (Charset)StandardCharsets.UTF_8));
            TEMPLATES.put(StyleType.GENERIC, org.apache.commons.io.IOUtils.toString((InputStream)SLDHandler.class.getResourceAsStream("template_generic.sld"), (Charset)StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new RuntimeException("Error loading up the style templates", e);
        }
    }
}

