/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver;

import java.awt.RenderingHints;
import java.io.Serializable;
import java.util.HashMap;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ProjectionPolicy;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.ResourcePool;
import org.geoserver.data.test.MockData;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.referencing.CRS;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKTReader;
import org.vfny.geoserver.global.GeoServerFeatureLocking;

public class ProjectionPolicyTest
extends GeoServerSystemTestSupport {
    static WKTReader WKT = new WKTReader();

    @Override
    protected void setUpTestData(SystemTestData testData) throws Exception {
        HashMap<SystemTestData.LayerProperty, Object> props = new HashMap<SystemTestData.LayerProperty, Object>();
        props.put(SystemTestData.LayerProperty.PROJECTION_POLICY, ProjectionPolicy.FORCE_DECLARED);
        props.put(SystemTestData.LayerProperty.SRS, 4269);
        testData.setUpVectorLayer(SystemTestData.BASIC_POLYGONS, props);
        props.put(SystemTestData.LayerProperty.PROJECTION_POLICY, ProjectionPolicy.REPROJECT_TO_DECLARED);
        props.put(SystemTestData.LayerProperty.SRS, 4326);
        testData.setUpVectorLayer(MockData.POLYGONS, props);
        props.put(SystemTestData.LayerProperty.PROJECTION_POLICY, ProjectionPolicy.NONE);
        props.put(SystemTestData.LayerProperty.SRS, 3004);
        testData.setUpVectorLayer(MockData.LINES, props);
        props.put(SystemTestData.LayerProperty.PROJECTION_POLICY, ProjectionPolicy.REPROJECT_TO_DECLARED);
        props.put(SystemTestData.LayerProperty.SRS, 4326);
        props.put(SystemTestData.LayerProperty.NAME, "MyPoints");
        testData.setUpVectorLayer(MockData.POINTS, props);
        testData.setUpDefaultRasterLayers();
        testData.setUpWcs10RasterLayers();
        testData.setUpSecurity();
    }

    @Test
    public void testForce() throws Exception {
        FeatureTypeInfo fti = this.getCatalog().getFeatureTypeByName(MockData.BASIC_POLYGONS.getLocalPart());
        Assert.assertEquals((Object)"EPSG:4269", (Object)fti.getSRS());
        Assert.assertEquals((Object)ProjectionPolicy.FORCE_DECLARED, (Object)fti.getProjectionPolicy());
        SimpleFeatureCollection fc = (SimpleFeatureCollection)fti.getFeatureSource(null, null).getFeatures();
        Assert.assertEquals((Object)CRS.decode((String)"EPSG:4269"), (Object)((SimpleFeatureType)fc.getSchema()).getCoordinateReferenceSystem());
        SimpleFeature f = (SimpleFeature)DataUtilities.first((FeatureCollection)fc);
        Assert.assertEquals((Object)CRS.decode((String)"EPSG:4269"), (Object)f.getType().getCoordinateReferenceSystem());
    }

    @Test
    public void testReproject() throws Exception {
        FeatureTypeInfo fti = this.getCatalog().getFeatureTypeByName(MockData.POLYGONS.getLocalPart());
        Assert.assertEquals((Object)"EPSG:4326", (Object)fti.getSRS());
        Assert.assertEquals((Object)ProjectionPolicy.REPROJECT_TO_DECLARED, (Object)fti.getProjectionPolicy());
        SimpleFeatureCollection fc = (SimpleFeatureCollection)fti.getFeatureSource(null, null).getFeatures();
        Assert.assertEquals((Object)CRS.decode((String)"EPSG:4326"), (Object)((SimpleFeatureType)fc.getSchema()).getCoordinateReferenceSystem());
        SimpleFeature f = (SimpleFeature)DataUtilities.first((FeatureCollection)fc);
        Geometry g = (Geometry)f.getDefaultGeometryProperty().getValue();
        Assert.assertFalse((boolean)g.equalsExact(WKT.read("POLYGON((500225 500025,500225 500075,500275 500050,500275 500025,500225 500025))")));
        Assert.assertEquals((Object)CRS.decode((String)"EPSG:4326"), (Object)f.getType().getCoordinateReferenceSystem());
    }

    @Test
    public void testLeaveNative() throws Exception {
        FeatureTypeInfo fti = this.getCatalog().getFeatureTypeByName(MockData.LINES.getLocalPart());
        Assert.assertEquals((Object)"EPSG:3004", (Object)fti.getSRS());
        Assert.assertEquals((Object)ProjectionPolicy.NONE, (Object)fti.getProjectionPolicy());
        SimpleFeatureCollection fc = (SimpleFeatureCollection)fti.getFeatureSource(null, null).getFeatures();
        Assert.assertEquals((Object)CRS.decode((String)"EPSG:32615"), (Object)((SimpleFeatureType)fc.getSchema()).getCoordinateReferenceSystem());
        SimpleFeature f = (SimpleFeature)DataUtilities.first((FeatureCollection)fc);
        Geometry g = (Geometry)f.getDefaultGeometryProperty().getValue();
        Assert.assertTrue((boolean)g.equalsExact(WKT.read("LINESTRING(500125 500025,500175 500075)")));
        Assert.assertEquals((Object)CRS.decode((String)"EPSG:32615"), (Object)f.getType().getCoordinateReferenceSystem());
    }

    @Test
    public void testWithRename() throws Exception {
        FeatureTypeInfo fti = this.getCatalog().getFeatureTypeByName("MyPoints");
        Assert.assertEquals((Object)"EPSG:4326", (Object)fti.getSRS());
        Assert.assertEquals((Object)ProjectionPolicy.REPROJECT_TO_DECLARED, (Object)fti.getProjectionPolicy());
        SimpleFeatureCollection fc = (SimpleFeatureCollection)fti.getFeatureSource(null, null).getFeatures();
        Assert.assertEquals((Object)CRS.decode((String)"EPSG:4326"), (Object)((SimpleFeatureType)fc.getSchema()).getCoordinateReferenceSystem());
        SimpleFeature f = (SimpleFeature)DataUtilities.first((FeatureCollection)fc);
        Geometry g = (Geometry)f.getDefaultGeometryProperty().getValue();
        Assert.assertFalse((boolean)g.equalsExact(WKT.read("POINT(500050 500050)")));
        Assert.assertEquals((Object)CRS.decode((String)"EPSG:4326"), (Object)f.getType().getCoordinateReferenceSystem());
    }

    @Test
    public void testForceCoverage() throws Exception {
        Catalog catalog = this.getCatalog();
        CoverageInfo ci = catalog.getCoverageByName("usa");
        ci.setProjectionPolicy(ProjectionPolicy.FORCE_DECLARED);
        ci.setSRS("EPSG:3857");
        catalog.save((ResourceInfo)ci);
        ci = catalog.getCoverageByName("usa");
        Assert.assertEquals((Object)ProjectionPolicy.FORCE_DECLARED, (Object)ci.getProjectionPolicy());
        Assert.assertEquals((Object)"EPSG:3857", (Object)ci.getSRS());
        GridCoverage2DReader r = (GridCoverage2DReader)ci.getGridCoverageReader(null, GeoTools.getDefaultHints());
        Assert.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)CRS.decode((String)"EPSG:3857"), (Object)r.getCoordinateReferenceSystem()));
        r = (GridCoverage2DReader)ci.getGridCoverageReader(null, null);
        Assert.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)CRS.decode((String)"EPSG:3857"), (Object)r.getCoordinateReferenceSystem()));
        CoverageStoreInfo store = catalog.getCoverageStoreByName("usa");
        ResourcePool rpool = catalog.getResourcePool();
        r = (GridCoverage2DReader)rpool.getGridCoverageReader(store, GeoTools.getDefaultHints());
        Assert.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)CRS.decode((String)"EPSG:4326"), (Object)r.getCoordinateReferenceSystem()));
    }

    @Test
    public void testOtherSRS() throws Exception {
        CoordinateReferenceSystem requestCRS = CRS.decode((String)"EPSG:4326");
        Catalog catalog = this.getCatalog();
        ResourcePool rpool = catalog.getResourcePool();
        FeatureTypeInfo ft = catalog.getFeatureTypeByName("Lines");
        String otherSRS = "EPSG:4326,EPSG:3857";
        ft.getMetadata().put("OTHER_SRS", (Serializable)((Object)otherSRS));
        ft.setProjectionPolicy(ProjectionPolicy.FORCE_DECLARED);
        Hints hints = new Hints((RenderingHints.Key)ResourcePool.MAP_CRS, (Object)requestCRS);
        GeoServerFeatureLocking gsFL = (GeoServerFeatureLocking)rpool.getFeatureSource(ft, hints);
        Assert.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)requestCRS, (Object)gsFL.getSchema().getGeometryDescriptor().getCoordinateReferenceSystem()));
    }
}

