/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.io.IOUtils;
import org.geoserver.ows.util.KvpUtils;
import org.geoserver.test.http.AbstractHttpClient;
import org.geotools.http.HTTPResponse;

public class MockHttpClient
extends AbstractHttpClient {
    Map<Request, HTTPResponse> expectedRequests = new LinkedHashMap<Request, HTTPResponse>();

    public void expectGet(URL url, HTTPResponse response) {
        this.expectedRequests.put(new Request(url), response);
    }

    public void expectPost(URL url, String postContent, String postContentType, HTTPResponse response) {
        this.expectPOST(url, postContent.getBytes(), postContentType, response);
    }

    public void expectPOST(URL url, byte[] postContent, String postContentType, HTTPResponse response) {
        this.expectedRequests.put(new Request(url, postContent, postContentType), response);
    }

    public HTTPResponse post(URL url, InputStream postContent, String postContentType) throws IOException {
        return this.getResponse(new Request(url, this.toByteArray(postContent), postContentType));
    }

    private byte[] toByteArray(InputStream is) throws IOException {
        try (InputStream inputStream = is;){
            byte[] byArray = IOUtils.toByteArray((InputStream)is);
            return byArray;
        }
    }

    private HTTPResponse getResponse(Request request) {
        HTTPResponse response = this.expectedRequests.get(request);
        if (response == null) {
            StringBuilder sb = new StringBuilder("Unexpected request \n" + request + "\nNo response is bound to it. Bound urls are: ");
            for (Request r : this.expectedRequests.keySet()) {
                sb.append("\n").append(r);
            }
            throw new IllegalArgumentException(sb.toString());
        }
        return response;
    }

    public HTTPResponse get(URL url) throws IOException {
        return this.getResponse(new Request(url));
    }

    @Override
    public Map<String, String> getExtraParams() {
        return null;
    }

    @Override
    public void setExtraParams(Map<String, String> extraParams) {
    }

    private static class Request {
        String path;
        Map<String, Object> kvp;
        String contentType;
        boolean isGetRequest;
        byte[] postContent;

        public Request(URL url) {
            this.path = url.getProtocol() + "://" + url.getHost() + url.getPath();
            Map parsedQueryString = KvpUtils.parseQueryString((String)url.toExternalForm());
            this.kvp = new TreeMap<String, Object>();
            for (Map.Entry entry : parsedQueryString.entrySet()) {
                this.kvp.put(((String)entry.getKey()).toUpperCase(), entry.getValue());
            }
            this.isGetRequest = true;
        }

        public Request(URL url, byte[] postContent, String postContentType) {
            this(url);
            this.isGetRequest = false;
            this.postContent = postContent;
            this.contentType = postContentType;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.contentType == null ? 0 : this.contentType.hashCode());
            result = 31 * result + (this.isGetRequest ? 1231 : 1237);
            result = 31 * result + (this.kvp == null ? 0 : this.kvp.hashCode());
            result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
            result = 31 * result + Arrays.hashCode(this.postContent);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)obj;
            if (this.contentType == null ? other.contentType != null : !this.contentType.equals(other.contentType)) {
                return false;
            }
            if (this.isGetRequest != other.isGetRequest) {
                return false;
            }
            if (this.kvp == null ? other.kvp != null : !this.kvp.equals(other.kvp)) {
                return false;
            }
            if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
                return false;
            }
            return Arrays.equals(this.postContent, other.postContent);
        }

        public String toString() {
            if (this.isGetRequest) {
                return "GET " + this.path + ", " + this.kvp;
            }
            return "POST " + this.path + ", " + this.kvp + ", content type " + this.contentType + ", content " + Arrays.toString(this.postContent);
        }
    }
}

