/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.test;

import java.awt.RenderingHints;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.DefaultConfiguration;
import org.geoserver.data.test.TestData;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.Service;
import org.geoserver.test.RunTestSetup;
import org.geoserver.test.TestSetup;
import org.geoserver.test.TestSetupFrequency;
import org.geotools.api.feature.type.Name;
import org.geotools.feature.NameImpl;
import org.geotools.util.Version;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ComparisonFailure;
import org.junit.Rule;
import org.junit.rules.TestRule;

public abstract class GeoServerBaseTestSupport<T extends TestData> {
    protected static final Logger LOGGER = Logging.getLogger((String)"org.geoserver.test");
    protected static TestData testData;
    protected static GeoServerBaseTestSupport test;
    protected static TestSetupFrequency testSetupFrequency;
    @Rule
    public TestRule runSetup = (base, description) -> {
        if (description.getAnnotation(RunTestSetup.class) != null) {
            try {
                GeoServerBaseTestSupport.doTearDownClass();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return base;
    };

    public static boolean isQuietTests() {
        String quietTests = System.getProperty("quietTests");
        return quietTests != null && !"false".equalsIgnoreCase(quietTests);
    }

    @BeforeClass
    public static final void setUpLogging() throws Exception {
        if (GeoServerBaseTestSupport.isQuietTests()) {
            Logging.getLogger((String)"org.geoserver").setLevel(Level.SEVERE);
            Logging.getLogger((String)"org.vfny.geoserver").setLevel(Level.SEVERE);
            Logging.getLogger((String)"org.geotools").setLevel(Level.SEVERE);
        }
    }

    @BeforeClass
    public static final void setUpReferencing() throws Exception {
        if (System.getProperty("org.geotools.referencing.forceXY") == null || !"http".equals(Hints.getSystemDefault((RenderingHints.Key)Hints.FORCE_AXIS_ORDER_HONORING))) {
            System.setProperty("org.geotools.referencing.forceXY", "true");
            Hints.putSystemDefault((RenderingHints.Key)Hints.FORCE_AXIS_ORDER_HONORING, (Object)"http");
        }
    }

    @Before
    public final void doSetup() throws Exception {
        if (testData == null) {
            test = this;
            testData = this.createTestData();
            Logger imageLogger = Logger.getLogger("org.geotools.image");
            Level previousLevel = imageLogger.getLevel();
            try {
                imageLogger.setLevel(Level.WARNING);
                testData.setUp();
            }
            finally {
                imageLogger.setLevel(previousLevel);
            }
            this.setUp(testData);
        }
    }

    protected T getTestData() {
        return (T)testData;
    }

    protected abstract T createTestData() throws Exception;

    protected void setUp(T testData) throws Exception {
    }

    @After
    public final void doTearDown() throws Exception {
        if (testSetupFrequency == null) {
            testSetupFrequency = this.lookupTestSetupPolicy();
        }
        if (testSetupFrequency != TestSetupFrequency.ONCE) {
            GeoServerBaseTestSupport.doTearDownClass();
        }
    }

    protected TestSetupFrequency lookupTestSetupPolicy() {
        for (Class<?> clazz = this.getClass(); clazz != null && !Object.class.equals(clazz); clazz = clazz.getSuperclass()) {
            TestSetup testSetup = clazz.getAnnotation(TestSetup.class);
            if (testSetup == null) continue;
            return testSetup.run();
        }
        return TestSetupFrequency.REPEAT;
    }

    @AfterClass
    public static final void doTearDownClass() throws Exception {
        if (testData != null) {
            try {
                try {
                    test.tearDown(testData);
                }
                catch (Throwable t) {
                    LOGGER.log(Logging.FATAL, "Failure to tear down test support: " + t, t);
                    throw t;
                }
                LogManager.shutdown();
                LoggerContext loggerContext = (LoggerContext)LogManager.getContext((boolean)false);
                loggerContext.reconfigure((Configuration)new DefaultConfiguration());
                try {
                    testData.tearDown();
                }
                catch (Throwable t) {
                    LOGGER.log(Logging.FATAL, "Failure to remove contents of the temporary data directory: " + t, t);
                    throw t;
                }
            }
            finally {
                testData = null;
                test = null;
            }
        }
    }

    @AfterClass
    public static void clearTestSetupFrequency() {
        testSetupFrequency = null;
    }

    protected void tearDown(T testData) throws Exception {
    }

    protected String toString(QName qName) {
        if (qName.getPrefix() != null) {
            return qName.getPrefix() + ":" + qName.getLocalPart();
        }
        return qName.getLocalPart();
    }

    protected Name toName(QName qName) {
        return qName.getNamespaceURI() != null ? new NameImpl(qName.getNamespaceURI(), qName.getLocalPart()) : new NameImpl(qName.getLocalPart());
    }

    protected static boolean equalsIgnoringNewlineStyle(String s1, String s2) {
        if (s1 == null) {
            return s2 == null;
        }
        if (s2 == null) {
            return false;
        }
        return GeoServerBaseTestSupport.normalizeLineEnds(s1).equals(GeoServerBaseTestSupport.normalizeLineEnds(s2));
    }

    private static String normalizeLineEnds(String s) {
        return s.replace("\r\n", "\n").replace('\r', '\n');
    }

    protected void assertEqualsIgnoreNewLineStyle(String expected, String actual) {
        if (!GeoServerBaseTestSupport.equalsIgnoringNewlineStyle(expected, actual)) {
            throw new ComparisonFailure("", expected, actual);
        }
    }

    protected Service getService(String id, Version version) {
        List services = GeoServerExtensions.extensions(Service.class).stream().filter(s -> id.equals(s.getId()) && version.equals((Object)s.getVersion())).collect(Collectors.toList());
        if (services.isEmpty()) {
            return null;
        }
        if (services.size() > 1) {
            throw new RuntimeException("Found more than one service with the required id and version: " + services);
        }
        return (Service)services.get(0);
    }

    static {
        testSetupFrequency = null;
    }
}

