/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.template;

import java.io.File;
import java.io.IOException;
import org.easymock.EasyMock;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.platform.resource.Files;
import org.geoserver.template.GeoServerTemplateLoader;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class GeoServerTemplateLoader2Test {
    static File root;
    private File fooFile;

    @BeforeClass
    public static void createTmpDir() throws Exception {
        root = File.createTempFile("template", "tmp", new File("target"));
        root.delete();
        root.mkdir();
    }

    @Before
    public void createTestFile() throws IOException {
        this.fooFile = new File("./target/foo");
        this.fooFile.delete();
        this.fooFile.createNewFile();
    }

    GeoServerDataDirectory createDataDirectoryMock() {
        GeoServerDataDirectory dd = (GeoServerDataDirectory)EasyMock.createNiceMock(GeoServerDataDirectory.class);
        EasyMock.expect((Object)dd.root()).andReturn((Object)root).anyTimes();
        return dd;
    }

    @Test
    public void testRelativeToFeatureType() throws IOException {
        GeoServerDataDirectory dd = this.createDataDirectoryMock();
        EasyMock.replay((Object[])new Object[]{dd});
        GeoServerTemplateLoader tl = new GeoServerTemplateLoader(this.getClass(), dd);
        Object source = tl.findTemplateSource("dummy.ftl");
        Assert.assertNull((Object)source);
        EasyMock.reset((Object[])new Object[]{dd});
        FeatureTypeInfo ft = (FeatureTypeInfo)EasyMock.createMock(FeatureTypeInfo.class);
        EasyMock.expect((Object)dd.get((ResourceInfo)ft, new String[]{"dummy.ftl"})).andReturn((Object)Files.asResource((File)this.fooFile)).once();
        EasyMock.replay((Object[])new Object[]{ft, dd});
        tl.setFeatureType(ft);
        source = tl.findTemplateSource("dummy.ftl");
        Assert.assertNotNull((Object)source);
        EasyMock.verify((Object[])new Object[]{ft, dd});
    }

    @Test
    public void testRelativeToStore() throws IOException {
        GeoServerDataDirectory dd = this.createDataDirectoryMock();
        EasyMock.replay((Object[])new Object[]{dd});
        GeoServerTemplateLoader tl = new GeoServerTemplateLoader(this.getClass(), dd);
        Object source = tl.findTemplateSource("dummy.ftl");
        Assert.assertNull((Object)source);
        EasyMock.reset((Object[])new Object[]{dd});
        DataStoreInfo s = (DataStoreInfo)EasyMock.createNiceMock(DataStoreInfo.class);
        FeatureTypeInfo ft = (FeatureTypeInfo)EasyMock.createNiceMock(FeatureTypeInfo.class);
        EasyMock.expect((Object)ft.getStore()).andReturn((Object)s).anyTimes();
        tl.setFeatureType(ft);
        EasyMock.replay((Object[])new Object[]{ft, s, dd});
        Assert.assertNull((Object)tl.findTemplateSource("dummy.ftl"));
        EasyMock.reset((Object[])new Object[]{dd});
        EasyMock.expect((Object)dd.get((StoreInfo)s, new String[]{"dummy.ftl"})).andReturn((Object)Files.asResource((File)this.fooFile)).once();
        EasyMock.replay((Object[])new Object[]{dd});
        Assert.assertNotNull((Object)tl.findTemplateSource("dummy.ftl"));
        EasyMock.verify((Object[])new Object[]{dd});
    }

    @Test
    public void testRelativeToWorkspace() throws IOException {
        GeoServerDataDirectory dd = this.createDataDirectoryMock();
        DataStoreInfo s = (DataStoreInfo)EasyMock.createNiceMock(DataStoreInfo.class);
        FeatureTypeInfo ft = (FeatureTypeInfo)EasyMock.createNiceMock(FeatureTypeInfo.class);
        WorkspaceInfo ws = (WorkspaceInfo)EasyMock.createNiceMock(WorkspaceInfo.class);
        EasyMock.expect((Object)ft.getStore()).andReturn((Object)s).anyTimes();
        EasyMock.expect((Object)s.getWorkspace()).andReturn((Object)ws).anyTimes();
        EasyMock.replay((Object[])new Object[]{ft, s, ws, dd});
        GeoServerTemplateLoader tl = new GeoServerTemplateLoader(this.getClass(), dd);
        tl.setFeatureType(ft);
        Object source = tl.findTemplateSource("dummy.ftl");
        Assert.assertNull((Object)source);
        EasyMock.reset((Object[])new Object[]{dd});
        EasyMock.expect((Object)dd.get(ws, new String[]{"dummy.ftl"})).andReturn((Object)Files.asResource((File)this.fooFile)).once();
        EasyMock.replay((Object[])new Object[]{dd});
        Assert.assertNotNull((Object)tl.findTemplateSource("dummy.ftl"));
        EasyMock.verify((Object[])new Object[]{dd});
    }

    @Test
    public void testGlobal() throws IOException {
        GeoServerDataDirectory dd = this.createDataDirectoryMock();
        DataStoreInfo s = (DataStoreInfo)EasyMock.createNiceMock(DataStoreInfo.class);
        FeatureTypeInfo ft = (FeatureTypeInfo)EasyMock.createNiceMock(FeatureTypeInfo.class);
        WorkspaceInfo ws = (WorkspaceInfo)EasyMock.createNiceMock(WorkspaceInfo.class);
        EasyMock.expect((Object)ft.getStore()).andReturn((Object)s).anyTimes();
        EasyMock.expect((Object)s.getWorkspace()).andReturn((Object)ws).anyTimes();
        EasyMock.replay((Object[])new Object[]{ft, s, ws, dd});
        GeoServerTemplateLoader tl = new GeoServerTemplateLoader(this.getClass(), dd);
        tl.setResource((ResourceInfo)ft);
        Assert.assertNull((Object)tl.findTemplateSource("dummy.ftl"));
        EasyMock.reset((Object[])new Object[]{dd});
        EasyMock.expect((Object)dd.getWorkspaces(new String[]{"dummy.ftl"})).andReturn((Object)Files.asResource((File)this.fooFile)).once();
        EasyMock.replay((Object[])new Object[]{dd});
        Assert.assertNotNull((Object)tl.findTemplateSource("dummy.ftl"));
        EasyMock.verify((Object[])new Object[]{dd});
    }
}

