/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.template;

import freemarker.ext.beans.BeansWrapper;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import org.geoserver.template.FeatureWrapper;
import org.geoserver.template.TemplateUtils;
import org.geotools.api.feature.Attribute;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.FeatureFactory;
import org.geotools.api.feature.Property;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.AttributeType;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.Name;
import org.geotools.data.DataUtilities;
import org.geotools.data.complex.feature.type.ComplexFeatureTypeFactoryImpl;
import org.geotools.feature.AttributeBuilder;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.ComplexFeatureBuilder;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.LenientFeatureFactoryImpl;
import org.geotools.feature.NameImpl;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;

public class FeatureWrapperTest {
    DefaultFeatureCollection features;
    Configuration cfg;

    @Before
    public void setUp() throws Exception {
        GeometryFactory gf = new GeometryFactory();
        SimpleFeatureType featureType = DataUtilities.createType((String)"testType", (String)"string:String,int:Integer,double:Double,geom:Point");
        this.features = new DefaultFeatureCollection(){};
        this.features.add(SimpleFeatureBuilder.build((SimpleFeatureType)featureType, (Object[])new Object[]{"one", 1, 1.1, gf.createPoint(new Coordinate(1.0, 1.0))}, (String)"fid.1"));
        this.features.add(SimpleFeatureBuilder.build((SimpleFeatureType)featureType, (Object[])new Object[]{"two", 2, 2.2, gf.createPoint(new Coordinate(2.0, 2.0))}, (String)"fid.2"));
        this.features.add(SimpleFeatureBuilder.build((SimpleFeatureType)featureType, (Object[])new Object[]{"three", 3, 3.3, gf.createPoint(new Coordinate(3.0, 3.0))}, (String)"fid.3"));
        this.cfg = TemplateUtils.getSafeConfiguration((BeansWrapper)this.createWrapper(), null, null);
        this.cfg.setClassForTemplateLoading(this.getClass(), "");
    }

    public FeatureWrapper createWrapper() {
        return new FeatureWrapper();
    }

    @Test
    public void testFeatureCollection() throws Exception {
        Template template = this.cfg.getTemplate("FeatureCollection.ftl");
        StringWriter out = new StringWriter();
        template.process((Object)this.features, (Writer)out);
        Assert.assertEquals((Object)"fid.1\nfid.2\nfid.3\n", (Object)out.toString().replaceAll("\r\n", "\n").replaceAll("\r", "\n"));
    }

    @Test
    public void testFeatureSimple() throws Exception {
        Template template = this.cfg.getTemplate("FeatureSimple.ftl");
        StringWriter out = new StringWriter();
        template.process(this.features.iterator().next(), (Writer)out);
        Assert.assertEquals((Object)"one\n1\n1.1\nPOINT (1 1)", (Object)out.toString().replace(',', '.').replaceAll("\r\n", "\n").replaceAll("\r", "\n"));
    }

    @Test
    public void testFeatureDynamic() throws Exception {
        Template template = this.cfg.getTemplate("FeatureDynamic.ftl");
        StringWriter out = new StringWriter();
        template.process(this.features.iterator().next(), (Writer)out);
        Assert.assertEquals((Object)"string=one\nint=1\ndouble=1.1\ngeom=POINT (1 1)\n", (Object)out.toString().replace(',', '.').replaceAll("\r\n", "\n").replaceAll("\r", "\n"));
    }

    @Test
    public void testFeatureSequence() throws Exception {
        Template template = this.cfg.getTemplate("FeatureSequence.ftl");
        StringWriter out = new StringWriter();
        template.process((Object)this.features, (Writer)out);
        Assert.assertEquals((Object)"three\none\n3", (Object)out.toString().replaceAll("\r\n", "\n").replaceAll("\r", "\n"));
    }

    @Test
    public void v() throws IOException, TemplateException {
        Feature f = this.buildComplexFeature();
        Template template = this.cfg.getTemplate("ComplexFeatureMaxOccurs.ftl");
        StringWriter out = new StringWriter();
        template.process((Object)f, (Writer)out);
        Assert.assertEquals((Object)"\nName: string_value\nValue: string1\nName: string_value\nValue: string2\n", (Object)out.toString().replace(',', '.').replaceAll("\r\n", "\n").replaceAll("\r", "\n"));
    }

    private Feature buildComplexFeature() {
        AttributeTypeBuilder typeBuilder = new AttributeTypeBuilder();
        String nsURI = "http://namespace/test";
        typeBuilder.binding(String.class).name("string_value").namespaceURI(nsURI).maxOccurs(2).minOccurs(1);
        AttributeType attrType = typeBuilder.buildType();
        AttributeDescriptor attrDescriptor = typeBuilder.buildDescriptor(attrType.getName(), attrType);
        AttributeBuilder builder = new AttributeBuilder((FeatureFactory)new LenientFeatureFactoryImpl());
        builder.setDescriptor(attrDescriptor);
        ComplexFeatureTypeFactoryImpl ftBuilder = new ComplexFeatureTypeFactoryImpl();
        FeatureType complexType = ftBuilder.createFeatureType((Name)new NameImpl(nsURI, "ComplexUnboundedType"), Arrays.asList(attrDescriptor), null, false, null, null, null);
        ComplexFeatureBuilder complexFeatureBuilder = new ComplexFeatureBuilder(complexType);
        Attribute attribute1 = builder.buildSimple(null, (Object)"string1");
        Attribute attribute2 = builder.buildSimple(null, (Object)"string2");
        complexFeatureBuilder.append(attrDescriptor.getName(), (Property)attribute1);
        complexFeatureBuilder.append(attrDescriptor.getName(), (Property)attribute2);
        return complexFeatureBuilder.buildFeature("test.1");
    }
}

