/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.impl;

import org.geoserver.catalog.Catalog;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.security.ResourceAccessManager;
import org.geoserver.security.ResourceAccessManagerWrapper;
import org.geoserver.security.SecureCatalogImpl;
import org.geoserver.security.impl.DataAccessRuleDAO;
import org.geoserver.security.impl.DefaultResourceAccessManager;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;

public class ResourceAccessManagerLookupTest
extends GeoServerSystemTestSupport {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLookupOfDefaultAccessManagerSubclass() throws Exception {
        String name = "customManager";
        try {
            Catalog catalog = (Catalog)GeoServerExtensions.bean((String)"rawCatalog");
            DataAccessRuleDAO dao = (DataAccessRuleDAO)GeoServerExtensions.bean((String)"accessRulesDao");
            TestLookupAccessManager testMan = new TestLookupAccessManager(dao, catalog);
            this.registerManagerBean((ResourceAccessManager)testMan, name);
            SecureCatalogImpl secureCatalog = new SecureCatalogImpl(catalog);
            ResourceAccessManager accessManager = secureCatalog.getResourceAccessManager();
            while (accessManager instanceof ResourceAccessManagerWrapper) {
                accessManager = ((ResourceAccessManagerWrapper)accessManager).unwrap();
            }
            Assert.assertTrue((boolean)(accessManager instanceof TestLookupAccessManager));
        }
        finally {
            this.destroyManagerBean(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDuplicateDefaultAccessManagerLookup() throws Exception {
        String name = "defaultAccessManager2";
        try {
            Catalog catalog = (Catalog)GeoServerExtensions.bean((String)"rawCatalog");
            DataAccessRuleDAO dao = (DataAccessRuleDAO)GeoServerExtensions.bean((String)"accessRulesDao");
            DefaultResourceAccessManager testMan = new DefaultResourceAccessManager(dao, catalog);
            this.registerManagerBean((ResourceAccessManager)testMan, name);
            SecureCatalogImpl secureCatalog = new SecureCatalogImpl(catalog);
            ResourceAccessManager accessManager = secureCatalog.getResourceAccessManager();
            while (accessManager instanceof ResourceAccessManagerWrapper) {
                accessManager = ((ResourceAccessManagerWrapper)accessManager).unwrap();
            }
            Assert.assertTrue((boolean)(accessManager instanceof DefaultResourceAccessManager));
        }
        finally {
            this.destroyManagerBean(name);
        }
    }

    private void registerManagerBean(ResourceAccessManager manager, String name) {
        ConfigurableListableBeanFactory factory = applicationContext.getBeanFactory();
        factory.registerSingleton(name, (Object)manager);
    }

    private void destroyManagerBean(String name) {
        DefaultListableBeanFactory factory = (DefaultListableBeanFactory)applicationContext.getBeanFactory();
        factory.destroySingleton(name);
    }

    static class TestLookupAccessManager
    extends DefaultResourceAccessManager {
        public TestLookupAccessManager(DataAccessRuleDAO dao, Catalog rawCatalog) {
            super(dao, rawCatalog);
        }
    }
}

