/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.TreeMap;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.GeoServerUserGroupStore;
import org.geoserver.security.KeyStoreProvider;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.config.SecurityUserGroupServiceConfig;
import org.geoserver.security.config.impl.MemoryUserGroupServiceConfigImpl;
import org.geoserver.security.impl.AbstractUserGroupService;
import org.geoserver.security.impl.GeoServerUser;
import org.geoserver.security.impl.GeoServerUserGroup;
import org.geoserver.security.impl.MemoryGeoserverUser;
import org.geoserver.security.impl.MemoryGeoserverUserGroup;
import org.geoserver.security.impl.MemoryUserGroupStore;
import org.geoserver.security.password.GeoServerPasswordEncoder;
import org.geoserver.security.password.PasswordEncodingType;

public class MemoryUserGroupService
extends AbstractUserGroupService {
    byte[] byteArray;
    protected String toBeEncrypted;

    public String getToBeEncrypted() {
        return this.toBeEncrypted;
    }

    public boolean canCreateStore() {
        return true;
    }

    public GeoServerUserGroupStore createStore() throws IOException {
        MemoryUserGroupStore store = new MemoryUserGroupStore();
        store.initializeFromService((GeoServerUserGroupService)this);
        return store;
    }

    protected void deserialize() throws IOException {
        this.clearMaps();
        if (this.byteArray == null) {
            return;
        }
        ByteArrayInputStream in = new ByteArrayInputStream(this.byteArray);
        ObjectInputStream oin = new ObjectInputStream(in);
        try {
            this.helper.userMap = (TreeMap)oin.readObject();
            this.helper.groupMap = (TreeMap)oin.readObject();
            this.helper.user_groupMap = (TreeMap)oin.readObject();
            this.helper.group_userMap = (TreeMap)oin.readObject();
            this.helper.propertyMap = (TreeMap)oin.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
    }

    public GeoServerUser createUserObject(String username, String password, boolean isEnabled) throws IOException {
        MemoryGeoserverUser user = new MemoryGeoserverUser(username, (GeoServerUserGroupService)this);
        user.setEnabled(isEnabled);
        user.setPassword(password);
        return user;
    }

    public GeoServerUserGroup createGroupObject(String groupname, boolean isEnabled) throws IOException {
        MemoryGeoserverUserGroup group = new MemoryGeoserverUserGroup(groupname);
        group.setEnabled(isEnabled);
        return group;
    }

    public void initializeFromConfig(SecurityNamedServiceConfig config) throws IOException {
        String alias;
        KeyStoreProvider prov;
        this.name = config.getName();
        SecurityUserGroupServiceConfig ugConfig = (SecurityUserGroupServiceConfig)config;
        this.passwordEncoderName = ugConfig.getPasswordEncoderName();
        GeoServerPasswordEncoder enc = this.getSecurityManager().loadPasswordEncoder(this.passwordEncoderName);
        if (enc.getEncodingType() == PasswordEncodingType.ENCRYPT && !(prov = this.getSecurityManager().getKeyStoreProvider()).containsAlias(alias = prov.aliasForGroupService(this.name))) {
            prov.setUserGroupKey(this.name, this.getSecurityManager().getRandomPassworddProvider().getRandomPasswordWithDefaultLength());
            prov.storeKeyStore();
        }
        enc.initializeFor((GeoServerUserGroupService)this);
        this.passwordValidatorName = ugConfig.getPasswordPolicyName();
        this.toBeEncrypted = ((MemoryUserGroupServiceConfigImpl)config).getToBeEncrypted();
    }
}

