/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.impl;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.security.GeoServerRoleService;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.GeoServerSecurityProvider;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.config.impl.MemoryRoleServiceConfigImpl;
import org.geoserver.security.config.impl.MemoryUserGroupServiceConfigImpl;
import org.geoserver.security.impl.MemoryRoleService;
import org.geoserver.security.impl.MemorySecurityConfigValidator;
import org.geoserver.security.impl.MemoryUserGroupService;
import org.geoserver.security.validation.SecurityConfigValidator;

public class MemorySecurityProvider
extends GeoServerSecurityProvider {
    public void configure(XStreamPersister xp) {
        super.configure(xp);
        xp.getXStream().alias("memorygroupservice", MemoryUserGroupServiceConfigImpl.class);
        xp.getXStream().alias("memoryroleservice", MemoryRoleServiceConfigImpl.class);
    }

    public Map<Class<?>, Set<String>> getFieldsForEncryption() {
        HashMap map = new HashMap();
        HashSet<String> fields = new HashSet<String>();
        fields.add("toBeEncrypted");
        map.put(MemoryRoleServiceConfigImpl.class, fields);
        map.put(MemoryUserGroupServiceConfigImpl.class, fields);
        return map;
    }

    public Class<? extends GeoServerUserGroupService> getUserGroupServiceClass() {
        return MemoryUserGroupService.class;
    }

    public GeoServerUserGroupService createUserGroupService(SecurityNamedServiceConfig config) throws IOException {
        return new MemoryUserGroupService();
    }

    public Class<? extends GeoServerRoleService> getRoleServiceClass() {
        return MemoryRoleService.class;
    }

    public GeoServerRoleService createRoleService(SecurityNamedServiceConfig config) throws IOException {
        return new MemoryRoleService();
    }

    public SecurityConfigValidator createConfigurationValidator(GeoServerSecurityManager securityManager) {
        return new MemorySecurityConfigValidator(securityManager);
    }
}

