/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.TreeMap;
import org.geoserver.security.GeoServerRoleService;
import org.geoserver.security.GeoServerRoleStore;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.config.impl.MemoryRoleServiceConfigImpl;
import org.geoserver.security.impl.AbstractRoleService;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.impl.MemoryGeoserverRole;
import org.geoserver.security.impl.MemoryRoleStore;

public class MemoryRoleService
extends AbstractRoleService {
    byte[] byteArray;
    protected String toBeEncrypted;

    public String getToBeEncrypted() {
        return this.toBeEncrypted;
    }

    public boolean canCreateStore() {
        return true;
    }

    public GeoServerRoleStore createStore() throws IOException {
        MemoryRoleStore store = new MemoryRoleStore();
        store.initializeFromService((GeoServerRoleService)this);
        return store;
    }

    protected void deserialize() throws IOException {
        this.clearMaps();
        if (this.byteArray == null) {
            return;
        }
        ByteArrayInputStream in = new ByteArrayInputStream(this.byteArray);
        ObjectInputStream oin = new ObjectInputStream(in);
        try {
            this.helper.roleMap = (TreeMap)oin.readObject();
            this.helper.role_parentMap = (HashMap)oin.readObject();
            this.helper.user_roleMap = (TreeMap)oin.readObject();
            this.helper.group_roleMap = (TreeMap)oin.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
    }

    public GeoServerRole createRoleObject(String role) throws IOException {
        return new MemoryGeoserverRole(role);
    }

    public void initializeFromConfig(SecurityNamedServiceConfig config) throws IOException {
        super.initializeFromConfig(config);
        this.toBeEncrypted = ((MemoryRoleServiceConfigImpl)config).getToBeEncrypted();
    }
}

