/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.filter;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.config.PreAuthenticatedUserNameFilterConfig;
import org.geoserver.security.config.RoleSource;
import org.geoserver.security.config.SecurityInterceptorFilterConfig;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.filter.GeoServerAuthenticationFilter;
import org.geoserver.security.filter.GeoServerRequestHeaderAuthenticationFilter;
import org.geoserver.security.filter.GeoServerSecurityFilter;
import org.geoserver.security.filter.GeoServerSecurityInterceptorFilter;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockFilterChain;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.SecurityMetadataSource;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextImpl;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;

public class GeoServerRequestHeaderAuthenticationFilterTest {
    @Test
    public void testAuthenticationViaPreAuthChanging() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain filterChain = new MockFilterChain();
        SecurityContextImpl sc = new SecurityContextImpl();
        sc.setAuthentication((Authentication)new PreAuthenticatedAuthenticationToken((Object)"testadmin", null));
        SecurityContextHolder.setContext((SecurityContext)sc);
        GeoServerRequestHeaderAuthenticationFilter toTest = new GeoServerRequestHeaderAuthenticationFilter();
        toTest.setPrincipalHeaderAttribute("sec-username");
        request.addHeader("sec-username", (Object)"testuser");
        toTest.setSecurityManager(new GeoServerSecurityManager(new GeoServerDataDirectory(new File("/tmp"))));
        toTest.setRoleSource((RoleSource)PreAuthenticatedUserNameFilterConfig.PreAuthenticatedUserNameRoleSource.Header);
        SecurityInterceptorFilterConfig filterCfg = new SecurityInterceptorFilterConfig();
        filterCfg.setName("custom");
        filterCfg.setClassName(AuthCapturingFilter.class.getName());
        filterCfg.setSecurityMetadataSource("geoserverMetadataSource");
        toTest.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)filterChain);
        Assert.assertEquals((Object)"testuser", (Object)SecurityContextHolder.getContext().getAuthentication().getPrincipal().toString());
    }

    @Test
    public void testAuthenticationWithNullAttributes() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain filterChain = new MockFilterChain();
        GeoServerSecurityInterceptorFilter toTest2 = new GeoServerSecurityInterceptorFilter();
        toTest2.setSecurityManager(new GeoServerSecurityManager(new GeoServerDataDirectory(new File("/tmp"))));
        toTest2.setSecurityManager(new GeoServerSecurityManager(new GeoServerDataDirectory(new File("/tmp"))));
        SecurityInterceptorFilterConfig filterCfg = new SecurityInterceptorFilterConfig();
        filterCfg.setName("custom");
        filterCfg.setClassName(AuthCapturingFilter.class.getName());
        filterCfg.setSecurityMetadataSource("geoserverMetadataSource");
        SecurityMetadataSource metadataSource = new SecurityMetadataSource(){

            public Collection<ConfigAttribute> getAttributes(Object object) throws IllegalArgumentException {
                return null;
            }

            public Collection<ConfigAttribute> getAllConfigAttributes() {
                return null;
            }

            public boolean supports(Class<?> clazz) {
                return false;
            }
        };
        toTest2.initializeFromConfig((SecurityNamedServiceConfig)filterCfg, metadataSource);
        try {
            toTest2.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)filterChain);
            Assert.fail((String)"Expected AccessDeniedException because the attributes are empty");
        }
        catch (AccessDeniedException e) {
            Assert.assertEquals((Object)"Access Denied", (Object)e.getMessage());
        }
    }

    @Test
    public void testAuthenticationViaPreAuthNoHeader() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain filterChain = new MockFilterChain();
        SecurityContextImpl sc = new SecurityContextImpl();
        sc.setAuthentication((Authentication)new PreAuthenticatedAuthenticationToken((Object)"testadmin", null));
        SecurityContextHolder.setContext((SecurityContext)sc);
        GeoServerRequestHeaderAuthenticationFilter toTest = new GeoServerRequestHeaderAuthenticationFilter();
        toTest.setPrincipalHeaderAttribute("sec-username");
        toTest.setSecurityManager(new GeoServerSecurityManager(new GeoServerDataDirectory(new File("/tmp"))));
        toTest.setRoleSource((RoleSource)PreAuthenticatedUserNameFilterConfig.PreAuthenticatedUserNameRoleSource.Header);
        toTest.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)filterChain);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
    }

    static class AuthCapturingFilter
    extends GeoServerSecurityFilter
    implements GeoServerAuthenticationFilter {
        AuthCapturingFilter() {
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            Authentication auth = SecurityContextHolder.getContext().getAuthentication();
            request.setAttribute("auth", (Object)auth);
            chain.doFilter(request, response);
        }

        public boolean applicableForHtml() {
            return true;
        }

        public boolean applicableForServices() {
            return true;
        }
    }
}

