/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.decorators;

import java.io.IOException;
import java.net.URL;
import org.geoserver.catalog.TestHttpClientProvider;
import org.geoserver.catalog.TestHttpClientRule;
import org.geoserver.catalog.impl.WMTSStoreInfoImpl;
import org.geoserver.security.AccessLimits;
import org.geoserver.security.CatalogMode;
import org.geoserver.security.WrapperPolicy;
import org.geoserver.security.decorators.SecuredWMTSLayer;
import org.geoserver.security.decorators.SecuredWebMapTileServer;
import org.geoserver.test.http.MockHttpClient;
import org.geoserver.test.http.MockHttpResponse;
import org.geotools.http.HTTPClient;
import org.geotools.ows.ServiceException;
import org.geotools.ows.wms.Layer;
import org.geotools.ows.wmts.WebMapTileServer;
import org.geotools.ows.wmts.map.WMTSCoverageReader;
import org.geotools.ows.wmts.model.WMTSLayer;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class SecuredWMTSLayerTest {
    @Rule
    public TestHttpClientRule clientMocker = new TestHttpClientRule();
    protected final WrapperPolicy policy = WrapperPolicy.readOnlyHide((AccessLimits)new AccessLimits(CatalogMode.HIDE));
    protected static final String LAYER_TITLE = "Snow Water Equivalent (AMSR2, GCOM-W1)";

    @Test
    public void testCanSecure() {
        WMTSLayer layer = new WMTSLayer(LAYER_TITLE);
        layer = new SecuredWMTSLayer(layer, this.policy);
        Assert.assertNotNull((Object)layer);
        Assert.assertEquals((Object)LAYER_TITLE, (Object)layer.getTitle());
    }

    @Test
    public void testCoverageReader() throws IOException, ServiceException {
        String capabilitiesURL = this.clientMocker.getServer() + "/geoserver/gwc?REQUEST=GetCapabilities&VERSION=1.0.0&SERVICE=WMTS";
        URL serverURL = new URL(capabilitiesURL);
        MockHttpClient mockClient = new MockHttpClient();
        mockClient.expectGet(serverURL, new MockHttpResponse(WMTSStoreInfoImpl.class.getResource("nasa.getcapa.xml"), "text/xml", new String[0]));
        TestHttpClientProvider.bind((HTTPClient)mockClient, (URL)serverURL);
        HTTPClient client = TestHttpClientProvider.get((String)capabilitiesURL);
        SecuredWebMapTileServer wmts = new SecuredWebMapTileServer(new WebMapTileServer(serverURL, client));
        SecuredWMTSLayer layer = new SecuredWMTSLayer((WMTSLayer)wmts.getCapabilities().getLayerList().iterator().next(), this.policy);
        new WMTSCoverageReader((WebMapTileServer)wmts, (Layer)layer);
    }
}

