/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.csp;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.config.SettingsInfo;
import org.geoserver.config.impl.SettingsInfoImpl;
import org.geoserver.config.util.XStreamPersisterFactory;
import org.geoserver.filters.SecurityHeadersFilter;
import org.geoserver.ows.ProxifyingURLMangler;
import org.geoserver.ows.URLMangler;
import org.geoserver.platform.GeoServerExtensionsHelper;
import org.geoserver.security.csp.CSPConfiguration;
import org.geoserver.security.csp.CSPHeaderDAO;
import org.geoserver.security.csp.CSPPolicy;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;
import org.springframework.mock.web.MockFilterChain;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

public class ContentSecurityPolicyTest {
    @ClassRule
    public static TemporaryFolder folder = new TemporaryFolder();
    private static XStreamPersisterFactory xpf = null;
    private static GeoServerDataDirectory dd = null;
    private static CSPHeaderDAO dao = null;
    private static SettingsInfo settings = null;

    @BeforeClass
    public static void initDAO() throws IOException {
        dd = new GeoServerDataDirectory(folder.getRoot());
        xpf = new XStreamPersisterFactory();
        GeoServer geoServer = (GeoServer)Mockito.mock(GeoServer.class);
        settings = new SettingsInfoImpl();
        settings.setUseHeadersProxyURL(Boolean.valueOf(false));
        Mockito.when((Object)geoServer.getSettings()).thenReturn((Object)settings);
        dao = new CSPHeaderDAO(geoServer, dd, xpf);
        GeoServerExtensionsHelper.singleton("cspHeaderDAO", dao, new Class[0]);
        GeoServerExtensionsHelper.singleton("proxyfier", new ProxifyingURLMangler(geoServer), URLMangler.class);
    }

    @AfterClass
    public static void clearExtensions() {
        GeoServerExtensionsHelper.clear();
    }

    @Before
    public void resetDAO() throws Exception {
        dao.reset();
        CSPConfiguration config = dao.getConfig();
        config.setReportOnly(false);
        dao.setConfig(config);
        dao.reset();
    }

    @Before
    @After
    public void resetProperties() {
        System.clearProperty("geoserver.xframe.shouldSetPolicy");
        System.clearProperty("geoserver.xframe.policy");
        System.clearProperty("geoserver.csp.fallbackDirectives");
        System.clearProperty("geoserver.csp.remoteResources");
        System.clearProperty("geoserver.csp.frameAncestors");
        System.clearProperty("PROXY_BASE_URL");
        System.clearProperty("GEOSERVER_DISABLE_STATIC_WEB_FILES");
        System.clearProperty("GEOSERVER_STATIC_WEB_FILES_SCRIPT");
    }

    @Test
    public void testDisabledConfig() throws Exception {
        CSPConfiguration config = dao.getConfig();
        config.setEnabled(false);
        ContentSecurityPolicyTest.assertHeader(null, "GET", null, null, null);
    }

    @Test
    public void testDisabledPolicies() throws Exception {
        CSPConfiguration config = dao.getConfig();
        config.getPolicies().forEach(p -> p.setEnabled(false));
        ContentSecurityPolicyTest.assertHeader(null, "GET", null, null, null);
    }

    @Test
    public void testDisabledRules() throws Exception {
        CSPConfiguration config = dao.getConfig();
        config.getPolicies().forEach(p -> p.getRules().forEach(r -> r.setEnabled(false)));
        ContentSecurityPolicyTest.assertHeader(null, "GET", null, null, null);
    }

    @Test
    public void testDefaultFallback() throws Exception {
        Path file = dd.getSecurity(new String[]{"csp.xml"}).file().toPath();
        try {
            Files.write(file, new byte[0], new OpenOption[0]);
            ContentSecurityPolicyTest.assertHeader("base-uri 'none'; form-action 'none'; default-src 'none'; frame-ancestors 'none';", "GET", null, null, null);
        }
        finally {
            Files.delete(file);
        }
    }

    @Test
    public void testCustomFallback() throws Exception {
        String expected = "frame-ancestors 'none';";
        System.setProperty("geoserver.csp.fallbackDirectives", expected);
        Path file = dd.getSecurity(new String[]{"csp.xml"}).file().toPath();
        try {
            Files.write(file, new byte[0], new OpenOption[0]);
            ContentSecurityPolicyTest.assertHeader(expected, "GET", null, null, null);
        }
        finally {
            Files.delete(file);
        }
    }

    @Test
    public void testGET() throws Exception {
        String actual = "base-uri 'self'; form-action 'self'; default-src 'none'; child-src 'self'; connect-src 'self'; font-src 'self'; img-src 'self' data:; style-src 'self' 'unsafe-inline'; script-src 'self';, frame-ancestors 'self';";
        ContentSecurityPolicyTest.assertHeader(actual, "GET", null, null, null);
    }

    @Test
    public void testHEAD() throws Exception {
        String actual = "base-uri 'self'; form-action 'self'; default-src 'none'; child-src 'self'; connect-src 'self'; font-src 'self'; img-src 'self' data:; style-src 'self' 'unsafe-inline'; script-src 'self';, frame-ancestors 'self';";
        ContentSecurityPolicyTest.assertHeader(actual, "HEAD", null, null, null);
    }

    @Test
    public void testPOST() throws Exception {
        String actual = "base-uri 'self'; form-action 'self'; default-src 'none'; child-src 'self'; connect-src 'self'; font-src 'self'; img-src 'self' data:; style-src 'self' 'unsafe-inline'; script-src 'self';, frame-ancestors 'self';";
        ContentSecurityPolicyTest.assertHeader(actual, "POST", null, null, null);
    }

    @Test
    public void testPUT() throws Exception {
        String actual = "base-uri 'self'; form-action 'self'; default-src 'none'; child-src 'self'; connect-src 'self'; font-src 'self'; img-src 'self' data:; style-src 'self' 'unsafe-inline'; script-src 'self';, frame-ancestors 'self';";
        ContentSecurityPolicyTest.assertHeader(actual, "PUT", null, null, null);
    }

    @Test
    public void testDELETE() throws Exception {
        String actual = "base-uri 'self'; form-action 'self'; default-src 'none'; child-src 'self'; connect-src 'self'; font-src 'self'; img-src 'self' data:; style-src 'self' 'unsafe-inline'; script-src 'self';, frame-ancestors 'self';";
        ContentSecurityPolicyTest.assertHeader(actual, "DELETE", null, null, null);
    }

    @Test
    public void testInjectProxyBaseURLNotSet() throws Exception {
        String actual = "base-uri 'self'; form-action 'self'; default-src 'none'; child-src 'self'; connect-src 'self'; font-src 'self'; img-src 'self' data:; style-src 'self' 'unsafe-inline'; script-src 'self';, frame-ancestors 'self';";
        CSPConfiguration config = dao.getConfig();
        config.setInjectProxyBase(true);
        ContentSecurityPolicyTest.assertHeader(actual, "GET", null, null, null);
    }

    @Test
    public void testInjectProxyBaseURLWithoutPort() throws Exception {
        String actual = "base-uri 'self'; form-action 'self' http://foo; default-src 'none'; child-src 'self' http://foo; connect-src 'self' http://foo; font-src 'self' http://foo; img-src 'self' http://foo data:; style-src 'self' http://foo 'unsafe-inline'; script-src 'self' http://foo;, frame-ancestors 'self';";
        System.setProperty("PROXY_BASE_URL", "http://foo");
        CSPConfiguration config = dao.getConfig();
        config.setInjectProxyBase(true);
        ContentSecurityPolicyTest.assertHeader(actual, "GET", null, null, null);
    }

    @Test
    public void testInjectProxyBaseURLWithPort() throws Exception {
        String actual = "base-uri 'self'; form-action 'self' http://foo:8080; default-src 'none'; child-src 'self' http://foo:8080; connect-src 'self' http://foo:8080; font-src 'self' http://foo:8080; img-src 'self' http://foo:8080 data:; style-src 'self' http://foo:8080 'unsafe-inline'; script-src 'self' http://foo:8080;, frame-ancestors 'self';";
        System.setProperty("PROXY_BASE_URL", "http://foo:8080");
        CSPConfiguration config = dao.getConfig();
        config.setInjectProxyBase(true);
        ContentSecurityPolicyTest.assertHeader(actual, "GET", null, null, null);
    }

    @Test
    public void testInjectProxyBaseURLRequestToProxy() throws Exception {
        String actual = "base-uri 'self'; form-action 'self'; default-src 'none'; child-src 'self'; connect-src 'self'; font-src 'self'; img-src 'self' data:; style-src 'self' 'unsafe-inline'; script-src 'self';, frame-ancestors 'self';";
        System.setProperty("PROXY_BASE_URL", "http://localhost");
        CSPConfiguration config = dao.getConfig();
        config.setInjectProxyBase(true);
        ContentSecurityPolicyTest.assertHeader(actual, "GET", null, null, null);
    }

    @Test
    public void testInjectProxyBaseURLNothingToInject() throws Exception {
        CSPConfiguration config = dao.getConfig();
        config.setInjectProxyBase(true);
        ((CSPPolicy)config.getPolicies().get(0)).setEnabled(false);
        ContentSecurityPolicyTest.assertHeader("frame-ancestors 'self';", "HEAD", null, null, null);
    }

    @Test
    public void testStaticWebFileDisabled() throws Exception {
        System.setProperty("GEOSERVER_DISABLE_STATIC_WEB_FILES", "true");
        String actual = "base-uri 'self'; form-action 'self'; default-src 'none'; child-src 'self'; connect-src 'self'; font-src 'self'; img-src 'self' data:; style-src 'self' 'unsafe-inline'; script-src 'self';, frame-ancestors 'self';";
        ContentSecurityPolicyTest.assertHeader(actual, "GET", "/www/index.html", null, null);
    }

    @Test
    public void testStaticWebFileScriptSelf() throws Exception {
        System.setProperty("GEOSERVER_STATIC_WEB_FILES_SCRIPT", "SELF");
        String actual = "base-uri 'self'; form-action 'self'; default-src 'none'; child-src 'self'; connect-src 'self'; font-src 'self'; img-src 'self' data:; style-src 'self' 'unsafe-inline'; script-src 'self';, frame-ancestors 'self';";
        ContentSecurityPolicyTest.assertHeader(actual, "GET", "/www/index.html", null, null);
    }

    @Test
    public void testStaticWebFileNoRemoteResources() throws Exception {
        String actual = "base-uri 'self'; form-action 'self'; default-src 'none'; child-src 'self'; connect-src 'self'; font-src 'self'; img-src 'self' data:; style-src 'self' 'unsafe-inline'; script-src 'self' 'unsafe-inline' 'unsafe-eval';, frame-ancestors 'self';";
        ContentSecurityPolicyTest.assertHeader(actual, "GET", "/www/index.html", null, null);
    }

    @Test
    public void testStaticWebFileInvalidRemoteResources() throws Exception {
        System.setProperty("geoserver.csp.remoteResources", "~!@#$");
        String actual = "base-uri 'self'; form-action 'self'; default-src 'none'; child-src 'self'; connect-src 'self'; font-src 'self'; img-src 'self' data:; style-src 'self' 'unsafe-inline'; script-src 'self' 'unsafe-inline' 'unsafe-eval';, frame-ancestors 'self';";
        ContentSecurityPolicyTest.assertHeader(actual, "GET", "/www/index.html", null, null);
    }

    @Test
    public void testStaticWebFileRemoteResourcesProperty() throws Exception {
        System.setProperty("geoserver.csp.remoteResources", "http://foo");
        String actual = "base-uri 'self'; form-action 'self'; default-src 'none'; child-src 'self'; connect-src 'self'; font-src 'self' http://foo; img-src 'self' http://foo data:; style-src 'self' http://foo 'unsafe-inline'; script-src 'self' http://foo 'unsafe-inline' 'unsafe-eval';, frame-ancestors 'self';";
        ContentSecurityPolicyTest.assertHeader(actual, "GET", "/www/index.html", null, null);
    }

    @Test
    public void testStaticWebFileRemoteResourcesField() throws Exception {
        String actual = "base-uri 'self'; form-action 'self'; default-src 'none'; child-src 'self'; connect-src 'self'; font-src 'self' http://bar; img-src 'self' http://bar data:; style-src 'self' http://bar 'unsafe-inline'; script-src 'self' http://bar 'unsafe-inline' 'unsafe-eval';, frame-ancestors 'self';";
        CSPConfiguration config = dao.getConfig();
        config.setRemoteResources("http://bar");
        ContentSecurityPolicyTest.assertHeader(actual, "GET", "/www/index.html", null, null);
    }

    @Test
    public void testStaticWebFileRemoteResourcesPropertyAndField() throws Exception {
        System.setProperty("geoserver.csp.remoteResources", "http://foo");
        String actual = "base-uri 'self'; form-action 'self'; default-src 'none'; child-src 'self'; connect-src 'self'; font-src 'self' http://foo; img-src 'self' http://foo data:; style-src 'self' http://foo 'unsafe-inline'; script-src 'self' http://foo 'unsafe-inline' 'unsafe-eval';, frame-ancestors 'self';";
        CSPConfiguration config = dao.getConfig();
        config.setRemoteResources("http://bar");
        ContentSecurityPolicyTest.assertHeader(actual, "GET", "/www/index.html", null, null);
    }

    @Test
    public void testIndexPage() throws Exception {
        String actual = "base-uri 'self'; form-action 'self'; default-src 'none'; child-src 'self'; connect-src 'self'; font-src 'self'; img-src 'self' data:; style-src 'self' 'unsafe-inline'; script-src 'self' 'unsafe-inline';, frame-ancestors 'self';";
        ContentSecurityPolicyTest.assertHeader(actual, "GET", "/index.html", null, null);
    }

    @Test
    public void testFrameAncestorsSAMEORIGIN() throws Exception {
        System.setProperty("geoserver.xframe.policy", "SAMEORIGIN");
        CSPConfiguration config = dao.getConfig();
        ((CSPPolicy)config.getPolicies().get(0)).setEnabled(false);
        ContentSecurityPolicyTest.assertHeader("frame-ancestors 'self';", "GET", null, null, null);
    }

    @Test
    public void testFrameAncestorsDENY() throws Exception {
        System.setProperty("geoserver.xframe.policy", "DENY");
        CSPConfiguration config = dao.getConfig();
        ((CSPPolicy)config.getPolicies().get(0)).setEnabled(false);
        ContentSecurityPolicyTest.assertHeader("frame-ancestors 'none';", "GET", null, null, null);
    }

    @Test
    public void testFrameAncestorsALLOWFROM() throws Exception {
        System.setProperty("geoserver.xframe.policy", "ALLOW-FROM http://foo");
        CSPConfiguration config = dao.getConfig();
        ((CSPPolicy)config.getPolicies().get(0)).setEnabled(false);
        ContentSecurityPolicyTest.assertHeader(null, "GET", null, null, null);
    }

    @Test
    public void testFrameAncestorsXFrameDisabled() throws Exception {
        System.setProperty("geoserver.xframe.shouldSetPolicy", "false");
        CSPConfiguration config = dao.getConfig();
        ((CSPPolicy)config.getPolicies().get(0)).setEnabled(false);
        ContentSecurityPolicyTest.assertHeader(null, "GET", null, null, null);
    }

    @Test
    public void testFrameAncestorsProperty() throws Exception {
        System.setProperty("geoserver.csp.frameAncestors", "https:");
        CSPConfiguration config = dao.getConfig();
        ((CSPPolicy)config.getPolicies().get(0)).setEnabled(false);
        ContentSecurityPolicyTest.assertHeader("frame-ancestors https:;", "GET", null, null, null);
    }

    @Test
    public void testFrameAncestorsField() throws Exception {
        CSPConfiguration config = dao.getConfig();
        config.setFrameAncestors("http:");
        ((CSPPolicy)config.getPolicies().get(0)).setEnabled(false);
        ContentSecurityPolicyTest.assertHeader("frame-ancestors http:;", "GET", null, null, null);
    }

    @Test
    public void testFrameAncestorsPropertyAndField() throws Exception {
        System.setProperty("geoserver.csp.frameAncestors", "https:");
        CSPConfiguration config = dao.getConfig();
        config.setFrameAncestors("http:");
        ((CSPPolicy)config.getPolicies().get(0)).setEnabled(false);
        ContentSecurityPolicyTest.assertHeader("frame-ancestors https:;", "GET", null, null, null);
    }

    private static void assertHeader(String expected, String method, String pathInfo, String queryString, Map<String, ?> parameters) throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest(method, "");
        request.setPathInfo(pathInfo);
        request.setQueryString(queryString);
        request.setParameters(parameters != null ? parameters : Collections.emptyMap());
        request.setProtocol("http");
        request.addHeader("Host", (Object)"localhost");
        MockHttpServletResponse response = new MockHttpServletResponse();
        new SecurityHeadersFilter().doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)new MockFilterChain());
        String actual = response.getHeader("Content-Security-Policy");
        if (expected == null) {
            Assert.assertNull((Object)actual);
        } else {
            Assert.assertEquals((Object)expected, (Object)actual);
        }
    }
}

