/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.util.HashMap;
import java.util.Map;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.security.AbstractResourceAccessManager;
import org.geoserver.security.AccessLimits;
import org.geoserver.security.DataAccessLimits;
import org.geoserver.security.LayerGroupAccessLimits;
import org.geoserver.security.StyleAccessLimits;
import org.geoserver.security.WorkspaceAccessLimits;
import org.springframework.security.core.Authentication;

public class TestResourceAccessManager
extends AbstractResourceAccessManager {
    Map<String, Map<String, AccessLimits>> limits = new HashMap<String, Map<String, AccessLimits>>();
    WorkspaceAccessLimits defaultWorkspaceAccessLimits = null;

    public WorkspaceAccessLimits getDefaultWorkspaceAccessLimits() {
        return this.defaultWorkspaceAccessLimits;
    }

    public void setDefaultWorkspaceAccessLimits(WorkspaceAccessLimits defaultWorkspaceAccessLimits) {
        this.defaultWorkspaceAccessLimits = defaultWorkspaceAccessLimits;
    }

    public WorkspaceAccessLimits getAccessLimits(Authentication user, WorkspaceInfo workspace) {
        if (user == null) {
            return null;
        }
        String name = user.getName();
        WorkspaceAccessLimits wal = (WorkspaceAccessLimits)this.getUserMap(name).get(workspace.getId());
        if (wal != null) {
            return wal;
        }
        return this.defaultWorkspaceAccessLimits;
    }

    public DataAccessLimits getAccessLimits(Authentication user, LayerInfo layer) {
        if (user == null) {
            return null;
        }
        String name = user.getName();
        DataAccessLimits limits = (DataAccessLimits)this.getUserMap(name).get(layer.getId());
        if (limits == null) {
            limits = this.getAccessLimits(user, layer.getResource());
        }
        return limits;
    }

    public DataAccessLimits getAccessLimits(Authentication user, ResourceInfo resource) {
        if (user == null) {
            return null;
        }
        String name = user.getName();
        return (DataAccessLimits)this.getUserMap(name).get(resource.getId());
    }

    public StyleAccessLimits getAccessLimits(Authentication user, StyleInfo style) {
        if (user == null) {
            return null;
        }
        String name = user.getName();
        return (StyleAccessLimits)this.getUserMap(name).get(style.getId());
    }

    public LayerGroupAccessLimits getAccessLimits(Authentication user, LayerGroupInfo layerGroup) {
        if (user == null) {
            return null;
        }
        String name = user.getName();
        return (LayerGroupAccessLimits)this.getUserMap(name).get(layerGroup.getId());
    }

    public void putLimits(String userName, CatalogInfo securedItem, AccessLimits limits) {
        this.getUserMap(userName).put(securedItem.getId(), limits);
    }

    Map<String, AccessLimits> getUserMap(String userName) {
        Map<String, AccessLimits> userMap = this.limits.get(userName);
        if (userMap == null) {
            userMap = new HashMap<String, AccessLimits>();
            this.limits.put(userName, userMap);
        }
        return userMap;
    }
}

