/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.util.List;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.security.ResourceAccessManager;
import org.geoserver.security.ResourceAccessManagerWrapper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.security.core.Authentication;

public class ResourceAccessManagerWrapperTest {
    private ResourceAccessManagerWrapper wrapper;
    private ResourceAccessManager delegate;
    private Authentication user;

    @Before
    public void setUp() {
        this.user = (Authentication)Mockito.mock(Authentication.class);
        this.delegate = (ResourceAccessManager)Mockito.mock(ResourceAccessManager.class);
        this.wrapper = new ResourceAccessManagerWrapper(){};
        this.wrapper.setDelegate(this.delegate);
    }

    @Test
    public void getAccessLimitsWorkspaceInfo() {
        WorkspaceInfo ws = (WorkspaceInfo)Mockito.mock(WorkspaceInfo.class);
        this.wrapper.getAccessLimits(this.user, ws);
        ((ResourceAccessManager)Mockito.verify((Object)this.delegate, (VerificationMode)Mockito.times((int)1))).getAccessLimits(this.user, ws);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.delegate});
    }

    @Test
    public void getAccessLimitsLayerInfo() {
        LayerInfo layer = (LayerInfo)Mockito.mock(LayerInfo.class);
        this.wrapper.getAccessLimits(this.user, layer);
        ((ResourceAccessManager)Mockito.verify((Object)this.delegate, (VerificationMode)Mockito.times((int)1))).getAccessLimits(this.user, layer);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.delegate});
    }

    @Test
    public void getAccessLimitsLayerInfoContainers() {
        LayerInfo layer = (LayerInfo)Mockito.mock(LayerInfo.class);
        List containers = List.of();
        this.wrapper.getAccessLimits(this.user, layer, containers);
        ((ResourceAccessManager)Mockito.verify((Object)this.delegate, (VerificationMode)Mockito.times((int)1))).getAccessLimits(this.user, layer, containers);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.delegate});
    }

    @Test
    public void getAccessLimitsResourceInfo() {
        ResourceInfo res = (ResourceInfo)Mockito.mock(ResourceInfo.class);
        this.wrapper.getAccessLimits(this.user, res);
        ((ResourceAccessManager)Mockito.verify((Object)this.delegate, (VerificationMode)Mockito.times((int)1))).getAccessLimits(this.user, res);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.delegate});
    }

    @Test
    public void getAccessLimitsStyleInfo() {
        StyleInfo style = (StyleInfo)Mockito.mock(StyleInfo.class);
        this.wrapper.getAccessLimits(this.user, style);
        ((ResourceAccessManager)Mockito.verify((Object)this.delegate, (VerificationMode)Mockito.times((int)1))).getAccessLimits(this.user, style);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.delegate});
    }

    @Test
    public void getAccessLimitsLayerGroupInfo() {
        LayerGroupInfo lg = (LayerGroupInfo)Mockito.mock(LayerGroupInfo.class);
        this.wrapper.getAccessLimits(this.user, lg);
        ((ResourceAccessManager)Mockito.verify((Object)this.delegate, (VerificationMode)Mockito.times((int)1))).getAccessLimits(this.user, lg);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.delegate});
    }

    @Test
    public void getAccessLimitsLayerGroupInfoContainers() {
        LayerGroupInfo lg = (LayerGroupInfo)Mockito.mock(LayerGroupInfo.class);
        List containers = List.of();
        this.wrapper.getAccessLimits(this.user, lg, containers);
        ((ResourceAccessManager)Mockito.verify((Object)this.delegate, (VerificationMode)Mockito.times((int)1))).getAccessLimits(this.user, lg, containers);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.delegate});
    }

    @Test
    public void getSecurityFilter() {
        this.wrapper.getSecurityFilter(this.user, ResourceInfo.class);
        ((ResourceAccessManager)Mockito.verify((Object)this.delegate, (VerificationMode)Mockito.times((int)1))).getSecurityFilter(this.user, ResourceInfo.class);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.delegate});
    }

    @Test
    public void isWorkspaceAdmin() {
        Catalog catalog = (Catalog)Mockito.mock(Catalog.class);
        this.wrapper.isWorkspaceAdmin(this.user, catalog);
        ((ResourceAccessManager)Mockito.verify((Object)this.delegate, (VerificationMode)Mockito.times((int)1))).isWorkspaceAdmin(this.user, catalog);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.delegate});
    }

    @Test
    public void unwrap() {
        Assert.assertSame((Object)this.delegate, (Object)this.wrapper.unwrap());
        this.wrapper.setDelegate(null);
        Assert.assertNull((Object)this.wrapper.unwrap());
        this.wrapper.setDelegate(this.delegate);
        Assert.assertSame((Object)this.delegate, (Object)this.wrapper.unwrap());
    }
}

