/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import javax.servlet.http.HttpServletRequest;
import org.geoserver.security.GeoServerHttpFirewall;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.security.web.firewall.RequestRejectedException;

public class GeoServerHttpFirewallTest {
    private final GeoServerHttpFirewall firewall = new GeoServerHttpFirewall();

    @After
    public void resetProperty() {
        GeoServerHttpFirewallTest.setProperty(null);
    }

    @Test
    public void testForwardSlashEncoded() {
        this.doTestPath(null, "%2f", true);
        this.doTestPath(true, "%2f", true);
        this.doTestPath(false, "%2f", true);
        this.doTestPath(null, "%2F", true);
        this.doTestPath(true, "%2F", true);
        this.doTestPath(false, "%2F", true);
    }

    @Test
    public void testBackSlashDecoded() {
        this.doTestPath(null, "\\", true);
        this.doTestPath(true, "\\", true);
        this.doTestPath(false, "\\", false);
    }

    @Test
    public void testBackSlashEncoded() {
        this.doTestPath(null, "%5c", true);
        this.doTestPath(true, "%5c", true);
        this.doTestPath(false, "%5c", false);
        this.doTestPath(null, "%5C", true);
        this.doTestPath(true, "%5C", true);
        this.doTestPath(false, "%5C", false);
    }

    @Test
    public void testPercentEncoded() {
        this.doTestPath(null, "%25", true);
        this.doTestPath(true, "%25", true);
        this.doTestPath(false, "%25", false);
    }

    @Test
    public void testPeriodEncoded() {
        this.doTestPath(null, "%2e", true);
        this.doTestPath(true, "%2e", true);
        this.doTestPath(false, "%2e", false);
        this.doTestPath(null, "%2E", true);
        this.doTestPath(true, "%2E", true);
        this.doTestPath(false, "%2E", false);
    }

    @Test
    public void testSemicolonDecoded() {
        this.doTestPath(null, ";", true);
        this.doTestPath(true, ";", true);
        this.doTestPath(false, ";", false);
    }

    @Test
    public void testSemicolonEncoded() {
        this.doTestPath(null, "%3b", true);
        this.doTestPath(true, "%3b", true);
        this.doTestPath(false, "%3b", false);
        this.doTestPath(null, "%3B", true);
        this.doTestPath(true, "%3B", true);
        this.doTestPath(false, "%3B", false);
    }

    @Test
    public void testNonNormalizedPath() {
        this.doTestPath(null, "//", false);
        this.doTestPath(true, "//", false);
        this.doTestPath(false, "//", false);
    }

    private void doTestPath(Boolean strict, String path, boolean exceptionExpected) {
        GeoServerHttpFirewallTest.setProperty(strict);
        MockHttpServletRequest request = new MockHttpServletRequest("GET", path);
        if (exceptionExpected) {
            Assert.assertThrows(RequestRejectedException.class, () -> this.firewall.getFirewalledRequest((HttpServletRequest)request));
        } else {
            Assert.assertNotNull((Object)this.firewall.getFirewalledRequest((HttpServletRequest)request));
        }
    }

    private static void setProperty(Boolean strict) {
        if (strict == null) {
            System.clearProperty("GEOSERVER_USE_STRICT_FIREWALL");
        } else {
            System.setProperty("GEOSERVER_USE_STRICT_FIREWALL", strict.toString());
        }
    }
}

