/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows.kvp;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.geoserver.ows.kvp.NamespaceKvpParser;
import org.geoserver.platform.ServiceException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.xml.sax.helpers.NamespaceSupport;

public class NamespaceKvpParserTest {
    private NamespaceKvpParser parser;

    @Before
    public void setUp() throws Exception {
        this.parser = new NamespaceKvpParser("namespace");
    }

    @Test
    public void testEmpty() throws Exception {
        NamespaceSupport ctx = this.parser.parse("");
        Assert.assertNotNull((Object)ctx);
        List<String> prefixes = this.getPrefixes(ctx);
        Assert.assertTrue((boolean)prefixes.contains("xml"));
        Assert.assertEquals((long)1L, (long)prefixes.size());
    }

    @Test
    public void testFormatError() throws Exception {
        try {
            this.parser.parse("xmlns[bad=format]");
            Assert.fail((String)"Expected IAE");
        }
        catch (ServiceException e) {
            this.assertProperServiceException(e);
        }
        try {
            this.parser.parse("xmlns(bad=http://format]");
            Assert.fail((String)"Expected IAE");
        }
        catch (ServiceException e) {
            this.assertProperServiceException(e);
        }
        try {
            this.parser.parse("bad=http://format");
            Assert.fail((String)"Expected IAE");
        }
        catch (ServiceException e) {
            this.assertProperServiceException(e);
        }
    }

    void assertProperServiceException(ServiceException e) {
        Assert.assertEquals((Object)"InvalidParameterValue", (Object)e.getCode());
        Assert.assertEquals((Object)this.parser.getKey(), (Object)e.getLocator());
    }

    @Test
    public void testSingle() throws Exception {
        NamespaceSupport ctx = this.parser.parse("xmlns(foo=http://bar)");
        Assert.assertEquals((Object)"http://bar", (Object)ctx.getURI("foo"));
    }

    @Test
    public void testMultiple() throws Exception {
        NamespaceSupport ctx = this.parser.parse("xmlns(foo=http://bar), xmlns(ex=http://example.com),xmlns(gs=http://geoserver.org)");
        Assert.assertEquals((Object)"http://bar", (Object)ctx.getURI("foo"));
        Assert.assertEquals((Object)"http://example.com", (Object)ctx.getURI("ex"));
        Assert.assertEquals((Object)"http://geoserver.org", (Object)ctx.getURI("gs"));
    }

    @Test
    public void testDefaultNamespace() throws Exception {
        NamespaceSupport ctx = this.parser.parse("xmlns(http://default.namespace.com)");
        Assert.assertEquals((Object)"http://default.namespace.com", (Object)ctx.getURI(""));
    }

    private List<String> getPrefixes(NamespaceSupport ctx) {
        Enumeration<String> prefixes = ctx.getPrefixes();
        ArrayList<String> l = new ArrayList<String>();
        while (prefixes.hasMoreElements()) {
            l.add(prefixes.nextElement());
        }
        return l;
    }

    @Test
    public void testWfs20Syntax() throws Exception {
        NamespaceKvpParser parser = new NamespaceKvpParser("namespaces", true);
        NamespaceSupport ctx = parser.parse("xmlns(http://bar), xmlns(ex,http://example.com),xmlns(gs,http://geoserver.org)");
        Assert.assertEquals((Object)"http://bar", (Object)ctx.getURI(""));
        Assert.assertEquals((Object)"http://example.com", (Object)ctx.getURI("ex"));
        Assert.assertEquals((Object)"http://geoserver.org", (Object)ctx.getURI("gs"));
    }
}

