/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows;

import java.util.Collections;
import java.util.HashMap;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.LanguageURLMangler;
import org.geoserver.ows.Request;
import org.geoserver.ows.URLMangler;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.geoserver.test.SystemTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SystemTest.class})
public class LanguageURLManglerTest
extends GeoServerSystemTestSupport {
    @Test
    public void testLanguageParam() {
        LanguageURLMangler languageURLMangler = new LanguageURLMangler();
        Request wrappedRequest = new Request();
        wrappedRequest.setRawKvp(Collections.singletonMap("Language", "it"));
        Dispatcher.REQUEST.set(wrappedRequest);
        HashMap accumulator = new HashMap();
        languageURLMangler.mangleURL(null, null, accumulator, URLMangler.URLType.SERVICE);
        Assert.assertEquals((Object)"it", accumulator.get("Language"));
    }

    @Test
    public void testAcceptLanguagesCommaParam() {
        LanguageURLMangler languageURLMangler = new LanguageURLMangler();
        Request wrappedRequest = new Request();
        wrappedRequest.setRawKvp(Collections.singletonMap("AcceptLanguages", "en, it, de"));
        Dispatcher.REQUEST.set(wrappedRequest);
        HashMap accumulator = new HashMap();
        languageURLMangler.mangleURL(null, null, accumulator, URLMangler.URLType.SERVICE);
        Assert.assertEquals((Object)"en", accumulator.get("Language"));
    }

    @Test
    public void testAcceptLanguagesSpaceParam() {
        LanguageURLMangler languageURLMangler = new LanguageURLMangler();
        Request wrappedRequest = new Request();
        wrappedRequest.setRawKvp(Collections.singletonMap("AcceptLanguages", "de fr it"));
        Dispatcher.REQUEST.set(wrappedRequest);
        HashMap accumulator = new HashMap();
        languageURLMangler.mangleURL(null, null, accumulator, URLMangler.URLType.SERVICE);
        Assert.assertEquals((Object)"de", accumulator.get("Language"));
    }

    @Test
    public void testNoLanguagesParams() {
        LanguageURLMangler languageURLMangler = new LanguageURLMangler();
        Request wrappedRequest = new Request();
        Dispatcher.REQUEST.set(wrappedRequest);
        HashMap accumulator = new HashMap();
        languageURLMangler.mangleURL(null, null, accumulator, URLMangler.URLType.SERVICE);
        Assert.assertTrue((boolean)accumulator.isEmpty());
    }

    @Test
    public void testPriorityLanguageParam() {
        LanguageURLMangler languageURLMangler = new LanguageURLMangler();
        Request wrappedRequest = new Request();
        Dispatcher.REQUEST.set(wrappedRequest);
        wrappedRequest.setRawKvp(Collections.singletonMap("AcceptLanguages", "de fr it"));
        wrappedRequest.setRawKvp(Collections.singletonMap("Language", "it"));
        HashMap accumulator = new HashMap();
        languageURLMangler.mangleURL(null, null, accumulator, URLMangler.URLType.SERVICE);
        Assert.assertEquals((Object)"it", accumulator.get("Language"));
    }
}

