/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.logging;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.junit.Assert;

@Plugin(name="TestAppender", category="Core", elementType="appender")
public class TestAppender
extends AbstractAppender
implements AutoCloseable {
    private final List<LogEvent> log = new ArrayList<LogEvent>();
    private String trigger;

    public TestAppender(String name, Filter filter) {
        super(name, filter, null, false, null);
    }

    @PluginFactory
    public static TestAppender createAppender(@PluginAttribute(value="name") String name, @PluginElement(value="Filter") Filter filter) {
        return new TestAppender(name, filter);
    }

    public void append(LogEvent event) {
        String formattedMessage;
        this.log.add(event);
        if (this.trigger != null && (formattedMessage = this.getMessage(event)).contains(this.trigger)) {
            Assert.fail((String)("The trigger message '" + this.trigger + "' is still there!"));
        }
    }

    private String getMessage(LogEvent event) {
        Throwable t;
        String message = event.getMessage().getFormattedMessage();
        if (StringUtils.isBlank((String)message) && (t = event.getThrown()) != null) {
            message = t.getMessage();
        }
        return message;
    }

    public void startRecording() {
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration configuration = ctx.getConfiguration();
        Appender check = configuration.getAppender(this.getName());
        if (check == null) {
            configuration.addAppender((Appender)this);
            this.start();
        } else if (check != this) {
            throw new IllegalStateException("Unable to configure '" + this.getName() + "' appender, as " + check + " is already configured as '" + this.getName() + "'.");
        }
    }

    public void startRecording(String name) {
        this.startRecording();
        Logger logger = (Logger)LogManager.getLogger((String)name);
        logger.addAppender((Appender)this);
    }

    public void assertTrue(String snippet) {
        for (LogEvent event : this.log) {
            String formattedMessage = event.getMessage().getFormattedMessage();
            if (!formattedMessage.contains(snippet)) continue;
            return;
        }
        Assert.fail((String)("Log does not contain '" + snippet + "'"));
    }

    public void assertTrue(String message, String snippet) {
        for (LogEvent event : this.log) {
            String formattedMessage = this.getMessage(event);
            if (!formattedMessage.contains(snippet)) continue;
            return;
        }
        if (message != null) {
            Assert.fail((String)message);
        } else {
            Assert.fail((String)("Log does not contain '" + snippet + "'"));
        }
    }

    public void assertFalse(String expectedSnippet) {
        for (LogEvent event : this.log) {
            String formattedMessage = this.getMessage(event);
            Assert.assertFalse((boolean)formattedMessage.contains(expectedSnippet));
        }
    }

    public void assertFalse(String message, String expectedSnippet) {
        for (LogEvent event : this.log) {
            String formattedMessage = this.getMessage(event);
            Assert.assertFalse((String)message, (boolean)formattedMessage.contains(expectedSnippet));
        }
    }

    public void stopRecording() {
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration configuration = ctx.getConfiguration();
        Appender check = configuration.getAppender(this.getName());
        if (check != null) {
            if (check == this) {
                configuration.getAppenders().remove(this.getName(), this);
                this.stopRecording();
            } else {
                throw new IllegalStateException("Unable to de-configure '" + this.getName() + "' appender, as " + check + " is already configured as '" + this.getName() + "'.");
            }
        }
    }

    public void stopRecording(String name) {
        Logger logger = (Logger)LogManager.getLogger((String)name);
        logger.getAppenders().values().remove(this);
        this.stopRecording();
    }

    @Override
    public void close() throws IOException {
        try {
            LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
            Configuration configuration = ctx.getConfiguration();
            configuration.getAppenders().values().remove(this);
        }
        finally {
            this.log.clear();
        }
    }

    public void trigger(String trigger) {
        this.trigger = trigger;
    }
}

