/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.function;

import java.util.ArrayList;
import java.util.List;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.Predicates;
import org.geoserver.catalog.impl.LayerInfoImpl;
import org.geoserver.function.GeoServerFunctionFactory;
import org.geoserver.function.IsInstanceOf;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.expression.Literal;
import org.geotools.factory.CommonFactoryFinder;
import org.junit.Assert;
import org.junit.Test;

public class InstanceOfTest {
    @Test
    public void testFactory() {
        GeoServerFunctionFactory factory = new GeoServerFunctionFactory();
        List functionNames = factory.getFunctionNames();
        Assert.assertNotNull((Object)functionNames);
        Assert.assertEquals((long)1L, (long)functionNames.size());
        Assert.assertEquals((Object)IsInstanceOf.NAME, functionNames.get(0));
        FilterFactory ff = CommonFactoryFinder.getFilterFactory();
        ArrayList<Literal> args = new ArrayList<Literal>();
        args.add(ff.literal(Object.class));
        Function f = factory.function(IsInstanceOf.NAME.getFunctionName(), args, null);
        Assert.assertNotNull((Object)f);
        f = factory.function(IsInstanceOf.NAME.getName(), args, null);
        Assert.assertNotNull((Object)f);
        boolean catchedException = false;
        try {
            args.add(ff.literal(Object.class));
            f = factory.function(IsInstanceOf.NAME.getName(), args, null);
        }
        catch (IllegalArgumentException e) {
            catchedException = true;
        }
        Assert.assertTrue((boolean)catchedException);
        catchedException = false;
        try {
            f = factory.function(IsInstanceOf.NAME.getName(), null, null);
        }
        catch (NullPointerException e) {
            catchedException = true;
        }
        Assert.assertTrue((boolean)catchedException);
    }

    @Test
    public void testFunction() {
        Filter filter = Predicates.isInstanceOf(Object.class);
        Assert.assertNotNull((Object)filter);
        Assert.assertTrue((boolean)(filter instanceof PropertyIsEqualTo));
    }

    @Test
    public void testInstanceOfObject() {
        Filter filter = Predicates.isInstanceOf(Object.class);
        Assert.assertTrue((boolean)filter.evaluate(new Object()));
        Assert.assertTrue((boolean)filter.evaluate((Object)"test"));
        Assert.assertTrue((boolean)filter.evaluate((Object)1));
        Assert.assertTrue((boolean)filter.evaluate((Object)true));
    }

    @Test
    public void testInstanceOfString() {
        Filter filter = Predicates.isInstanceOf(String.class);
        Assert.assertTrue((boolean)filter.evaluate((Object)"test"));
        Assert.assertFalse((boolean)filter.evaluate(new Object()));
        Assert.assertFalse((boolean)filter.evaluate((Object)1));
        Assert.assertFalse((boolean)filter.evaluate((Object)true));
    }

    @Test
    public void testInstanceOfLayerInfo() {
        Filter filter = Predicates.isInstanceOf(LayerInfo.class);
        Assert.assertTrue((boolean)filter.evaluate((Object)new LayerInfoImpl()));
        Assert.assertFalse((boolean)filter.evaluate((Object)"test"));
        Assert.assertFalse((boolean)filter.evaluate(new Object()));
        Assert.assertFalse((boolean)filter.evaluate((Object)1));
        Assert.assertFalse((boolean)filter.evaluate((Object)true));
    }
}

