/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.filters;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.GenericServlet;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.easymock.EasyMock;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.impl.CoverageAccessInfoImpl;
import org.geoserver.config.impl.GeoServerImpl;
import org.geoserver.config.impl.GeoServerInfoImpl;
import org.geoserver.config.impl.SettingsInfoImpl;
import org.geoserver.filters.GeoServerFilter;
import org.geoserver.filters.LoggingFilter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.mock.web.DelegatingServletInputStream;
import org.springframework.mock.web.MockFilterChain;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

public class LoggingFilterTest {
    Logger logger;
    private static OutputStream logCapturingStream;
    private static StreamHandler customLogHandler;
    private static String expectedLogPart;
    private static String expectedHeadersLogPart;
    private static String expectedBodyLogPart;

    @Before
    public void setup() {
        this.logger = Logger.getLogger("org.geoserver.filters");
        this.logger.setLevel(Level.INFO);
        logCapturingStream = new ByteArrayOutputStream();
        customLogHandler = new StreamHandler(logCapturingStream, new SimpleFormatter());
        this.logger.addHandler(customLogHandler);
    }

    @Test
    public void testRequestLoggingDoesNotOccur() throws IOException, ServletException {
        String capturedLog = this.getLog("false", "true", "true", LoggingFilter.REQUEST_LOG_BUFFER_SIZE_DEFAULT);
        Assert.assertFalse((boolean)capturedLog.contains(expectedLogPart));
        Assert.assertFalse((boolean)capturedLog.contains(expectedHeadersLogPart));
        Assert.assertFalse((boolean)capturedLog.contains(expectedBodyLogPart));
    }

    @Test
    public void testRequestLoggingBody() throws IOException, ServletException {
        String capturedLog = this.getLog("true", "true", "false", LoggingFilter.REQUEST_LOG_BUFFER_SIZE_DEFAULT);
        Assert.assertTrue((boolean)capturedLog.contains(expectedLogPart));
        Assert.assertFalse((boolean)capturedLog.contains(expectedHeadersLogPart));
        Assert.assertTrue((boolean)capturedLog.contains(expectedBodyLogPart));
    }

    @Test
    public void testRequestLoggingBodySizeLimit() throws IOException, ServletException {
        String capturedLog = this.getLog("true", "true", "false", 10);
        Assert.assertTrue((boolean)capturedLog.contains(expectedLogPart));
        Assert.assertFalse((boolean)capturedLog.contains(expectedHeadersLogPart));
        Assert.assertTrue((boolean)capturedLog.contains(expectedBodyLogPart));
        String body = StringUtils.substringBetween((String)capturedLog, (String)"body: \n", (String)"\n");
        Assert.assertEquals((long)10L, (long)body.length());
    }

    @Test
    public void testRequestLoggingBodyZeroLimit() throws Exception {
        String capturedLog = this.getLog("true", "true", "false", 0);
        Assert.assertFalse((boolean)capturedLog.contains(expectedBodyLogPart));
    }

    @Test
    public void testRequestLoggingHeaders() throws IOException, ServletException {
        String capturedLog = this.getLog("true", "false", "true", LoggingFilter.REQUEST_LOG_BUFFER_SIZE_DEFAULT);
        Assert.assertTrue((boolean)capturedLog.contains(expectedLogPart));
        Assert.assertTrue((boolean)capturedLog.contains(expectedHeadersLogPart));
        Assert.assertFalse((boolean)capturedLog.contains(expectedBodyLogPart));
    }

    @Test
    public void testRequestLoggingBodyStreamClose() throws IOException, ServletException {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setMethod("POST");
        String generatedString = RandomStringUtils.randomAlphabetic((int)10);
        request.setContentType("text/plain");
        request.setContent(generatedString.getBytes(StandardCharsets.UTF_8));
        MockHttpServletResponse response = new MockHttpServletResponse();
        GeoServerFilter sensitiveFilter = new GeoServerFilter(){

            public void init(FilterConfig filterConfig) throws ServletException {
            }

            public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
                HttpServletRequestWrapper wrapper = new HttpServletRequestWrapper((HttpServletRequest)request){

                    public HttpServletRequest getRequest() {
                        return (HttpServletRequest)super.getRequest();
                    }

                    public ServletInputStream getInputStream() throws IOException {
                        return new DelegatingServletInputStream((InputStream)this.getRequest().getInputStream()){
                            boolean closed;
                            {
                                this.closed = false;
                            }

                            public int read() throws IOException {
                                if (this.closed) {
                                    throw new IOException("Stream is closed");
                                }
                                return super.read();
                            }

                            public void close() throws IOException {
                                super.close();
                                this.closed = true;
                            }
                        };
                    }
                };
                chain.doFilter((ServletRequest)wrapper, response);
            }

            public void destroy() {
            }
        };
        LoggingFilter loggingFilter = this.getLoggingFilter("true", "true", "false", 5);
        GenericServlet servlet = new GenericServlet(){

            public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
                ServletInputStream is = req.getInputStream();
                StringBuilder echo = new StringBuilder();
                int b = is.read();
                while (b != -1) {
                    echo.append((char)b);
                    b = is.read();
                }
                res.setContentType("text/plain");
                ServletOutputStream os = res.getOutputStream();
                os.print(echo.toString());
            }
        };
        MockFilterChain chain = new MockFilterChain((Servlet)servlet, new Filter[]{sensitiveFilter, loggingFilter});
        try {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (IOException failure) {
            if (failure.getMessage().equals("Stream is closed")) {
                Assert.fail((String)"LoggingFilterTest closed the stream");
            }
            throw failure;
        }
        String capturedLog = this.getTestCapturedLog();
        Assert.assertTrue((boolean)capturedLog.contains(expectedBodyLogPart));
    }

    private String getTestCapturedLog() throws IOException {
        customLogHandler.flush();
        return logCapturingStream.toString();
    }

    private String getLog(String requestsEnabled, String bodiesEnabled, String headersEnabled, Integer logBufferSize) throws IOException, ServletException {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setMethod("POST");
        String generatedString = RandomStringUtils.randomAlphabetic((int)10);
        request.setContentType("text/plain");
        request.setContent(generatedString.getBytes(StandardCharsets.UTF_8));
        MockHttpServletResponse response = new MockHttpServletResponse();
        LoggingFilter filter = this.getLoggingFilter(requestsEnabled, bodiesEnabled, headersEnabled, logBufferSize);
        MockFilterChain chain = new MockFilterChain();
        filter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        String capturedLog = this.getTestCapturedLog();
        return capturedLog;
    }

    private LoggingFilter getLoggingFilter(String requestsEnabled, String bodiesEnabled, String headersEnabled, Integer logBufferSize) {
        GeoServerImpl geoServer = new GeoServerImpl();
        GeoServerInfo geoServerInfo = (GeoServerInfo)EasyMock.mock(GeoServerInfoImpl.class);
        MetadataMap metadata = new MetadataMap();
        metadata.put("logRequestsEnabled", (Serializable)((Object)requestsEnabled));
        metadata.put("logBodiesEnabled", (Serializable)((Object)bodiesEnabled));
        metadata.put("logHeadersEnabled", (Serializable)((Object)headersEnabled));
        EasyMock.expect((Object)geoServerInfo.getXmlPostRequestLogBufferSize()).andReturn((Object)logBufferSize).anyTimes();
        EasyMock.expect((Object)geoServerInfo.getMetadata()).andReturn((Object)metadata).anyTimes();
        EasyMock.expect((Object)geoServerInfo.getClientProperties()).andReturn(new HashMap()).anyTimes();
        EasyMock.expect((Object)geoServerInfo.getCoverageAccess()).andReturn((Object)new CoverageAccessInfoImpl()).anyTimes();
        EasyMock.expect((Object)geoServerInfo.getSettings()).andReturn((Object)new SettingsInfoImpl()).anyTimes();
        EasyMock.replay((Object[])new Object[]{geoServerInfo});
        geoServer.setGlobal(geoServerInfo);
        LoggingFilter filter = new LoggingFilter((GeoServer)geoServer){

            public LoggingFilter setLogger(Logger logger) {
                this.logger = logger;
                return this;
            }
        }.setLogger(this.logger);
        return filter;
    }

    static {
        expectedLogPart = "took";
        expectedHeadersLogPart = "Headers:";
        expectedBodyLogPart = "body:";
    }
}

