/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.filters;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.geoserver.filters.AlternativesResponseStream;
import org.geoserver.filters.GZIPFilter;
import org.geoserver.filters.GZIPResponseStream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.DelegatingServletOutputStream;
import org.springframework.mock.web.MockFilterChain;
import org.springframework.mock.web.MockFilterConfig;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockServletContext;

public class GZipFilterTest {
    @Test
    public void testRetrieveSameOutputStream() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest("GET", "http://www.geoserver.org");
        request.addHeader("accept-encoding", (Object)"gzip");
        MockHttpServletResponse response = new MockHttpServletResponse();
        response.setContentType("text/plain");
        GZIPFilter filter = new GZIPFilter();
        MockServletContext context = new MockServletContext();
        MockFilterConfig config = new MockFilterConfig((ServletContext)context);
        config.addInitParameter("compressed-types", "text/plain");
        filter.init((FilterConfig)config);
        MockFilterChain chain = new MockFilterChain(){

            public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
                AlternativesResponseStream alternatives = (AlternativesResponseStream)response.getOutputStream();
                GZIPResponseStream gzipStream = (GZIPResponseStream)alternatives.getStream();
                MatcherAssert.assertThat((Object)gzipStream.delegateStream, (Matcher)CoreMatchers.instanceOf(DelegatingServletOutputStream.class));
            }
        };
        filter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
    }

    @Test
    public void testGZipRemovesContentLengthInt() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest("GET", "http://www.geoserver.org");
        request.addHeader("accept-encoding", (Object)"gzip");
        MockHttpServletResponse response = new MockHttpServletResponse();
        response.setContentType("text/plain");
        GZIPFilter filter = new GZIPFilter();
        MockServletContext context = new MockServletContext();
        MockFilterConfig config = new MockFilterConfig((ServletContext)context);
        config.addInitParameter("compressed-types", "text/plain");
        filter.init((FilterConfig)config);
        MockFilterChain chain = new MockFilterChain(){

            public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
                response.setContentLength(1000);
                AlternativesResponseStream alternatives = (AlternativesResponseStream)response.getOutputStream();
                ServletOutputStream gzipStream = alternatives.getStream();
                gzipStream.write(1);
            }
        };
        filter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertFalse((boolean)response.containsHeader("Content-Length"));
    }

    @Test
    public void testGZipRemovesContentLengthLong() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest("GET", "http://www.geoserver.org");
        request.addHeader("accept-encoding", (Object)"gzip");
        MockHttpServletResponse response = new MockHttpServletResponse();
        response.setContentType("text/plain");
        GZIPFilter filter = new GZIPFilter();
        MockServletContext context = new MockServletContext();
        MockFilterConfig config = new MockFilterConfig((ServletContext)context);
        config.addInitParameter("compressed-types", "text/plain");
        filter.init((FilterConfig)config);
        MockFilterChain chain = new MockFilterChain(){

            public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
                response.setContentLengthLong(1000L);
                AlternativesResponseStream alternatives = (AlternativesResponseStream)response.getOutputStream();
                ServletOutputStream gzipStream = alternatives.getStream();
                gzipStream.write(1);
            }
        };
        filter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertFalse((boolean)response.containsHeader("Content-Length"));
    }

    @Test
    public void testNotGZippedMaintainsContentLengthInt() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest("GET", "http://www.geoserver.org");
        request.addHeader("accept-encoding", (Object)"gzip");
        MockHttpServletResponse response = new MockHttpServletResponse();
        response.setContentType("text/css");
        GZIPFilter filter = new GZIPFilter();
        MockServletContext context = new MockServletContext();
        MockFilterConfig config = new MockFilterConfig((ServletContext)context);
        config.addInitParameter("compressed-types", "text/plain");
        filter.init((FilterConfig)config);
        MockFilterChain chain = new MockFilterChain(){

            public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
                response.setContentLength(1000);
                AlternativesResponseStream alternatives = (AlternativesResponseStream)response.getOutputStream();
                ServletOutputStream gzipStream = alternatives.getStream();
                gzipStream.write(1);
            }
        };
        filter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertTrue((boolean)response.containsHeader("Content-Length"));
        Assert.assertEquals((Object)"1000", (Object)response.getHeader("Content-Length"));
    }

    @Test
    public void testNotGZippedMaintainsContentLengthLong() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest("GET", "http://www.geoserver.org");
        request.addHeader("accept-encoding", (Object)"gzip");
        MockHttpServletResponse response = new MockHttpServletResponse();
        response.setContentType("text/css");
        GZIPFilter filter = new GZIPFilter();
        MockServletContext context = new MockServletContext();
        MockFilterConfig config = new MockFilterConfig((ServletContext)context);
        config.addInitParameter("compressed-types", "text/plain");
        filter.init((FilterConfig)config);
        MockFilterChain chain = new MockFilterChain(){

            public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
                response.setContentLengthLong(1000L);
                AlternativesResponseStream alternatives = (AlternativesResponseStream)response.getOutputStream();
                ServletOutputStream gzipStream = alternatives.getStream();
                gzipStream.write(1);
            }
        };
        filter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertTrue((boolean)response.containsHeader("Content-Length"));
        Assert.assertEquals((Object)"1000", (Object)response.getHeader("Content-Length"));
    }

    @Test
    public void testFlushAfterClose() throws ServletException, IOException {
        MockHttpServletRequest request = new MockHttpServletRequest("GET", "http://www.geoserver.org");
        request.addHeader("accept-encoding", (Object)"gzip");
        MockHttpServletResponse response = new MockHttpServletResponse();
        response.setContentType("text/plain");
        GZIPFilter filter = new GZIPFilter();
        MockServletContext context = new MockServletContext();
        MockFilterConfig config = new MockFilterConfig((ServletContext)context);
        config.addInitParameter("compressed-types", "text/plain");
        filter.init((FilterConfig)config);
        MockFilterChain chain = new MockFilterChain(){

            public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
                response.setContentLength(1000);
                AlternativesResponseStream alternatives = (AlternativesResponseStream)response.getOutputStream();
                ServletOutputStream gzipStream = alternatives.getStream();
                gzipStream.write(1);
                gzipStream.close();
                gzipStream.flush();
            }
        };
        filter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Assert.assertFalse((boolean)response.containsHeader("Content-Length"));
    }
}

