/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.filters;

import java.io.IOException;
import org.geoserver.filters.BufferedRequestStream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BufferedRequestStreamTest {
    BufferedRequestStream myBRS;
    String myTestString;

    @Before
    public void setUpInternal() throws Exception {
        this.myTestString = "Hello, this is a test";
        this.myBRS = new BufferedRequestStream(this.myTestString.getBytes());
    }

    @Test
    public void testReadLine() throws Exception {
        byte[] b = new byte[1024];
        int off = 0;
        int len = 1024;
        int amountRead = this.myBRS.readLine(b, off, len);
        String s = new String(b, 0, amountRead);
        Assert.assertEquals((Object)this.myTestString, (Object)s);
    }

    @Test
    public void closeClose() throws IOException {
        byte[] b = new byte[1024];
        int off = 0;
        int len = 1024;
        int amountRead = this.myBRS.readLine(b, off, len);
        String s = new String(b, 0, amountRead);
        Assert.assertEquals((Object)this.myTestString, (Object)s);
        this.myBRS.reset();
        amountRead = this.myBRS.readLine(b, off, len);
        String s2 = new String(b, 0, amountRead);
        Assert.assertEquals((Object)this.myTestString, (Object)s2);
        this.myBRS.close();
        try {
            amountRead = this.myBRS.readLine(b, off, len);
            String s3 = new String(b, 0, amountRead);
            Assert.assertEquals((Object)this.myTestString, (Object)s3);
            Assert.fail((String)"Buffered Request Stream should already be closed");
        }
        catch (IOException closed) {
            Assert.assertEquals((Object)"Stream closed", (Object)closed.getMessage());
        }
        try {
            this.myBRS.close();
        }
        catch (Throwable t) {
            Assert.fail((String)"Calling close a second time should log a message but not produce an exception");
        }
    }
}

