/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.data.test;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.Keyword;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.LegendInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ProjectionPolicy;
import org.geoserver.catalog.PublishedType;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.SLDHandler;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.event.CatalogListener;
import org.geoserver.catalog.impl.CatalogImpl;
import org.geoserver.config.ConfigurationListener;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerConfigPersister;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.GeoServerResourcePersister;
import org.geoserver.config.LoggingInfo;
import org.geoserver.config.ServiceInfo;
import org.geoserver.config.SettingsInfo;
import org.geoserver.config.impl.GeoServerImpl;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.config.util.XStreamPersisterFactory;
import org.geoserver.config.util.XStreamServiceLoader;
import org.geoserver.data.test.CiteTestData;
import org.geoserver.ows.util.OwsUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerExtensionsHelper;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.util.IOUtils;
import org.geotools.api.feature.type.Name;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.coverage.grid.io.GridFormatFinder;
import org.geotools.coverage.grid.io.StructuredGridCoverage2DReader;
import org.geotools.data.property.PropertyDataStoreFactory;
import org.geotools.feature.NameImpl;
import org.geotools.gce.imagemosaic.ImageMosaicFormat;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.util.URLs;
import org.geotools.util.Version;
import org.geotools.util.logging.Logging;

public class SystemTestData
extends CiteTestData {
    public static final QName MULTIBAND = new QName(WCS_URI, "multiband", WCS_PREFIX);
    static final Logger LOGGER = Logging.getLogger(SystemTestData.class);
    protected File data;
    Catalog catalog;

    public SystemTestData() throws IOException {
        this.data = IOUtils.createRandomDirectory((String)"./target", (String)"default", (String)"data");
        this.data.delete();
        this.data.mkdir();
    }

    public SystemTestData(File data) {
        this.data = data;
    }

    @Override
    public void setUp() throws Exception {
        GeoServerExtensionsHelper.setIsSpringContext(false);
        this.createCatalog();
        this.createConfig();
    }

    public void setUpDefault() throws Exception {
        this.setUpDefaultLayers();
        this.setUpSecurity();
    }

    public void setUpDefaultLayers() throws IOException {
        for (QName layerName : TYPENAMES) {
            this.addVectorLayer(layerName, this.catalog);
        }
    }

    public void setUpDefaultRasterLayers() throws IOException {
        this.addWorkspace(WCS_PREFIX, WCS_URI, this.catalog);
        this.addDefaultRasterLayer(TASMANIA_DEM, this.catalog);
        this.addDefaultRasterLayer(TASMANIA_BM, this.catalog);
        this.addDefaultRasterLayer(ROTATED_CAD, this.catalog);
        this.addDefaultRasterLayer(WORLD, this.catalog);
        this.addDefaultRasterLayer(MULTIBAND, this.catalog);
    }

    public void setupIAULayers(boolean raster, boolean vector) throws IOException {
        this.addWorkspace(IAU_PREFIX, IAU_URI, this.catalog);
        Map<LayerProperty, Object> marsGeographicCRS = Map.of(LayerProperty.SRS, "IAU:49900");
        if (vector) {
            this.addVectorLayer(MARS_POI, marsGeographicCRS, this.catalog);
        }
        if (raster) {
            this.addRasterLayer(MARS_VIKING, "viking.tiff", null, marsGeographicCRS, this.catalog);
        }
    }

    public void setUpWcs10RasterLayers() throws IOException {
        this.addRasterLayer(USA_WORLDIMG, "usa.zip", PNG, this.catalog);
    }

    public void setUpWcs11RasterLayers() throws IOException {
        this.setUpDefaultRasterLayers();
    }

    public void setUpVectorLayer(QName layerName) throws IOException {
        this.addVectorLayer(layerName, this.catalog);
    }

    public void setUpVectorLayer(QName qName, Map<LayerProperty, Object> props) throws IOException {
        this.addVectorLayer(qName, props, this.catalog);
    }

    public void setUpVectorLayer(QName qName, Map<LayerProperty, Object> props, Class<?> scope) throws IOException {
        this.addVectorLayer(qName, props, scope, this.catalog);
    }

    public void setUpVectorLayer(QName qName, Map<LayerProperty, Object> props, String filename, Class<?> scope) throws IOException {
        this.addVectorLayer(qName, props, filename, scope, this.catalog);
    }

    public void setUpRasterLayer(QName qName, String filename, String extension) throws IOException {
        this.addRasterLayer(qName, filename, extension, this.catalog);
    }

    public void setUpRasterLayer(QName qName, String filename, String extension, Map<LayerProperty, Object> props) throws IOException {
        this.addRasterLayer(qName, filename, extension, props, this.catalog);
    }

    public void setUpRasterLayer(QName qName, String filename, String extension, Map<LayerProperty, Object> props, Class<?> scope) throws IOException {
        this.addRasterLayer(qName, filename, extension, props, scope, this.catalog);
    }

    public void setUpSecurity() throws IOException {
        File secDir = new File(this.getDataDirectoryRoot(), "security");
        IOUtils.decompress((InputStream)SystemTestData.class.getResourceAsStream("security.zip"), (File)secDir);
        String javaVendor = System.getProperty("java.vendor");
        if (javaVendor.contains("IBM")) {
            IOUtils.copy((File)new File(secDir, "geoserver.jceks.ibm"), (File)new File(secDir, "geoserver.jceks"));
        } else {
            IOUtils.copy((File)new File(secDir, "geoserver.jceks.default"), (File)new File(secDir, "geoserver.jceks"));
        }
    }

    protected void createCatalog() throws IOException {
        CatalogImpl catalog = new CatalogImpl();
        catalog.setExtendedValidation(false);
        catalog.setResourceLoader(new GeoServerResourceLoader(this.data));
        catalog.addListener((CatalogListener)new GeoServerConfigPersister(catalog.getResourceLoader(), this.createXStreamPersister()));
        catalog.addListener((CatalogListener)new GeoServerResourcePersister((Catalog)catalog));
        this.addWorkspace(DEFAULT_PREFIX, DEFAULT_URI, (Catalog)catalog);
        this.addWorkspace(SF_PREFIX, SF_URI, (Catalog)catalog);
        this.addWorkspace(CITE_PREFIX, CITE_URI, (Catalog)catalog);
        this.addWorkspace(CDF_PREFIX, CDF_URI, (Catalog)catalog);
        this.addWorkspace(CGF_PREFIX, CGF_URI, (Catalog)catalog);
        this.addStyle(DEFAULT_VECTOR_STYLE, (Catalog)catalog);
        this.addStyle(DEFAULT_RASTER_STYLE, (Catalog)catalog);
        this.catalog = catalog;
    }

    protected void createConfig() {
        GeoServerImpl geoServer = new GeoServerImpl();
        geoServer.addListener((ConfigurationListener)new GeoServerConfigPersister(new GeoServerResourceLoader(this.data), this.createXStreamPersister()));
        this.catalog.addListener((CatalogListener)new GeoServerResourcePersister(this.catalog));
        GeoServerInfo global = geoServer.getFactory().createGlobal();
        geoServer.setGlobal(global);
        this.addSettings(null, (GeoServer)geoServer);
        LoggingInfo logging = geoServer.getFactory().createLogging();
        geoServer.setLogging(logging);
    }

    XStreamPersister createXStreamPersister() {
        XStreamPersister xp = new XStreamPersisterFactory().createXMLPersister();
        xp.setEncryptPasswordFields(false);
        return xp;
    }

    public void addWorkspace(String name, String uri, Catalog catalog) {
        this.addWorkspace(name, uri, false, catalog);
    }

    public void addWorkspace(String name, String uri, boolean isolated, Catalog catalog) {
        WorkspaceInfo ws = catalog.getWorkspaceByName(name);
        if (ws == null) {
            ws = catalog.getFactory().createWorkspace();
            ws.setName(name);
            ws.setIsolated(isolated);
            catalog.add(ws);
        } else {
            ws.setIsolated(isolated);
            catalog.save(ws);
        }
        NamespaceInfo ns = catalog.getNamespaceByPrefix(name);
        if (ns == null) {
            ns = catalog.getFactory().createNamespace();
            ns.setPrefix(name);
            ns.setURI(uri);
            ns.setIsolated(isolated);
            catalog.add(ns);
        } else {
            ns.setURI(uri);
            ns.setIsolated(isolated);
            catalog.save(ns);
        }
    }

    public void addStyle(String name, Catalog catalog) throws IOException {
        this.addStyle(name, this.getClass(), catalog);
    }

    public void addStyle(String name, Class<?> scope, Catalog catalog) throws IOException {
        this.addStyle(name, name + ".sld", scope, catalog);
    }

    public void addStyle(String name, String filename, Class<?> scope, Catalog catalog) throws IOException {
        this.addStyle(null, name, filename, scope, catalog);
    }

    public void addStyle(WorkspaceInfo ws, String name, String filename, Class<?> scope, Catalog catalog) throws IOException {
        this.addStyle(ws, name, filename, scope, catalog, Collections.emptyMap());
    }

    public void addStyle(WorkspaceInfo ws, String name, String filename, Class<?> scope, Catalog catalog, LegendInfo legend) throws IOException {
        this.addStyle(ws, name, filename, scope, catalog, Collections.singletonMap(StyleProperty.LEGEND_INFO, legend));
    }

    public void addStyle(WorkspaceInfo ws, String name, String filename, Class<?> scope, Catalog catalog, Map<StyleProperty, Object> properties) throws IOException {
        StyleInfo style = catalog.getStyleByName(ws, name);
        if (style == null) {
            style = catalog.getFactory().createStyle();
            style.setName(name);
            style.setWorkspace(ws);
        }
        GeoServerDataDirectory data = new GeoServerDataDirectory(this.data);
        File styles = data.get(style, new String[]{""}).dir();
        String target = new File(filename).getName();
        catalog.getResourceLoader().copyFromClassPath(filename, new File(styles, target), scope);
        style.setFilename(target);
        style.setFormat(StyleProperty.FORMAT.get(properties, "sld"));
        style.setFormatVersion(StyleProperty.FORMAT_VERSION.get(properties, SLDHandler.VERSION_10));
        style.setLegend((LegendInfo)StyleProperty.LEGEND_INFO.get(properties, null));
        if (style.getId() == null) {
            catalog.add(style);
        } else {
            catalog.save(style);
        }
    }

    public void addVectorLayer(QName qName, Catalog catalog) throws IOException {
        this.addVectorLayer(qName, new HashMap<LayerProperty, Object>(), catalog);
    }

    public void addVectorLayer(QName qName, Map<LayerProperty, Object> props, Catalog catalog) throws IOException {
        this.addVectorLayer(qName, props, this.getClass(), catalog);
    }

    public void addVectorLayer(QName qName, Map<LayerProperty, Object> props, Class<?> scope, Catalog catalog) throws IOException {
        this.addVectorLayer(qName, props, qName.getLocalPart() + ".properties", scope, catalog);
    }

    public void addVectorLayer(QName qName, Map<LayerProperty, Object> props, String filename, Class<?> scope, Catalog catalog) throws IOException {
        String prefix = qName.getPrefix();
        String name = qName.getLocalPart();
        String uri = qName.getNamespaceURI();
        String storeName = LayerProperty.STORE.get(props, null) != null ? (String)LayerProperty.STORE.get(props, null) : prefix;
        if (catalog.getWorkspaceByName(prefix) == null) {
            this.addWorkspace(prefix, uri, catalog);
        }
        File storeDir = catalog.getResourceLoader().findOrCreateDirectory(storeName);
        DataStoreInfo store = catalog.getDataStoreByName(storeName);
        if (store == null) {
            store = catalog.getFactory().createDataStore();
            store.setName(storeName);
            store.setWorkspace(catalog.getWorkspaceByName(prefix));
            store.setEnabled(true);
            store.getConnectionParameters().put(PropertyDataStoreFactory.DIRECTORY.key, storeDir);
            store.getConnectionParameters().put(PropertyDataStoreFactory.NAMESPACE.key, uri);
            catalog.add((StoreInfo)store);
        }
        catalog.getResourceLoader().copyFromClassPath(filename, new File(storeDir, filename), scope);
        FeatureTypeInfo featureType = catalog.getFactory().createFeatureType();
        featureType.setStore((StoreInfo)store);
        featureType.setNamespace(catalog.getNamespaceByPrefix(prefix));
        featureType.setName(LayerProperty.NAME.get(props, name));
        featureType.setNativeName(FilenameUtils.getBaseName((String)filename));
        featureType.setTitle(name);
        featureType.setAbstract("abstract about " + name);
        String srs = SystemTestData.getLayerSRS(qName, props);
        featureType.setSRS(srs);
        try {
            featureType.setNativeCRS(CRS.decode((String)srs));
        }
        catch (Exception e) {
            LOGGER.warning("Failed to decode " + srs + ", setting the native SRS to null");
        }
        featureType.setNumDecimals(8);
        featureType.getKeywords().add(new Keyword(name));
        featureType.setEnabled(true);
        featureType.setProjectionPolicy(LayerProperty.PROJECTION_POLICY.get(props, ProjectionPolicy.NONE));
        featureType.setLatLonBoundingBox(LayerProperty.LATLON_ENVELOPE.get(props, DEFAULT_LATLON_ENVELOPE));
        featureType.setNativeBoundingBox((ReferencedEnvelope)LayerProperty.ENVELOPE.get(props, null));
        FeatureTypeInfo ft = catalog.getFeatureTypeByDataStore(store, name);
        LayerInfo layer = catalog.getLayerByName((Name)new NameImpl(uri, name));
        if (ft == null) {
            ft = featureType;
            catalog.add((ResourceInfo)featureType);
        } else if (layer == null) {
            catalog.remove((ResourceInfo)ft);
            ft = featureType;
            catalog.add((ResourceInfo)featureType);
        } else {
            new CatalogBuilder(catalog).updateFeatureType(ft, featureType);
            catalog.save((ResourceInfo)ft);
        }
        if (layer == null || !layer.getResource().getNamespace().equals((Object)catalog.getNamespaceByPrefix(prefix))) {
            layer = catalog.getFactory().createLayer();
        }
        layer.setResource((ResourceInfo)ft);
        StyleInfo defaultStyle = null;
        if (LayerProperty.STYLE.get(props, null) != null) {
            defaultStyle = catalog.getStyleByName((String)LayerProperty.STYLE.get(props, null));
        } else {
            defaultStyle = catalog.getStyleByName(name);
            if (defaultStyle == null && this.getClass().getResource(name + ".sld") != null) {
                this.addStyle(name, catalog);
                defaultStyle = catalog.getStyleByName(name);
            }
        }
        if (defaultStyle == null) {
            defaultStyle = catalog.getStyleByName(DEFAULT_VECTOR_STYLE);
        }
        layer.getStyles().clear();
        layer.setDefaultStyle(defaultStyle);
        layer.setType(PublishedType.VECTOR);
        layer.setEnabled(true);
        if (layer.getId() == null) {
            catalog.add(layer);
        } else {
            catalog.save(layer);
        }
    }

    private static String getLayerSRS(QName qName, Map<LayerProperty, Object> props) {
        String rawSrs = LayerProperty.SRS.get(props, (String)SRS.get(qName));
        if (rawSrs == null) {
            return "EPSG:4326";
        }
        String srs = rawSrs.toString();
        int idx = srs.indexOf(":");
        if (idx == -1) {
            return "EPSG:" + srs;
        }
        return srs;
    }

    public void addDefaultRasterLayer(QName name, Catalog catalog) throws IOException {
        if (name.equals(TASMANIA_DEM)) {
            this.addRasterLayer(name, "tazdem.tiff", null, catalog);
        } else if (name.equals(TASMANIA_BM)) {
            this.addRasterLayer(name, "tazbm.tiff", null, catalog);
        } else if (name.equals(ROTATED_CAD)) {
            this.addRasterLayer(name, "rotated.tiff", null, catalog);
        } else if (name.equals(WORLD)) {
            this.addRasterLayer(name, "world.tiff", null, catalog);
        } else if (name.equals(MULTIBAND)) {
            this.addRasterLayer(name, "multiband.tiff", null, catalog);
        } else {
            throw new IllegalArgumentException("Unknown default raster layer: " + name);
        }
    }

    public void addRasterLayer(QName qName, String filename, String extension, Catalog catalog) throws IOException {
        this.addRasterLayer(qName, filename, extension, new HashMap<LayerProperty, Object>(), catalog);
    }

    public void addRasterLayer(QName qName, String filename, String extension, Map<LayerProperty, Object> props, Catalog catalog) throws IOException {
        this.addRasterLayer(qName, filename, extension, props, this.getClass(), catalog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRasterLayer(QName qName, String filename, String extension, Map<LayerProperty, Object> props, Class<?> scope, Catalog catalog) throws IOException {
        AbstractGridFormat format;
        String prefix = qName.getPrefix();
        String name = qName.getLocalPart();
        File dir = new File(this.data, name);
        FileUtils.deleteQuietly((File)dir);
        dir.mkdirs();
        File file = new File(dir, filename);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        catalog.getResourceLoader().copyFromClassPath(filename, file, scope);
        String ext = FilenameUtils.getExtension((String)filename);
        if ("zip".equalsIgnoreCase(ext)) {
            IOUtils.decompress((File)file, (File)dir);
            file.delete();
            if (extension == null) {
                file = dir;
            } else {
                File file2;
                file = new File(dir, FilenameUtils.getBaseName((String)filename) + "." + extension);
                if (!file.exists() && (file2 = new File(new File(dir, dir.getName()), file.getName())).exists()) {
                    file = file2;
                }
            }
            if (!file.exists()) {
                throw new FileNotFoundException(file.getPath());
            }
        }
        if ((format = GridFormatFinder.findFormat((Object)file)) == null) {
            throw new RuntimeException("No format for " + file.getCanonicalPath());
        }
        AbstractGridCoverage2DReader reader = null;
        try {
            CoverageStoreInfo store;
            reader = format.getReader((Object)file);
            if (reader == null) {
                throw new RuntimeException("No reader for " + file.getCanonicalPath() + " with format " + format.getName());
            }
            if (catalog.getWorkspaceByName(prefix) == null) {
                this.addWorkspace(prefix, qName.getNamespaceURI(), catalog);
            }
            if ((store = catalog.getCoverageStoreByName(prefix, name)) == null) {
                store = catalog.getFactory().createCoverageStore();
            }
            store.setName(name);
            store.setWorkspace(catalog.getWorkspaceByName(prefix));
            store.setEnabled(true);
            store.setURL(URLs.fileToUrl((File)file).toString());
            store.setType(format.getName());
            if (store.getId() == null) {
                catalog.add((StoreInfo)store);
            } else {
                catalog.save((StoreInfo)store);
            }
            CatalogBuilder builder = new CatalogBuilder(catalog);
            builder.setStore((StoreInfo)store);
            String[] coverageNames = reader.getGridCoverageNames();
            if (reader instanceof StructuredGridCoverage2DReader && coverageNames != null && coverageNames.length > 1) {
                for (String coverageName : coverageNames) {
                    this.addCoverage(store, builder, (GridCoverage2DReader)reader, catalog, format, coverageName, new QName(qName.getPrefix(), coverageName), props, coverageName);
                }
            } else {
                this.addCoverage(store, builder, (GridCoverage2DReader)reader, catalog, format, name, qName, props, null);
            }
        }
        finally {
            if (reader != null) {
                reader.dispose();
            }
        }
    }

    private void addCoverage(CoverageStoreInfo store, CatalogBuilder builder, GridCoverage2DReader reader, Catalog catalog, AbstractGridFormat format, String name, QName qName, Map<LayerProperty, Object> props, String coverageName) throws IOException {
        CoverageInfo coverage = null;
        try {
            CoverageInfo cov;
            coverage = builder.buildCoverage(reader, coverageName, null);
            if (format instanceof ImageMosaicFormat) {
                coverage.getParameters().put(AbstractGridFormat.USE_JAI_IMAGEREAD.getName().getCode(), Boolean.FALSE);
            }
            coverage.setName(name);
            coverage.setTitle(name);
            coverage.setDescription(name);
            coverage.setEnabled(true);
            if (LayerProperty.SRS.get(props, (String)SRS.get(qName)) != null) {
                coverage.setSRS(SystemTestData.getLayerSRS(qName, props));
            }
            if ((cov = catalog.getCoverageByCoverageStore(store, name)) == null) {
                catalog.add((ResourceInfo)coverage);
            } else {
                builder.updateCoverage(cov, coverage);
                catalog.save((ResourceInfo)cov);
                coverage = cov;
            }
            LayerInfo layer = catalog.getLayerByName((Name)new NameImpl(qName));
            if (layer == null) {
                layer = catalog.getFactory().createLayer();
            }
            layer.setResource((ResourceInfo)coverage);
            layer.setDefaultStyle(catalog.getStyleByName(LayerProperty.STYLE.get(props, DEFAULT_RASTER_STYLE)));
            layer.setType(PublishedType.RASTER);
            layer.setEnabled(true);
            if (layer.getId() == null) {
                catalog.add(layer);
            } else {
                catalog.save(layer);
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public <T extends ServiceInfo> void addService(Class<T> serviceClass, String workspace, GeoServer geoServer) {
        Catalog catalog = geoServer.getCatalog();
        List loaders = GeoServerExtensions.extensions(XStreamServiceLoader.class);
        for (XStreamServiceLoader loader : loaders) {
            if (!serviceClass.equals(loader.getServiceClass())) continue;
            ServiceInfo created = loader.create(geoServer);
            ServiceInfo old = null;
            WorkspaceInfo ws = null;
            if (workspace != null) {
                ws = catalog.getWorkspaceByName(workspace);
                old = geoServer.getService(ws, serviceClass);
            } else {
                old = geoServer.getService(serviceClass);
            }
            if (old != null) {
                OwsUtils.copy((Object)created, (Object)old, serviceClass);
                geoServer.save(old);
                break;
            }
            created.setWorkspace(ws);
            geoServer.add(created);
            break;
        }
    }

    public void addSettings(String workspace, GeoServer geoServer) {
        SettingsInfo settings;
        WorkspaceInfo ws = workspace != null ? geoServer.getCatalog().getWorkspaceByName(workspace) : null;
        GeoServerInfo global = geoServer.getGlobal();
        SettingsInfo settingsInfo = settings = ws != null ? geoServer.getSettings(ws) : global.getSettings();
        if (settings == null) {
            settings = geoServer.getFactory().createSettings();
        }
        settings.setWorkspace(ws);
        settings.getContact().setContactPerson("Andrea Aime");
        settings.getContact().setContactEmail("andrea@geoserver.org");
        settings.getContact().setOnlineResource("https://www.osgeo.org");
        settings.getContact().setContactOrganization("Open Source Geospatial Foundation");
        settings.getContact().setAddressDeliveryPoint("9450 SW Gemini Dr. #42523, Beaverton Oregon 97008, United States");
        settings.setNumDecimals(8);
        settings.setOnlineResource("https://geoserver.org");
        settings.setVerbose(false);
        settings.setVerboseExceptions(false);
        settings.setLocalWorkspaceIncludesPrefix(false);
        if (ws != null) {
            if (settings.getId() != null) {
                geoServer.save(settings);
            } else {
                geoServer.add(settings);
            }
        } else {
            geoServer.save(global);
        }
    }

    public void copyTo(InputStream input, String location) throws IOException {
        IOUtils.copy((InputStream)input, (File)new File(this.getDataDirectoryRoot(), location));
    }

    @Override
    public void tearDown() throws Exception {
        int MAX_ATTEMPTS = 100;
        for (int i = 1; i <= MAX_ATTEMPTS; ++i) {
            try {
                this.deleteFilesOnExit(this.data);
                break;
            }
            catch (IOException e) {
                if (i == MAX_ATTEMPTS && this.data.exists()) {
                    throw new IOException("Failed to clean up test data dir after " + MAX_ATTEMPTS + " attempts", e);
                }
                System.err.println("Error occurred while removing files. Possible transient lock or H2 log race. Sleeping 100ms and retrying. Error message: " + e.getMessage());
                System.gc();
                Thread.sleep(100L);
                continue;
            }
        }
    }

    private void deleteFilesOnExit(File directory) throws IOException {
        block2: {
            try {
                FileUtils.deleteDirectory((File)this.data);
            }
            catch (IOException e) {
                if (!this.data.exists()) break block2;
                String tree = SystemTestData.printFileTree(this.data);
                throw new IOException("Failed to delete tree:\n" + tree, e);
            }
        }
    }

    private static String printFileTree(File dir) {
        StringBuilder sb = new StringBuilder();
        sb.append(dir.getPath()).append("\n");
        SystemTestData.printFileTree_(sb, "", dir);
        return sb.toString();
    }

    private static void printFileTree_(StringBuilder sb, String prefix, File dir) {
        File[] listFile = dir.listFiles();
        if (listFile != null) {
            for (int i = 0; i < listFile.length; ++i) {
                boolean last = i == listFile.length - 1;
                File file = listFile[i];
                String firstChar = last ? "\u2514" : "\u251c";
                sb.append(prefix).append(firstChar).append("\u2500\u2500").append(file.getName()).append("\n");
                if (!file.isDirectory()) continue;
                SystemTestData.printFileTree_(sb, prefix + (last ? " " : "|") + "  ", file);
            }
        }
    }

    @Override
    public File getDataDirectoryRoot() {
        return this.data;
    }

    @Override
    public boolean isTestDataAvailable() {
        return true;
    }

    public static class StyleProperty<T> {
        public static StyleProperty<String> FORMAT = new StyleProperty();
        public static StyleProperty<Version> FORMAT_VERSION = new StyleProperty();
        public static StyleProperty<LegendInfo> LEGEND_INFO = new StyleProperty();

        T get(Map<StyleProperty, Object> map, T def) {
            return (T)(map != null && map.containsKey(this) ? map.get(this) : def);
        }
    }

    public static class LayerProperty<T> {
        public static LayerProperty<String> NAME = new LayerProperty();
        public static LayerProperty<ProjectionPolicy> PROJECTION_POLICY = new LayerProperty();
        public static LayerProperty<String> STYLE = new LayerProperty();
        public static LayerProperty<ReferencedEnvelope> ENVELOPE = new LayerProperty();
        public static LayerProperty<ReferencedEnvelope> LATLON_ENVELOPE = new LayerProperty();
        public static LayerProperty<String> SRS = new LayerProperty();
        public static LayerProperty<String> STORE = new LayerProperty();

        T get(Map<LayerProperty, Object> map, T def) {
            return (T)(map != null && map.containsKey(this) ? map.get(this) : def);
        }
    }
}

