/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config.datadir;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.servlet.ServletContext;
import org.awaitility.Awaitility;
import org.geoserver.GeoServerConfigurationLock;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.impl.ModificationProxy;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.LoggingInfo;
import org.geoserver.config.ServiceInfo;
import org.geoserver.config.datadir.ConfigLoader;
import org.geoserver.config.datadir.DataDirectoryLoaderTestSupport;
import org.geoserver.config.datadir.DataDirectoryWalker;
import org.geoserver.config.util.XStreamPersisterFactory;
import org.geoserver.config.util.XStreamServiceLoader;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.FileSystemResourceStore;
import org.geoserver.platform.resource.LockProvider;
import org.geoserver.platform.resource.MemoryLockProvider;
import org.geoserver.util.IOUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.mock.web.MockServletContext;
import org.springframework.web.context.support.XmlWebApplicationContext;

public class MinimalConfigLoaderSupportIntegrationTest {
    @Rule
    public final TemporaryFolder temp = new TemporaryFolder();
    private File dataDirectory;
    private DataDirectoryLoaderTestSupport support;

    @Before
    public void setUp() throws IOException {
        this.dataDirectory = this.temp.newFolder("datadir");
        this.support = DataDirectoryLoaderTestSupport.withPersistence(this.dataDirectory);
        System.setProperty("GEOSERVER_DATA_DIR", this.dataDirectory.getAbsolutePath());
        System.setProperty("GEOSERVER_DATA_DIR_LOADER_ENABLED", "true");
    }

    @After
    public void tearDown() {
        System.clearProperty("GEOSERVER_DATA_DIR");
        System.clearProperty("GEOSERVER_DATA_DIR_LOADER_ENABLED");
        this.support.tearDown();
    }

    @Test
    public void testEmptyGlobalXml() throws IOException {
        Files.createFile(this.dataDirectory.toPath().resolve("global.xml"), new FileAttribute[0]);
        Assert.assertThrows(BeanCreationException.class, this::initContext);
    }

    @Test
    public void testNoMissingConfigs() throws IOException {
        GeoServerInfo global = this.support.getGeoServer().getFactory().createGlobal();
        this.support.setUpServiceLoaders();
        global.getSettings().setTitle("pre-existing");
        LoggingInfo logging = this.support.getGeoServer().getFactory().createLogging();
        logging.setLocation("logs/gs2.log");
        DataDirectoryLoaderTestSupport.TestService1.TestService1Impl service1 = new DataDirectoryLoaderTestSupport.TestService1.TestService1Impl();
        service1.setTitle("pre-existing service 1");
        DataDirectoryLoaderTestSupport.TestService2.TestService2Impl service2 = new DataDirectoryLoaderTestSupport.TestService2.TestService2Impl();
        service2.setTitle("pre-existing service 2");
        this.support.getGeoServer().setGlobal(global);
        this.support.getGeoServer().setLogging(logging);
        this.support.getGeoServer().add((ServiceInfo)service1);
        this.support.getGeoServer().add((ServiceInfo)service2);
        this.support.cleanUp();
        XmlWebApplicationContext context = this.initContext();
        GeoServer gs = (GeoServer)context.getBean(GeoServer.class);
        Assert.assertEquals((Object)global, (Object)gs.getGlobal());
        Assert.assertEquals((Object)logging, (Object)gs.getLogging());
        Assert.assertEquals((Object)service1, (Object)ModificationProxy.unwrap((Object)((DataDirectoryLoaderTestSupport.TestService1)gs.getService(DataDirectoryLoaderTestSupport.TestService1.class))));
        Assert.assertEquals((Object)service2, (Object)ModificationProxy.unwrap((Object)((DataDirectoryLoaderTestSupport.TestService2)gs.getService(DataDirectoryLoaderTestSupport.TestService2.class))));
    }

    @Test
    public void testAddMissingGlobalConfig() {
        this.support.getGeoServer().setLogging(this.support.getGeoServer().getFactory().createLogging());
        this.support.getGeoServer().add((ServiceInfo)new DataDirectoryLoaderTestSupport.TestService1.TestService1Impl());
        this.support.getGeoServer().add((ServiceInfo)new DataDirectoryLoaderTestSupport.TestService2.TestService2Impl());
        this.support.cleanUp();
        XmlWebApplicationContext context = this.initContext();
        GeoServerInfo global = ((GeoServer)context.getBean(GeoServer.class)).getGlobal();
        Assert.assertNotNull((Object)global);
        Assert.assertTrue((boolean)Files.exists(this.dataDirectory.toPath().resolve("global.xml"), new LinkOption[0]));
    }

    @Test
    public void testAddMissingLoggingConfig() {
        this.support.getGeoServer().setGlobal(this.support.getGeoServer().getFactory().createGlobal());
        this.support.getGeoServer().add((ServiceInfo)new DataDirectoryLoaderTestSupport.TestService1.TestService1Impl());
        this.support.getGeoServer().add((ServiceInfo)new DataDirectoryLoaderTestSupport.TestService2.TestService2Impl());
        this.support.cleanUp();
        Assert.assertFalse((boolean)Files.exists(this.dataDirectory.toPath().resolve("logging.xml"), new LinkOption[0]));
        XmlWebApplicationContext context = this.initContext();
        Assert.assertTrue((boolean)Files.exists(this.dataDirectory.toPath().resolve("logging.xml"), new LinkOption[0]));
        LoggingInfo logging = ((GeoServer)context.getBean(GeoServer.class)).getLogging();
        Assert.assertNotNull((Object)logging);
        Assert.assertEquals((Object)"DEFAULT_LOGGING", (Object)logging.getLevel());
        Assert.assertEquals((Object)"logs/geoserver.log", (Object)logging.getLocation());
        Assert.assertTrue((boolean)logging.isStdOutLogging());
    }

    @Test
    public void testAddMissingRootServices() {
        this.support.getGeoServer().setGlobal(this.support.getGeoServer().getFactory().createGlobal());
        this.support.getGeoServer().setLogging(this.support.getGeoServer().getFactory().createLogging());
        this.support.cleanUp();
        XmlWebApplicationContext context = this.initContext();
        GeoServer gs = (GeoServer)context.getBean(GeoServer.class);
        Assert.assertNotNull((Object)gs.getService(DataDirectoryLoaderTestSupport.TestService1.class));
        Assert.assertNotNull((Object)gs.getService(DataDirectoryLoaderTestSupport.TestService2.class));
        Assert.assertTrue((boolean)Files.exists(this.dataDirectory.toPath().resolve("service1.xml"), new LinkOption[0]));
        Assert.assertTrue((boolean)Files.exists(this.dataDirectory.toPath().resolve("service2.xml"), new LinkOption[0]));
    }

    @Test
    public void testPreExistingService() {
        this.support.getGeoServer().setGlobal(this.support.getGeoServer().getFactory().createGlobal());
        this.support.getGeoServer().setLogging(this.support.getGeoServer().getFactory().createLogging());
        this.support.setUpServiceLoaders();
        DataDirectoryLoaderTestSupport.TestService1.TestService1Impl customService = new DataDirectoryLoaderTestSupport.TestService1.TestService1Impl();
        customService.setName("customName");
        this.support.getGeoServer().add((ServiceInfo)customService);
        this.support.cleanUp();
        XmlWebApplicationContext context = this.initContext();
        GeoServer gs = (GeoServer)context.getBean(GeoServer.class);
        DataDirectoryLoaderTestSupport.TestService1 service1 = (DataDirectoryLoaderTestSupport.TestService1)gs.getService(DataDirectoryLoaderTestSupport.TestService1.class);
        Assert.assertNotNull((Object)service1);
        Assert.assertEquals((Object)"customName", (Object)service1.getName());
        Assert.assertNotNull((Object)gs.getService(DataDirectoryLoaderTestSupport.TestService2.class));
    }

    @Test
    public void testConcurrentLoadFromEmptyDirectoryCreatesMinimalConfig() {
        List<ConfigLoader> loaders = this.createConfigLoaders(8);
        this.loadConcurrently(loaders);
        Assert.assertTrue((boolean)Files.exists(this.dataDirectory.toPath().resolve("global.xml"), new LinkOption[0]));
        Assert.assertTrue((boolean)Files.exists(this.dataDirectory.toPath().resolve("logging.xml"), new LinkOption[0]));
        Assert.assertTrue((boolean)Files.exists(this.dataDirectory.toPath().resolve("service1.xml"), new LinkOption[0]));
        Assert.assertTrue((boolean)Files.exists(this.dataDirectory.toPath().resolve("service2.xml"), new LinkOption[0]));
        for (ConfigLoader cl2 : loaders) {
            GeoServer gs = cl2.geoServer;
            LoggingInfo logging = gs.getLogging();
            Assert.assertEquals((Object)"DEFAULT_LOGGING", (Object)logging.getLevel());
            Assert.assertEquals((Object)"logs/geoserver.log", (Object)logging.getLocation());
            Assert.assertTrue((boolean)logging.isStdOutLogging());
        }
        String id = ((DataDirectoryLoaderTestSupport.TestService1)loaders.get((int)0).geoServer.getService(DataDirectoryLoaderTestSupport.TestService1.class)).getId();
        Assert.assertNotNull((Object)id);
        Set service1Ids = loaders.stream().map(cl -> cl.geoServer).map(l -> (DataDirectoryLoaderTestSupport.TestService1)l.getService(DataDirectoryLoaderTestSupport.TestService1.class)).map(ServiceInfo::getId).collect(Collectors.toSet());
        Assert.assertEquals(Set.of(id), service1Ids);
    }

    @Test
    public void testNesterLayerGroups() throws IOException {
        File testDatadir = Path.of("src", "test", "resources", "data_dir", "nested_layer_groups").toFile();
        Assert.assertTrue((boolean)testDatadir.isDirectory());
        IOUtils.deepCopy((File)testDatadir, (File)this.dataDirectory);
        try (XmlWebApplicationContext context = this.initNewContext();){
            Catalog catalog = (Catalog)context.getBean("rawCatalog", Catalog.class);
            Assert.assertNotNull((Object)catalog.getStyleByName("style"));
            Assert.assertNotNull((Object)catalog.getWorkspaceByName("topp"));
            Assert.assertNotNull((Object)catalog.getLayerByName("topp:layer1"));
            Assert.assertNotNull((Object)catalog.getLayerByName("topp:layer2"));
            Assert.assertNotNull((Object)catalog.getLayerGroupByName("simplegroup"));
            Assert.assertNotNull((Object)catalog.getLayerGroupByName("nestedgroup"));
        }
    }

    @Test
    public void testStyleGroup() throws IOException {
        File testDatadir = Path.of("src", "test", "resources", "data_dir", "nested_layer_groups").toFile();
        Assert.assertTrue((boolean)testDatadir.isDirectory());
        IOUtils.deepCopy((File)testDatadir, (File)this.dataDirectory);
        try (XmlWebApplicationContext intialContext = this.initNewContext();){
            Catalog catalog = (Catalog)intialContext.getBean("rawCatalog", Catalog.class);
            StyleInfo styleGroup = catalog.getStyleByName("namedstyle");
            Assert.assertNotNull((Object)styleGroup);
            LayerGroupInfo lg = catalog.getLayerGroupByName("simplegroup");
            lg.getLayers().clear();
            lg.getStyles().clear();
            lg.setMode(LayerGroupInfo.Mode.SINGLE);
            lg.getLayers().add(null);
            lg.getStyles().add(styleGroup);
            catalog.save(lg);
            this.support.cleanUp();
        }
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> {
            try (XmlWebApplicationContext context = this.initNewContext();){
                Catalog catalog = (Catalog)context.getBean("rawCatalog", Catalog.class);
                LayerGroupInfo lg = catalog.getLayerGroupByName("simplegroup");
                Assert.assertNotNull((Object)lg);
                Assert.assertEquals((Object)LayerGroupInfo.Mode.SINGLE, (Object)lg.getMode());
                Assert.assertEquals((long)1L, (long)lg.getLayers().size());
                Assert.assertEquals(null, lg.getLayers().get(0));
                StyleInfo styleGroup = catalog.getStyleByName("namedstyle");
                Assert.assertNotNull((Object)styleGroup);
                Assert.assertEquals((Object)styleGroup, lg.getStyles().get(0));
            }
        });
    }

    private void loadConcurrently(List<ConfigLoader> loaders) {
        List tasks = loaders.stream().map(l -> new Callable<ConfigLoader>(){

            @Override
            public ConfigLoader call() throws Exception {
                l.loadGeoServer();
                return l;
            }
        }).collect(Collectors.toList());
        List<Future<Future>> futures = ForkJoinPool.commonPool().invokeAll(tasks);
        futures.forEach(f -> {
            try {
                f.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private List<ConfigLoader> createConfigLoaders(int count) {
        GeoServerConfigurationLock configLock = new GeoServerConfigurationLock();
        MemoryLockProvider lockProvider = new MemoryLockProvider();
        return IntStream.range(0, count).mapToObj(arg_0 -> this.lambda$createConfigLoaders$5(configLock, (LockProvider)lockProvider, arg_0)).collect(Collectors.toList());
    }

    private ConfigLoader createConfigLoader(GeoServerConfigurationLock configLock, LockProvider lockProvider) {
        DataDirectoryLoaderTestSupport ddlts = DataDirectoryLoaderTestSupport.withNoPersistence(this.dataDirectory);
        Catalog catalog = ddlts.getCatalog();
        GeoServer gs = ddlts.getGeoServer();
        GeoServerResourceLoader resourceLoader = catalog.getResourceLoader();
        FileSystemResourceStore resourceStore = (FileSystemResourceStore)resourceLoader.getResourceStore();
        resourceStore.setLockProvider(lockProvider);
        GeoServerDataDirectory dd = new GeoServerDataDirectory(this.dataDirectory);
        XStreamPersisterFactory xpf = new XStreamPersisterFactory();
        ArrayList<XStreamServiceLoader> serviceLoaders = new ArrayList<XStreamServiceLoader>();
        serviceLoaders.add(this.support.serviceLoader1);
        serviceLoaders.add(this.support.serviceLoader2);
        DataDirectoryWalker fileWalk = new DataDirectoryWalker(dd, xpf, configLock, serviceLoaders);
        return new ConfigLoader(gs, fileWalk);
    }

    private XmlWebApplicationContext initContext() {
        return this.initNewContext();
    }

    private XmlWebApplicationContext initNewContext() {
        XmlWebApplicationContext webAppContext = this.createContext();
        webAppContext.refresh();
        return webAppContext;
    }

    private XmlWebApplicationContext createContext() {
        MockServletContext servletContext = new MockServletContext();
        XmlWebApplicationContext webAppContext = new XmlWebApplicationContext();
        webAppContext.setConfigLocations(new String[]{"classpath*:/applicationContext.xml", "classpath*:/applicationSecurityContext.xml", "classpath:/org/geoserver/config/datadir/minimalConfigLoaderSupportIntegrationTestContext.xml"});
        webAppContext.setServletContext((ServletContext)servletContext);
        return webAppContext;
    }

    private /* synthetic */ ConfigLoader lambda$createConfigLoaders$5(GeoServerConfigurationLock configLock, LockProvider lockProvider, int i) {
        return this.createConfigLoader(configLock, lockProvider);
    }
}

