/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config;

import java.net.URL;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerFactory;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.LoggingInfo;
import org.geoserver.config.impl.GeoServerFactoryImpl;
import org.geoserver.config.impl.GeoServerImpl;
import org.geoserver.config.util.LegacyConfigurationImporter;
import org.geotools.util.URLs;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LegacyConfigurationImporterTest {
    LegacyConfigurationImporter importer;

    @Before
    public void setUp() throws Exception {
        GeoServerImpl gs = new GeoServerImpl();
        gs.setFactory((GeoServerFactory)new GeoServerFactoryImpl((GeoServer)gs));
        this.importer = new LegacyConfigurationImporter((GeoServer)gs);
        this.importer.imprt(URLs.urlToFile((URL)this.getClass().getResource("services.xml")).getParentFile());
    }

    @Test
    public void testGlobal() throws Exception {
        GeoServerInfo info = this.importer.getConfiguration().getGlobal();
        Assert.assertNotNull((Object)info);
        LoggingInfo logging = this.importer.getConfiguration().getLogging();
        Assert.assertNotNull((Object)logging);
        Assert.assertEquals((Object)"DEFAULT_LOGGING", (Object)logging.getLevel());
        Assert.assertTrue((boolean)logging.isStdOutLogging());
        Assert.assertEquals((Object)"logs/geoserver.log", (Object)logging.getLocation());
        Assert.assertFalse((boolean)info.getSettings().isVerbose());
        Assert.assertFalse((boolean)info.getSettings().isVerboseExceptions());
        Assert.assertEquals((long)8L, (long)info.getSettings().getNumDecimals());
        Assert.assertEquals((Object)"UTF-8", (Object)info.getSettings().getCharset());
        Assert.assertEquals((long)3L, (long)info.getUpdateSequence());
    }
}

