/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config;

import java.io.File;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;
import org.easymock.EasyMock;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.config.GeoServerPropertyOverrideConfigurer;
import org.geoserver.platform.GeoServerResourceLoader;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assume;
import org.junit.Test;

public class GeoServerPropertyOverrideConfigurerTest {
    @Test
    public void testPropertyOverrider() {
        Assume.assumeFalse((boolean)SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_9));
        this.testPropertyOverride("", "", "");
        this.testPropertyOverride("some text", "data dir", "some text");
        this.testPropertyOverride("some ${GEOSERVER_DATA_DIR} text", "", "some  text");
        this.testPropertyOverride("some ${GEOSERVER_DATA_DIR} text", "\\$/", "some \\$/ text");
        this.testPropertyOverride("before/${GEOSERVER_DATA_DIR}/after", "", "before//after");
        this.testPropertyOverride("${GEOSERVER_DATA_DIR}", "/linux/path/", "/linux/path/");
        this.testPropertyOverride("before/${GEOSERVER_DATA_DIR}/after", "linux/path", "before/linux/path/after");
        this.testPropertyOverride("before/a space/${GEOSERVER_DATA_DIR}/after/another space", "linux/path", "before/a space/linux/path/after/another space");
        this.testPropertyOverride("before/a space/${GEOSERVER_DATA_DIR}/after/another space", "linux/a space/path", "before/a space/linux/a space/path/after/another space");
        this.testPropertyOverride("before\\${GEOSERVER_DATA_DIR}\\after", "", "before\\\\after");
        this.testPropertyOverride("${GEOSERVER_DATA_DIR}", "\\linux\\path\\", "\\linux\\path\\");
        this.testPropertyOverride("before\\${GEOSERVER_DATA_DIR}\\after", "linux\\path", "before\\linux\\path\\after");
        this.testPropertyOverride("before\\a space\\${GEOSERVER_DATA_DIR}\\after\\another space", "linux\\path", "before\\a space\\linux\\path\\after\\another space");
        this.testPropertyOverride("before\\a space\\${GEOSERVER_DATA_DIR}\\after\\another space", "linux\\a space\\path", "before\\a space\\linux\\a space\\path\\after\\another space");
        this.testPropertyOverride("/Entit\u00e9G\u00e9n\u00e9rique/${GEOSERVER_DATA_DIR}/\u901a\u7528\u5b9e\u4f53", "some\u00e4/\u00dftext", "/Entit\u00e9G\u00e9n\u00e9rique/some\u00e4/\u00dftext/\u901a\u7528\u5b9e\u4f53");
        this.testPropertyOverride("\\Entit\u00e9G\u00e9n\u00e9rique\\${GEOSERVER_DATA_DIR}\\\u901a\u7528\u5b9e\u4f53", "some\u00e4\\\u00dftext", "\\Entit\u00e9G\u00e9n\u00e9rique\\some\u00e4\\\u00dftext\\\u901a\u7528\u5b9e\u4f53");
    }

    private void testPropertyOverride(String property, String dataDirectoryPath, String expectedResult) {
        GeoServerPropertyOverrideConfigurer overrider = this.getOverriderForPath(dataDirectoryPath);
        String result = overrider.convertPropertyValue(property);
        if (expectedResult == null) {
            MatcherAssert.assertThat((Object)result, (Matcher)Matchers.nullValue());
        } else {
            MatcherAssert.assertThat((Object)result, (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((Object)result, (Matcher)Matchers.is((Object)expectedResult));
        }
    }

    private GeoServerPropertyOverrideConfigurer getOverriderForPath(String dataDirectoryPath) {
        GeoServerDataDirectory dataDirectory = this.createGeoServerDataDirectoryMock(dataDirectoryPath);
        return new GeoServerPropertyOverrideConfigurer(dataDirectory);
    }

    private GeoServerDataDirectory createGeoServerDataDirectoryMock(String path) {
        File mockedPath = (File)EasyMock.createMock(File.class);
        EasyMock.expect((Object)mockedPath.getPath()).andReturn((Object)path).anyTimes();
        GeoServerResourceLoader resourceLoader = (GeoServerResourceLoader)EasyMock.createMock(GeoServerResourceLoader.class);
        EasyMock.expect((Object)resourceLoader.getBaseDirectory()).andReturn((Object)mockedPath).anyTimes();
        EasyMock.replay((Object[])new Object[]{mockedPath, resourceLoader});
        return new GeoServerDataDirectory(resourceLoader);
    }
}

