/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ForkJoinPool;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.CatalogImpl;
import org.geoserver.config.ConfigurationListener;
import org.geoserver.config.ConfigurationListenerAdapter;
import org.geoserver.config.ContactInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.LoggingInfo;
import org.geoserver.config.ServiceInfo;
import org.geoserver.config.SettingsInfo;
import org.geoserver.config.impl.ContactInfoImpl;
import org.geoserver.config.impl.GeoServerImpl;
import org.geoserver.config.impl.GeoServerInfoImpl;
import org.geoserver.config.impl.ServiceInfoImpl;
import org.geoserver.ows.LocalWorkspace;
import org.geoserver.platform.GeoServerExtensionsHelper;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class GeoServerImplTest {
    protected GeoServerImpl geoServer;

    @Before
    public void setUp() throws Exception {
        GeoServerExtensionsHelper.setIsSpringContext(false);
        this.geoServer = this.createGeoServer();
    }

    protected GeoServerImpl createGeoServer() {
        GeoServerImpl gs = new GeoServerImpl();
        gs.setCatalog((Catalog)new CatalogImpl());
        return gs;
    }

    @Test
    public void testGlobal() throws Exception {
        GeoServerInfo global = this.geoServer.getFactory().createGlobal();
        this.geoServer.setGlobal(global);
        Assert.assertEquals((Object)global, (Object)this.geoServer.getGlobal());
        GeoServerInfo global1 = this.geoServer.getFactory().createGlobal();
        GeoServerInfo global2 = this.geoServer.getFactory().createGlobal();
        global1.setGlobalServices(Boolean.valueOf(true));
        global1.setXmlExternalEntitiesEnabled(Boolean.valueOf(false));
        global1.getSettings().setVerbose(false);
        global1.getSettings().setVerboseExceptions(false);
        global2.setGlobalServices(Boolean.valueOf(true));
        global2.setXmlExternalEntitiesEnabled(Boolean.valueOf(false));
        global2.getSettings().setVerbose(false);
        global2.getSettings().setVerboseExceptions(false);
        Assert.assertEquals((Object)global1, (Object)global2);
    }

    @Test
    public void testModifyGlobal() throws Exception {
        GeoServerInfo global = this.geoServer.getFactory().createGlobal();
        this.geoServer.setGlobal(global);
        GeoServerInfo g1 = this.geoServer.getGlobal();
        g1.setAdminPassword("newAdminPassword");
        GeoServerInfo g2 = this.geoServer.getGlobal();
        Assert.assertNull((Object)g2.getAdminPassword());
        this.geoServer.save(g1);
        g2 = this.geoServer.getGlobal();
        Assert.assertEquals((Object)"newAdminPassword", (Object)g2.getAdminPassword());
    }

    @Test
    public void testAddService() throws Exception {
        ServiceInfo service = this.geoServer.getFactory().createService();
        service.setName("foo");
        this.geoServer.add(service);
        ServiceInfo s2 = this.geoServer.getFactory().createService();
        ((ServiceInfoImpl)s2).setId(service.getId());
        try {
            this.geoServer.add(s2);
            Assert.fail((String)"adding service with duplicate id should throw exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ServiceInfo s = this.geoServer.getServiceByName("foo", ServiceInfo.class);
        Assert.assertNotSame((Object)s, (Object)service);
        Assert.assertEquals((Object)service, (Object)s);
    }

    @Test
    public void testModifyService() throws Exception {
        ServiceInfo service = this.geoServer.getFactory().createService();
        ((ServiceInfoImpl)service).setId("id");
        service.setName("foo");
        service.setTitle("bar");
        this.geoServer.add(service);
        ServiceInfo s1 = this.geoServer.getServiceByName("foo", ServiceInfo.class);
        s1.setTitle("changed");
        ServiceInfo s2 = this.geoServer.getServiceByName("foo", ServiceInfo.class);
        Assert.assertEquals((Object)"bar", (Object)s2.getTitle());
        this.geoServer.save(s1);
        s2 = this.geoServer.getServiceByName("foo", ServiceInfo.class);
        Assert.assertEquals((Object)"changed", (Object)s2.getTitle());
    }

    @Test
    public void testGlobalEvents() throws Exception {
        TestListener tl = new TestListener();
        this.geoServer.addListener((ConfigurationListener)tl);
        GeoServerInfo global = this.geoServer.getFactory().createGlobal();
        this.geoServer.setGlobal(global);
        global = this.geoServer.getGlobal();
        global.setAdminPassword("foo");
        global.getSettings().setOnlineResource("bar");
        Assert.assertEquals((long)0L, (long)tl.gPropertyNames.size());
        this.geoServer.save(global);
        Assert.assertEquals((long)2L, (long)tl.gPropertyNames.size());
        Assert.assertTrue((boolean)tl.gPropertyNames.contains("adminPassword"));
        Assert.assertTrue((boolean)tl.gPropertyNames.contains("settings"));
    }

    @Test
    public void testSetClientPropsHasEffect() throws Exception {
        GeoServerInfoImpl gsii = new GeoServerInfoImpl((GeoServer)this.geoServer);
        Map before = gsii.getClientProperties();
        HashMap<String, String> newProps = new HashMap<String, String>();
        newProps.put("123", "456");
        gsii.setClientProperties(newProps);
        Assert.assertNotEquals((Object)before, newProps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetSettings() throws Exception {
        GeoServerInfo global = this.geoServer.getFactory().createGlobal();
        this.geoServer.setGlobal(global);
        SettingsInfo s = this.geoServer.getSettings();
        Assert.assertNotNull((Object)s);
        Assert.assertEquals((long)4L, (long)s.getNumDecimals());
        WorkspaceInfo ws = this.geoServer.getCatalog().getFactory().createWorkspace();
        ws.setName("acme");
        this.geoServer.getCatalog().add(ws);
        SettingsInfo t = this.geoServer.getFactory().createSettings();
        t.setNumDecimals(7);
        t.setWorkspace(ws);
        this.geoServer.add(t);
        Assert.assertNotNull((Object)this.geoServer.getSettings(ws));
        Assert.assertEquals((long)7L, (long)this.geoServer.getSettings(ws).getNumDecimals());
        Assert.assertEquals((long)4L, (long)this.geoServer.getSettings().getNumDecimals());
        LocalWorkspace.set((WorkspaceInfo)ws);
        try {
            Assert.assertNotNull((Object)this.geoServer.getSettings());
            Assert.assertEquals((long)7L, (long)this.geoServer.getSettings().getNumDecimals());
        }
        finally {
            LocalWorkspace.remove();
        }
    }

    @Test
    public void testServiceWithWorkspace() throws Exception {
        WorkspaceInfo ws1 = this.geoServer.getCatalog().getFactory().createWorkspace();
        ws1.setName("TEST-WORKSPACE-1");
        this.geoServer.getCatalog().add(ws1);
        ServiceInfo newService1 = this.geoServer.getFactory().createService();
        newService1.setWorkspace(ws1);
        newService1.setName("SERVICE-1-WS-1");
        newService1.setTitle("Service for WS1");
        this.geoServer.add(newService1);
        ServiceInfo globalService = this.geoServer.getFactory().createService();
        globalService.setName("SERVICE-2-GLOBAL");
        globalService.setTitle("Global Service");
        this.geoServer.add(globalService);
        WorkspaceInfo ws2 = this.geoServer.getCatalog().getFactory().createWorkspace();
        ws2.setName("TEST-WORKSPACE-2");
        this.geoServer.getCatalog().add(ws2);
        ServiceInfo newService2 = this.geoServer.getFactory().createService();
        newService2.setWorkspace(ws2);
        newService2.setName("SERVICE-3-WS-2");
        newService2.setTitle("Service for WS2");
        this.geoServer.add(newService2);
        MatcherAssert.assertThat((Object)this.geoServer.getService(ServiceInfo.class), (Matcher)CoreMatchers.equalTo((Object)globalService));
        MatcherAssert.assertThat((Object)this.geoServer.getService(ws1, ServiceInfo.class), (Matcher)CoreMatchers.equalTo((Object)newService1));
        MatcherAssert.assertThat((Object)this.geoServer.getService(ws2, ServiceInfo.class), (Matcher)CoreMatchers.equalTo((Object)newService2));
        MatcherAssert.assertThat((Object)this.geoServer.getServices(), (Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.hasItem((Object)globalService), CoreMatchers.not((Matcher)CoreMatchers.hasItems((Object[])new ServiceInfo[]{newService1, newService2}))}));
        MatcherAssert.assertThat((Object)this.geoServer.getServices(ws1), (Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.hasItem((Object)newService1), CoreMatchers.not((Matcher)CoreMatchers.hasItems((Object[])new ServiceInfo[]{globalService, newService2}))}));
        MatcherAssert.assertThat((Object)this.geoServer.getServices(ws2), (Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{CoreMatchers.hasItem((Object)newService2), CoreMatchers.not((Matcher)CoreMatchers.hasItems((Object[])new ServiceInfo[]{newService1, globalService}))}));
    }

    @Test
    public void testModifyLogging() {
        LoggingInfo logging = this.geoServer.getLogging();
        logging.setLevel("VERBOSE_LOGGING.properties");
        this.geoServer.save(logging);
        Assert.assertEquals((Object)logging, (Object)this.geoServer.getLogging());
    }

    @Test
    public void testWorkspaceSettingsThreadSafety() throws Exception {
        int parallelism = 8;
        ForkJoinPool executor = new ForkJoinPool(8);
        List<WorkspaceInfo> workspaces = this.addWorkspaces(1000);
        executor.submit(() -> ((Stream)workspaces.stream().parallel()).forEach(this::testWorkspaceSettings)).get();
    }

    private void testWorkspaceSettings(WorkspaceInfo ws) {
        SettingsInfo settings = this.geoServer.getFactory().createSettings();
        settings.setNumDecimals(7);
        settings.setWorkspace(ws);
        this.geoServer.add(settings);
        SettingsInfo s = this.geoServer.getSettings(ws);
        Assert.assertEquals((Object)settings, (Object)s);
        s.setCharset("ISO-8859-1");
        ContactInfoImpl contact = new ContactInfoImpl();
        contact.setContactEmail("john.doe@test.com");
        s.setContact((ContactInfo)contact);
        this.geoServer.save(s);
        Assert.assertEquals((Object)s, (Object)this.geoServer.getSettings(ws));
        this.geoServer.remove(settings);
        Assert.assertNull((Object)this.geoServer.getSettings(ws));
    }

    private List<WorkspaceInfo> addWorkspaces(int count) {
        return IntStream.range(0, count).mapToObj(this::createWorkspace).collect(Collectors.toList());
    }

    private WorkspaceInfo createWorkspace(int i) {
        Catalog catalog = this.geoServer.getCatalog();
        WorkspaceInfo ws = catalog.getFactory().createWorkspace();
        String name = "testws-" + i;
        ws.setName(name);
        catalog.add(ws);
        return catalog.getWorkspaceByName(name);
    }

    @Test
    public void testWorkspaceServicesThreadSafety() throws Exception {
        int parallelism = 8;
        ForkJoinPool executor = new ForkJoinPool(8);
        List<WorkspaceInfo> workspaces = this.addWorkspaces(1000);
        executor.submit(() -> ((Stream)workspaces.stream().parallel()).forEach(this::testWorkspaceServices)).get();
    }

    private void testWorkspaceServices(WorkspaceInfo ws) {
        ServiceInfo s1 = this.geoServer.getFactory().createService();
        s1.setWorkspace(ws);
        ((ServiceInfoImpl)s1).setId(ws.getName() + "-s1");
        s1.setName("s1");
        s1.setTitle("foo");
        ServiceInfo s2 = this.geoServer.getFactory().createService();
        s2.setWorkspace(ws);
        ((ServiceInfoImpl)s2).setId(ws.getName() + "-s2");
        s2.setName("s2");
        s2.setTitle("bar");
        this.geoServer.add(s1);
        this.geoServer.add(s2);
        s1 = this.geoServer.getServiceByName(ws, "s1", ServiceInfo.class);
        Assert.assertNotNull((Object)s1);
        s1.setTitle("changed");
        this.geoServer.save(s1);
        s2 = this.geoServer.getServiceByName(ws, "s2", ServiceInfo.class);
        Assert.assertNotNull((Object)s2);
        s2.setTitle("changed");
        this.geoServer.save(s2);
        Collection services = this.geoServer.getServices(ws);
        Assert.assertEquals(new HashSet<ServiceInfo>(Arrays.asList(s1, s2)), new HashSet(services));
        this.geoServer.remove(s1);
        this.geoServer.remove(s2);
        Assert.assertEquals((long)0L, (long)this.geoServer.getServices(ws).size());
    }

    static class TestListener
    extends ConfigurationListenerAdapter {
        List<String> gPropertyNames = new ArrayList<String>();
        List<Object> gOldValues = new ArrayList<Object>();
        List<Object> gNewValues = new ArrayList<Object>();
        List<String> sPropertyNames = new ArrayList<String>();
        List<Object> sOldValues = new ArrayList<Object>();
        List<Object> sNewValues = new ArrayList<Object>();

        TestListener() {
        }

        public void handleGlobalChange(GeoServerInfo global, List<String> propertyNames, List<Object> oldValues, List<Object> newValues) {
            this.gPropertyNames.addAll(propertyNames);
            this.gOldValues.addAll(oldValues);
            this.gNewValues.addAll(newValues);
        }

        public void handleServiceChange(ServiceInfo service, List<String> propertyNames, List<Object> oldValues, List<Object> newValues) {
            this.sPropertyNames.addAll(propertyNames);
            this.sOldValues.addAll(oldValues);
            this.sNewValues.addAll(newValues);
        }
    }
}

