/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.testreader;

import it.geosolutions.imageioimpl.plugins.tiff.TIFFImageReaderSpi;
import java.awt.Color;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import javax.imageio.spi.ImageInputStreamSpi;
import javax.imageio.stream.ImageInputStream;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import org.geoserver.catalog.testreader.CustomFormat;
import org.geotools.api.coverage.grid.Format;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.parameter.GeneralParameterValue;
import org.geotools.api.parameter.ParameterValue;
import org.geotools.coverage.Category;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.util.CoverageUtilities;
import org.geotools.gce.geotiff.GeoTiffReader;
import org.geotools.image.ImageWorker;
import org.geotools.image.io.ImageIOExt;
import org.geotools.metadata.i18n.Vocabulary;
import org.geotools.util.Converters;
import org.geotools.util.NumberRange;
import org.geotools.util.factory.Hints;

public final class CustomFormatReader
extends AbstractGridCoverage2DReader {
    private static final String MY_DIMENSION_DOMAIN = "MY_DIMENSION_DOMAIN";
    private static final String HAS_MY_DIMENSION_DOMAIN = "HAS_MY_DIMENSION_DOMAIN";
    private static final String MY_DIMENSION_DATATYPE = "MY_DIMENSION_DOMAIN_DATATYPE";
    private static final TIFFImageReaderSpi READER_SPI = new TIFFImageReaderSpi();
    private static final double DEFAULT_NODATA = 9999.0;
    private final File dataDirectory;
    private String clazz;

    public CustomFormatReader(Object source, Hints hints) throws IOException {
        super(source, hints);
        if (!(source instanceof File)) {
            throw new IllegalArgumentException("Invalid source object");
        }
        this.dataDirectory = (File)source;
        this.initReaderFromFile(hints);
    }

    public Format getFormat() {
        return new CustomFormat();
    }

    public GridCoverage2D read(GeneralParameterValue[] params) throws IOException {
        boolean haveDimension = false;
        ArrayList<GridCoverage2D> returnValues = new ArrayList<GridCoverage2D>();
        for (GeneralParameterValue p : params) {
            if (!p.getDescriptor().getName().toString().equalsIgnoreCase("MY_DIMENSION")) continue;
            haveDimension = true;
            List<?> value = CustomFormatReader.extractValue(p);
            block1: for (Object o : value) {
                String s = (String)Converters.convert(o, String.class);
                for (String filename : this.dataDirectory.list()) {
                    String dimValue;
                    if (!CustomFormatReader.isDataFile(filename) || !(dimValue = CustomFormatReader.getDimensionValue(filename)).equalsIgnoreCase(s)) continue;
                    returnValues.add(this.createCoverage(filename));
                    continue block1;
                }
            }
        }
        int size = returnValues.size();
        if (!haveDimension) {
            for (String filename : this.dataDirectory.list()) {
                if (!CustomFormatReader.isDataFile(filename)) continue;
                return this.createCoverage(filename);
            }
        } else if (size > 0) {
            if (size == 1) {
                return (GridCoverage2D)returnValues.get(0);
            }
            ImageWorker worker = new ImageWorker(((GridCoverage2D)returnValues.get(0)).getRenderedImage());
            for (int i = 1; i < size; ++i) {
                worker.addBand(((GridCoverage2D)returnValues.get(i)).getRenderedImage(), false);
            }
            Object[] sds = new GridSampleDimension[size];
            Arrays.fill(sds, ((GridCoverage2D)returnValues.get(0)).getSampleDimensions()[0]);
            return new GridCoverageFactory().create((CharSequence)"result", worker.getRenderedImage(), ((GridCoverage2D)returnValues.get(0)).getEnvelope(), (GridSampleDimension[])sds, null, null);
        }
        return null;
    }

    public String[] getMetadataNames() {
        return new String[]{HAS_MY_DIMENSION_DOMAIN, MY_DIMENSION_DOMAIN};
    }

    public String getMetadataValue(String name) {
        if (HAS_MY_DIMENSION_DOMAIN.equalsIgnoreCase(name)) {
            return String.valueOf(true);
        }
        if (MY_DIMENSION_DOMAIN.equalsIgnoreCase(name)) {
            return this.dimensionValueList();
        }
        if (MY_DIMENSION_DATATYPE.equalsIgnoreCase(name) && this.clazz != null) {
            return this.clazz;
        }
        return null;
    }

    private String dimensionValueList() {
        TreeSet<String> elements = new TreeSet<String>();
        for (String filename : this.dataDirectory.list()) {
            if (!CustomFormatReader.isDataFile(filename)) continue;
            elements.add(CustomFormatReader.getDimensionValue(filename));
        }
        if (elements.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String item : elements) {
            sb.append(item).append(',');
        }
        int len = sb.length();
        return sb.substring(0, len - 1);
    }

    private static String getDimensionValue(String filename) {
        int startInd = filename.indexOf(94) + 1;
        int endInd = filename.lastIndexOf(46);
        return filename.substring(startInd, endInd);
    }

    private void initReaderFromFile(Hints inHints) throws IOException {
        if (!this.dataDirectory.isDirectory()) {
            throw new IOException(this.dataDirectory + " is not a directory");
        }
        File dataFile = null;
        for (String filename : this.dataDirectory.list()) {
            if (!CustomFormatReader.isDataFile(filename)) continue;
            dataFile = new File(this.dataDirectory, filename);
            break;
        }
        if (dataFile == null) {
            throw new IOException("No data file found");
        }
        File clazzFile = new File(this.dataDirectory, "clazz");
        if (clazzFile.exists()) {
            this.clazz = new String(Files.readAllBytes(clazzFile.toPath())).trim();
        }
        GeoTiffReader geotiffReader = new GeoTiffReader((Object)dataFile, this.hints);
        this.crs = geotiffReader.getCoordinateReferenceSystem();
        this.originalGridRange = geotiffReader.getOriginalGridRange();
        this.originalEnvelope = geotiffReader.getOriginalEnvelope();
    }

    private static synchronized RenderedImage readImage(File inFile) throws IOException {
        ParameterBlock readParams = new ParameterBlock();
        ImageInputStreamSpi lSpi = ImageIOExt.getImageInputStreamSPI((Object)inFile);
        ImageInputStream lImgIn = lSpi.createInputStreamInstance(inFile, false, null);
        readParams.add(lImgIn);
        readParams.add(0);
        readParams.add(Boolean.FALSE);
        readParams.add(Boolean.FALSE);
        readParams.add(Boolean.FALSE);
        readParams.add(null);
        readParams.add(null);
        readParams.add(null);
        readParams.add(READER_SPI.createReaderInstance());
        RenderedOp lImage = JAI.create((String)"ImageRead", (ParameterBlock)readParams, null);
        String lFileName = inFile.getName();
        int lExtIndex = lFileName.lastIndexOf(46);
        String lFileNameNoExt = lExtIndex < 0 ? lFileName : lFileName.substring(0, lExtIndex);
        lImage.setProperty("name", (Object)lFileNameNoExt);
        return lImage;
    }

    private GridCoverage2D createCoverage(String filename) throws IOException {
        File dataFile = new File(this.dataDirectory, filename);
        RenderedImage image = CustomFormatReader.readImage(dataFile);
        return this.createCoverage(String.valueOf(image.getProperty("name")), image);
    }

    private GridCoverage2D createCoverage(String name, RenderedImage image) {
        Category noDataCategory = new Category((CharSequence)Vocabulary.formatInternational((int)147), new Color[]{new Color(0, 0, 0, 0)}, NumberRange.create((double)9999.0, (double)9999.0));
        Category[] categories = new Category[]{noDataCategory};
        GridSampleDimension[] bands = new GridSampleDimension[]{new GridSampleDimension(null, categories, null)};
        HashMap properties = new HashMap();
        CoverageUtilities.setNoDataProperty(properties, (Object)9999.0);
        return this.coverageFactory.create((CharSequence)name, image, (Bounds)this.originalEnvelope, bands, null, properties);
    }

    private static boolean isDataFile(String filename) {
        return filename.endsWith(".tif") || filename.endsWith(".tiff");
    }

    private static List<?> extractValue(GeneralParameterValue param) {
        Object paramVal;
        if (param instanceof ParameterValue && (paramVal = ((ParameterValue)param).getValue()) != null) {
            if (paramVal instanceof List) {
                List list = (List)paramVal;
                return list;
            }
            throw new UnsupportedOperationException("Custom dimension value must be a list");
        }
        throw new UnsupportedOperationException("Custom dimension value must be a list");
    }
}

